"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3accounttypeenum import V3AccountTypeEnum
from datetime import datetime
from formance_sdk_python.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Dict
from typing_extensions import Annotated, NotRequired, TypedDict


class V3CreateAccountRequestTypedDict(TypedDict):
    account_name: str
    connector_id: str
    created_at: datetime
    reference: str
    type: V3AccountTypeEnum
    default_asset: NotRequired[Nullable[str]]
    metadata: NotRequired[Nullable[Dict[str, str]]]


class V3CreateAccountRequest(BaseModel):
    account_name: Annotated[str, pydantic.Field(alias="accountName")]

    connector_id: Annotated[str, pydantic.Field(alias="connectorID")]

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]

    reference: str

    type: V3AccountTypeEnum

    default_asset: Annotated[
        OptionalNullable[str], pydantic.Field(alias="defaultAsset")
    ] = UNSET

    metadata: OptionalNullable[Dict[str, str]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["defaultAsset", "metadata"]
        nullable_fields = ["defaultAsset", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
