"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    v2testtriggerresponse as shared_v2testtriggerresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import httpx
import pydantic
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TestTriggerRequestTypedDict(TypedDict):
    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    trigger_id: str
    r"""The trigger id"""
    request_body: NotRequired[Dict[str, Any]]


class TestTriggerRequest(BaseModel):
    __test__ = False

    trigger_id: Annotated[
        str,
        pydantic.Field(alias="triggerID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The trigger id"""

    request_body: Annotated[
        Optional[Dict[str, Any]],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class TestTriggerResponseTypedDict(TypedDict):
    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    v2_test_trigger_response: NotRequired[
        shared_v2testtriggerresponse.V2TestTriggerResponseTypedDict
    ]
    r"""Test a trigger"""


class TestTriggerResponse(BaseModel):
    __test__ = False

    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    v2_test_trigger_response: Optional[
        shared_v2testtriggerresponse.V2TestTriggerResponse
    ] = None
    r"""Test a trigger"""
