"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from formance_sdk_python.models.shared import (
    v3balancescursorresponse as shared_v3balancescursorresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3GetAccountBalancesRequestTypedDict(TypedDict):
    account_id: str
    r"""The account ID"""
    asset: NotRequired[str]
    r"""The asset to filter by"""
    cursor: NotRequired[str]
    r"""Parameter used in pagination requests. Set to the value of next for the next page of results. Set to the value of previous for the previous page of results. No other parameters can be set when this parameter is set.

    """
    from_timestamp: NotRequired[datetime]
    r"""The start of the time range to filter by"""
    page_size: NotRequired[int]
    r"""The number of items to return"""
    to_timestamp: NotRequired[datetime]
    r"""The end of the time range to filter by"""


class V3GetAccountBalancesRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The account ID"""

    asset: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The asset to filter by"""

    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Parameter used in pagination requests. Set to the value of next for the next page of results. Set to the value of previous for the previous page of results. No other parameters can be set when this parameter is set.

    """

    from_timestamp: Annotated[
        Optional[datetime],
        pydantic.Field(alias="fromTimestamp"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The start of the time range to filter by"""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="pageSize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The number of items to return"""

    to_timestamp: Annotated[
        Optional[datetime],
        pydantic.Field(alias="toTimestamp"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The end of the time range to filter by"""


class V3GetAccountBalancesResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    v3_balances_cursor_response: NotRequired[
        shared_v3balancescursorresponse.V3BalancesCursorResponseTypedDict
    ]
    r"""OK"""


class V3GetAccountBalancesResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    v3_balances_cursor_response: Optional[
        shared_v3balancescursorresponse.V3BalancesCursorResponse
    ] = None
    r"""OK"""
