"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    getholdsresponse as shared_getholdsresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import FieldMetadata, QueryParamMetadata
import httpx
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetHoldsRequestTypedDict(TypedDict):
    cursor: NotRequired[str]
    r"""Parameter used in pagination requests.
    Set to the value of next for the next page of results.
    Set to the value of previous for the previous page of results.
    No other parameters can be set when the pagination token is set.

    """
    metadata: NotRequired[Dict[str, str]]
    r"""Filter holds by metadata key value pairs. Nested objects can be used as seen in the example below."""
    page_size: NotRequired[int]
    r"""The maximum number of results to return per page"""
    wallet_id: NotRequired[str]
    r"""The wallet to filter on"""


class GetHoldsRequest(BaseModel):
    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Parameter used in pagination requests.
    Set to the value of next for the next page of results.
    Set to the value of previous for the previous page of results.
    No other parameters can be set when the pagination token is set.

    """

    metadata: Annotated[
        Optional[Dict[str, str]],
        FieldMetadata(query=QueryParamMetadata(style="deepObject", explode=True)),
    ] = None
    r"""Filter holds by metadata key value pairs. Nested objects can be used as seen in the example below."""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="pageSize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 15
    r"""The maximum number of results to return per page"""

    wallet_id: Annotated[
        Optional[str],
        pydantic.Field(alias="walletID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The wallet to filter on"""


class GetHoldsResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    get_holds_response: NotRequired[shared_getholdsresponse.GetHoldsResponseTypedDict]
    r"""Holds"""


class GetHoldsResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    get_holds_response: Optional[shared_getholdsresponse.GetHoldsResponse] = None
    r"""Holds"""
