"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
from enum import Enum
from formance_sdk_python.models.errors import SDKBaseError
from formance_sdk_python.types import BaseModel
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated


class V2ErrorErrorCode(str, Enum):
    VALIDATION = "VALIDATION"
    NOT_FOUND = "NOT_FOUND"
    INTERNAL = "INTERNAL"


class V2ErrorData(BaseModel):
    error_code: Annotated[V2ErrorErrorCode, pydantic.Field(alias="errorCode")]

    error_message: Annotated[str, pydantic.Field(alias="errorMessage")]


@dataclass(frozen=True)
class V2Error(SDKBaseError):
    r"""General error"""

    data: V2ErrorData = field(hash=False)

    def __init__(
        self,
        data: V2ErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
