"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import httpx
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class MetadataTypedDict(TypedDict):
    r"""Filter transactions by metadata key value pairs. Nested objects can be used as seen in the example below."""


class Metadata(BaseModel):
    r"""Filter transactions by metadata key value pairs. Nested objects can be used as seen in the example below."""


class CountTransactionsRequestTypedDict(TypedDict):
    ledger: str
    r"""Name of the ledger."""
    account: NotRequired[str]
    r"""Filter transactions with postings involving given account, either as source or destination (regular expression placed between ^ and $)."""
    destination: NotRequired[str]
    r"""Filter transactions with postings involving given account at destination (regular expression placed between ^ and $)."""
    end_time: NotRequired[datetime]
    r"""Filter transactions that occurred before this timestamp.
    The format is RFC3339 and is exclusive (for example, \"2023-01-02T15:04:01Z\" excludes the first second of 4th minute).

    """
    metadata: NotRequired[MetadataTypedDict]
    r"""Filter transactions by metadata key value pairs. Nested objects can be used as seen in the example below."""
    reference: NotRequired[str]
    r"""Filter transactions by reference field."""
    source: NotRequired[str]
    r"""Filter transactions with postings involving given account at source (regular expression placed between ^ and $)."""
    start_time: NotRequired[datetime]
    r"""Filter transactions that occurred after this timestamp.
    The format is RFC3339 and is inclusive (for example, \"2023-01-02T15:04:01Z\" includes the first second of 4th minute).

    """


class CountTransactionsRequest(BaseModel):
    ledger: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Name of the ledger."""

    account: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter transactions with postings involving given account, either as source or destination (regular expression placed between ^ and $)."""

    destination: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter transactions with postings involving given account at destination (regular expression placed between ^ and $)."""

    end_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="endTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter transactions that occurred before this timestamp.
    The format is RFC3339 and is exclusive (for example, \"2023-01-02T15:04:01Z\" excludes the first second of 4th minute).

    """

    metadata: Annotated[
        Optional[Metadata],
        FieldMetadata(query=QueryParamMetadata(style="deepObject", explode=True)),
    ] = None
    r"""Filter transactions by metadata key value pairs. Nested objects can be used as seen in the example below."""

    reference: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter transactions by reference field."""

    source: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter transactions with postings involving given account at source (regular expression placed between ^ and $)."""

    start_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="startTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter transactions that occurred after this timestamp.
    The format is RFC3339 and is inclusive (for example, \"2023-01-02T15:04:01Z\" includes the first second of 4th minute).

    """


class CountTransactionsResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    headers: Dict[str, List[str]]
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""


class CountTransactionsResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    headers: Dict[str, List[str]]

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
