"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    script as shared_script,
    scriptresponse as shared_scriptresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import httpx
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RunScriptRequestTypedDict(TypedDict):
    script: shared_script.ScriptTypedDict
    ledger: str
    r"""Name of the ledger."""
    preview: NotRequired[bool]
    r"""Set the preview mode. Preview mode doesn't add the logs to the database or publish a message to the message broker."""


class RunScriptRequest(BaseModel):
    script: Annotated[
        shared_script.Script,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    ledger: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Name of the ledger."""

    preview: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set the preview mode. Preview mode doesn't add the logs to the database or publish a message to the message broker."""


class RunScriptResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    script_response: NotRequired[shared_scriptresponse.ScriptResponseTypedDict]
    r"""On success, it will return a 200 status code, and the resulting transaction under the `transaction` field.

    On failure, it will also return a 200 status code, and the following fields:

    - `details`: contains a URL. When there is an error parsing Numscript, the result can be difficult to read—the provided URL will render the error in an easy-to-read format.
    - `errorCode` and `error_code` (deprecated): contains the string code of the error
    - `errorMessage` and `error_message` (deprecated): contains a human-readable indication of what went wrong, for example that an account had insufficient funds, or that there was an error in the provided Numscript.

    """


class RunScriptResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    script_response: Optional[shared_scriptresponse.ScriptResponse] = None
    r"""On success, it will return a 200 status code, and the resulting transaction under the `transaction` field.

    On failure, it will also return a 200 status code, and the following fields:

    - `details`: contains a URL. When there is an error parsing Numscript, the result can be difficult to read—the provided URL will render the error in an easy-to-read format.
    - `errorCode` and `error_code` (deprecated): contains the string code of the error
    - `errorMessage` and `error_message` (deprecated): contains a human-readable indication of what went wrong, for example that an account had insufficient funds, or that there was an error in the provided Numscript.

    """
