"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    v2createtransactionresponse as shared_v2createtransactionresponse,
    v2posttransaction as shared_v2posttransaction,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V2CreateTransactionRequestTypedDict(TypedDict):
    v2_post_transaction: shared_v2posttransaction.V2PostTransactionTypedDict
    r"""The request body must contain at least one of the following objects:
    - `postings`: suitable for simple transactions
    - `script`: enabling more complex transactions with Numscript

    """
    ledger: str
    r"""Name of the ledger."""
    idempotency_key: NotRequired[str]
    r"""Use an idempotency key"""
    dry_run: NotRequired[bool]
    r"""Set the dryRun mode. dry run mode doesn't add the logs to the database or publish a message to the message broker."""
    force: NotRequired[bool]
    r"""Disable balance checks when passing postings"""


class V2CreateTransactionRequest(BaseModel):
    v2_post_transaction: Annotated[
        shared_v2posttransaction.V2PostTransaction,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""The request body must contain at least one of the following objects:
    - `postings`: suitable for simple transactions
    - `script`: enabling more complex transactions with Numscript

    """

    ledger: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Name of the ledger."""

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="Idempotency-Key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Use an idempotency key"""

    dry_run: Annotated[
        Optional[bool],
        pydantic.Field(alias="dryRun"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set the dryRun mode. dry run mode doesn't add the logs to the database or publish a message to the message broker."""

    force: Annotated[
        Optional[bool],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Disable balance checks when passing postings"""


class V2CreateTransactionResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    v2_create_transaction_response: NotRequired[
        shared_v2createtransactionresponse.V2CreateTransactionResponseTypedDict
    ]
    r"""OK"""


class V2CreateTransactionResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    v2_create_transaction_response: Optional[
        shared_v2createtransactionresponse.V2CreateTransactionResponse
    ] = None
    r"""OK"""
