"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import v2pipeline as shared_v2pipeline
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import FieldMetadata, PathParamMetadata
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V2GetPipelineStateRequestTypedDict(TypedDict):
    ledger: str
    r"""Name of the ledger."""
    pipeline_id: str
    r"""The pipeline id"""


class V2GetPipelineStateRequest(BaseModel):
    ledger: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Name of the ledger."""

    pipeline_id: Annotated[
        str,
        pydantic.Field(alias="pipelineID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The pipeline id"""


class V2GetPipelineStateResponseBodyTypedDict(TypedDict):
    r"""Pipeline information"""

    data: shared_v2pipeline.V2PipelineTypedDict


class V2GetPipelineStateResponseBody(BaseModel):
    r"""Pipeline information"""

    data: shared_v2pipeline.V2Pipeline


class V2GetPipelineStateResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    object: NotRequired[V2GetPipelineStateResponseBodyTypedDict]
    r"""Pipeline information"""


class V2GetPipelineStateResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    object: Optional[V2GetPipelineStateResponseBody] = None
    r"""Pipeline information"""
