"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from formance_sdk_python.models.shared import (
    v2ledgerlistresponse as shared_v2ledgerlistresponse,
)
from formance_sdk_python.types import BaseModel
from formance_sdk_python.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
import httpx
import pydantic
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V2ListLedgersRequestTypedDict(TypedDict):
    request_body: Dict[str, Any]
    cursor: NotRequired[str]
    r"""Parameter used in pagination requests. Maximum page size is set to 15.
    Set to the value of next for the next page of results.
    Set to the value of previous for the previous page of results.
    No other parameters can be set when this parameter is set.

    """
    page_size: NotRequired[int]
    r"""The maximum number of results to return per page.

    """
    sort: NotRequired[str]
    r"""Sort results using a field name and order (ascending or descending).
    Format: `<field>:<order>`, where `<field>` is the field name and `<order>` is either `asc` or `desc`.

    """


class V2ListLedgersRequest(BaseModel):
    request_body: Annotated[
        Dict[str, Any],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Parameter used in pagination requests. Maximum page size is set to 15.
    Set to the value of next for the next page of results.
    Set to the value of previous for the previous page of results.
    No other parameters can be set when this parameter is set.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="pageSize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The maximum number of results to return per page.

    """

    sort: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Sort results using a field name and order (ascending or descending).
    Format: `<field>:<order>`, where `<field>` is the field name and `<order>` is either `asc` or `desc`.

    """


class V2ListLedgersResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    v2_ledger_list_response: NotRequired[
        shared_v2ledgerlistresponse.V2LedgerListResponseTypedDict
    ]
    r"""OK"""


class V2ListLedgersResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    v2_ledger_list_response: Optional[
        shared_v2ledgerlistresponse.V2LedgerListResponse
    ] = None
    r"""OK"""
