"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .posting import Posting, PostingTypedDict
from .volume import Volume, VolumeTypedDict
from datetime import datetime
from formance_sdk_python.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from formance_sdk_python.utils import validate_int
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import BeforeValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TransactionTypedDict(TypedDict):
    postings: List[PostingTypedDict]
    timestamp: datetime
    txid: int
    metadata: NotRequired[Nullable[Dict[str, Any]]]
    post_commit_volumes: NotRequired[Dict[str, Dict[str, VolumeTypedDict]]]
    pre_commit_volumes: NotRequired[Dict[str, Dict[str, VolumeTypedDict]]]
    reference: NotRequired[str]


class Transaction(BaseModel):
    postings: List[Posting]

    timestamp: datetime

    txid: Annotated[int, BeforeValidator(validate_int)]

    metadata: OptionalNullable[Dict[str, Any]] = UNSET

    post_commit_volumes: Annotated[
        Optional[Dict[str, Dict[str, Volume]]],
        pydantic.Field(alias="postCommitVolumes"),
    ] = None

    pre_commit_volumes: Annotated[
        Optional[Dict[str, Dict[str, Volume]]], pydantic.Field(alias="preCommitVolumes")
    ] = None

    reference: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "metadata",
            "postCommitVolumes",
            "preCommitVolumes",
            "reference",
        ]
        nullable_fields = ["metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
