"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3addressrequest import V3AddressRequest, V3AddressRequestTypedDict
from .v3contactdetailsrequest import (
    V3ContactDetailsRequest,
    V3ContactDetailsRequestTypedDict,
)
from formance_sdk_python.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3CreatePaymentServiceUserRequestTypedDict(TypedDict):
    name: str
    address: NotRequired[V3AddressRequestTypedDict]
    bank_account_i_ds: NotRequired[Nullable[List[str]]]
    contact_details: NotRequired[V3ContactDetailsRequestTypedDict]
    metadata: NotRequired[Nullable[Dict[str, str]]]


class V3CreatePaymentServiceUserRequest(BaseModel):
    name: str

    address: Optional[V3AddressRequest] = None

    bank_account_i_ds: Annotated[
        OptionalNullable[List[str]], pydantic.Field(alias="bankAccountIDs")
    ] = UNSET

    contact_details: Annotated[
        Optional[V3ContactDetailsRequest], pydantic.Field(alias="contactDetails")
    ] = None

    metadata: OptionalNullable[Dict[str, str]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["address", "bankAccountIDs", "contactDetails", "metadata"]
        nullable_fields = ["bankAccountIDs", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
