from abc import ABCMeta, abstractmethod
from fputils import Either as Either, Left as Left, Right as Right
from typing import Callable

class Option[A](metaclass=ABCMeta):
    @abstractmethod
    def __iter__(self): ...
    @abstractmethod
    def get(self) -> A: ...
    @abstractmethod
    def is_defined(self) -> bool: ...
    @abstractmethod
    def is_empty(self) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def contains(self, value: A) -> bool: ...
    def exists(self, predicate: Callable[[A], bool]) -> bool: ...
    def filter(self, predicate: Callable[[A], bool]) -> Option[A]: ...
    def filter_not(self, predicate: Callable[[A], bool]) -> Option[A]: ...
    def flatmap[B](self, f: Callable[[A], Option[B]]) -> Option[B]: ...
    def map[B](self, f: Callable[[A], B]) -> Option[B]: ...
    def flatten[B](self) -> Option[B]: ...
    def fold[B](self, f: Callable[[A], B], if_empty: B) -> B: ...
    def forall(self, predicate: Callable[[A], bool]) -> bool: ...
    def foreach(self, f: Callable[[A], None]) -> None: ...
    def get_or_else(self, other: A) -> A: ...
    def or_else(self, other: Option[A]) -> Option[A]: ...
    def or_none(self) -> A | None: ...
    def to_left[B](self, right: B) -> Either[A, B]: ...
    def to_right[B](self, left: B) -> Either[B, A]: ...
    def unzip[B](self) -> tuple[Option[A], Option[B]]: ...
    def zip[B](self, other: Option[B]) -> Option[tuple[A, B]]: ...

class Some[A](Option[A]):
    def __init__(self, value: A) -> None: ...
    def get(self) -> A: ...
    def is_defined(self) -> bool: ...
    def is_empty(self) -> bool: ...
    def __iter__(self): ...

class Empty(Option):
    def get(self) -> None: ...
    def is_defined(self) -> bool: ...
    def is_empty(self) -> bool: ...
    def __iter__(self): ...
