from abc import ABCMeta, abstractmethod
from typing import Callable

class Either[A, B](metaclass=ABCMeta):
    @abstractmethod
    def is_left(self) -> bool: ...
    @abstractmethod
    def is_right(self) -> bool: ...
    def contains(self, value: B) -> bool: ...
    def exists(self, predicate: Callable[[B], bool]) -> bool: ...
    def filter_or_else(
        self, predicate: Callable[[B], bool], other: A
    ) -> Either[A, B]: ...
    def flatmap[B1](self, f: Callable[[B], Either[A, B1]]) -> Either[A, B1]: ...
    def flatten[B1](self) -> Either[A, B1]: ...
    def fold[C](self, fa: Callable[[A], C], fb: Callable[[B], C]) -> C: ...
    def forall(self, f: Callable[[B], bool]) -> bool: ...
    def foreach(self, f: Callable[[B], None]) -> None: ...
    def get_or_else(self, other: B) -> B: ...
    def map(self, f: Callable[[B], B]) -> Either[A, B]: ...
    def or_else(self, other: Either) -> Either[A, B]: ...
    def swap(self) -> Either[B, A]: ...
    def to_list(self) -> list[B]: ...

class Left[A, B](Either[A, B]):
    def __init__(self, value: A) -> None: ...
    def is_left(self) -> bool: ...
    def is_right(self) -> bool: ...

class Right[A, B](Either[A, B]):
    def __init__(self, value: B) -> None: ...
    def is_left(self) -> bool: ...
    def is_right(self) -> bool: ...
