from typing import Optional

from ariadne_codegen.plugins.base import Plugin


class GenerateFileComment(Plugin):
    def get_file_comment(
        self, comment: str, code: str, source: Optional[str] = None
    ) -> str:
        comment_lines = ["# Generated by fragment (with the help of ariadne-codegen)"]
        codegen_dict = self.config_dict.get("tool", {}).get("ariadne-codegen", {})
        schema_path = codegen_dict.get("schema_path", "")
        queries_path = codegen_dict.get("queries_path", "")
        if source == queries_path:
            comment_lines.append(f"# Source: {source}")
        elif source == schema_path:
            comment_lines.append(f"# Source: schema.graphql")
        return "\n".join(comment_lines)
