/*
 * freeglut_stroke_mono_roman.c
 *
 * freeglut Monospace Roman stroke font definition
 *
 * Copyright (c) 1999-2000 Pawel W. Olszta. All Rights Reserved.
 * Written by Pawel W. Olszta, <olszta@sourceforge.net>
 * Creation date: Thu Dec 16 1999
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * PAWEL W. OLSZTA BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/* This file has been automatically generated by the genstroke utility. */

#include <cstdlib>

#include "freeglut_minimal.h"

namespace freeglut_minimal {

/* char: 0x20 */

static const SFG_StrokeStrip kCh32st[] = {{0, nullptr}};

static const SFG_StrokeChar kCh32 = {104.762F, 0, kCh32st};

/* char: 0x21 */

static const SFG_StrokeVertex kCh33st0[] = {{52.381F, 100.0F},
                                            {52.381F, 33.3333F}};

static const SFG_StrokeVertex kCh33st1[] = {{52.381F, 9.5238F},
                                            {47.6191F, 4.7619F},
                                            {52.381F, 0.0F},
                                            {57.1429F, 4.7619F},
                                            {52.381F, 9.5238F}};

static const SFG_StrokeStrip kCh33st[] = {{2, kCh33st0}, {5, kCh33st1}};

static const SFG_StrokeChar kCh33 = {104.762F, 2, kCh33st};

/* char: 0x22 */

static const SFG_StrokeVertex kCh34st0[] = {{33.3334F, 100.0F},
                                            {33.3334F, 66.6667F}};

static const SFG_StrokeVertex kCh34st1[] = {{71.4286F, 100.0F},
                                            {71.4286F, 66.6667F}};

static const SFG_StrokeStrip kCh34st[] = {{2, kCh34st0}, {2, kCh34st1}};

static const SFG_StrokeChar kCh34 = {104.762F, 2, kCh34st};

/* char: 0x23 */

static const SFG_StrokeVertex kCh35st0[] = {{54.7619F, 119.048F},
                                            {21.4286F, -33.3333F}};

static const SFG_StrokeVertex kCh35st1[] = {{83.3334F, 119.048F},
                                            {50.0F, -33.3333F}};

static const SFG_StrokeVertex kCh35st2[] = {{21.4286F, 57.1429F},
                                            {88.0952F, 57.1429F}};

static const SFG_StrokeVertex kCh35st3[] = {{16.6667F, 28.5714F},
                                            {83.3334F, 28.5714F}};

static const SFG_StrokeStrip kCh35st[] = {
    {2, kCh35st0}, {2, kCh35st1}, {2, kCh35st2}, {2, kCh35st3}};

static const SFG_StrokeChar kCh35 = {104.762F, 4, kCh35st};

/* char: 0x24 */

static const SFG_StrokeVertex kCh36st0[] = {{42.8571F, 119.048F},
                                            {42.8571F, -19.0476F}};

static const SFG_StrokeVertex kCh36st1[] = {{61.9047F, 119.048F},
                                            {61.9047F, -19.0476F}};

static const SFG_StrokeVertex kCh36st2[] = {
    {85.7143F, 85.7143F}, {76.1905F, 95.2381F}, {61.9047F, 100.0F},
    {42.8571F, 100.0F},   {28.5714F, 95.2381F}, {19.0476F, 85.7143F},
    {19.0476F, 76.1905F}, {23.8095F, 66.6667F}, {28.5714F, 61.9048F},
    {38.0952F, 57.1429F}, {66.6666F, 47.619F},  {76.1905F, 42.8571F},
    {80.9524F, 38.0952F}, {85.7143F, 28.5714F}, {85.7143F, 14.2857F},
    {76.1905F, 4.7619F},  {61.9047F, 0.0F},     {42.8571F, 0.0F},
    {28.5714F, 4.7619F},  {19.0476F, 14.2857F}};

static const SFG_StrokeStrip kCh36st[] = {
    {2, kCh36st0}, {2, kCh36st1}, {20, kCh36st2}};

static const SFG_StrokeChar kCh36 = {104.762F, 3, kCh36st};

/* char: 0x25 */

static const SFG_StrokeVertex kCh37st0[] = {{95.2381F, 100.0F},
                                            {9.5238F, 0.0F}};

static const SFG_StrokeVertex kCh37st1[] = {
    {33.3333F, 100.0F},   {42.8571F, 90.4762F}, {42.8571F, 80.9524F},
    {38.0952F, 71.4286F}, {28.5714F, 66.6667F}, {19.0476F, 66.6667F},
    {9.5238F, 76.1905F},  {9.5238F, 85.7143F},  {14.2857F, 95.2381F},
    {23.8095F, 100.0F},   {33.3333F, 100.0F},   {42.8571F, 95.2381F},
    {57.1428F, 90.4762F}, {71.4286F, 90.4762F}, {85.7143F, 95.2381F},
    {95.2381F, 100.0F}};

static const SFG_StrokeVertex kCh37st2[] = {
    {76.1905F, 33.3333F}, {66.6667F, 28.5714F}, {61.9048F, 19.0476F},
    {61.9048F, 9.5238F},  {71.4286F, 0.0F},     {80.9524F, 0.0F},
    {90.4762F, 4.7619F},  {95.2381F, 14.2857F}, {95.2381F, 23.8095F},
    {85.7143F, 33.3333F}, {76.1905F, 33.3333F}};

static const SFG_StrokeStrip kCh37st[] = {
    {2, kCh37st0}, {16, kCh37st1}, {11, kCh37st2}};

static const SFG_StrokeChar kCh37 = {104.762F, 3, kCh37st};

/* char: 0x26 */

static const SFG_StrokeVertex kCh38st0[] = {
    {100.0F, 57.1429F},   {100.0F, 61.9048F},   {95.2381F, 66.6667F},
    {90.4762F, 66.6667F}, {85.7143F, 61.9048F}, {80.9524F, 52.381F},
    {71.4286F, 28.5714F}, {61.9048F, 14.2857F}, {52.3809F, 4.7619F},
    {42.8571F, 0.0F},     {23.8095F, 0.0F},     {14.2857F, 4.7619F},
    {9.5238F, 9.5238F},   {4.7619F, 19.0476F},  {4.7619F, 28.5714F},
    {9.5238F, 38.0952F},  {14.2857F, 42.8571F}, {47.619F, 61.9048F},
    {52.3809F, 66.6667F}, {57.1429F, 76.1905F}, {57.1429F, 85.7143F},
    {52.3809F, 95.2381F}, {42.8571F, 100.0F},   {33.3333F, 95.2381F},
    {28.5714F, 85.7143F}, {28.5714F, 76.1905F}, {33.3333F, 61.9048F},
    {42.8571F, 47.619F},  {66.6667F, 14.2857F}, {76.1905F, 4.7619F},
    {85.7143F, 0.0F},     {95.2381F, 0.0F},     {100.0F, 4.7619F},
    {100.0F, 9.5238F}};

static const SFG_StrokeStrip kCh38st[] = {{34, kCh38st0}};

static const SFG_StrokeChar kCh38 = {104.762F, 1, kCh38st};

/* char: 0x27 */

static const SFG_StrokeVertex kCh39st0[] = {{52.381F, 100.0F},
                                            {52.381F, 66.6667F}};

static const SFG_StrokeStrip kCh39st[] = {{2, kCh39st0}};

static const SFG_StrokeChar kCh39 = {104.762F, 1, kCh39st};

/* char: 0x28 */

static const SFG_StrokeVertex kCh40st0[] = {
    {69.0476F, 119.048F}, {59.5238F, 109.524F}, {50.0F, 95.2381F},
    {40.4762F, 76.1905F}, {35.7143F, 52.381F},  {35.7143F, 33.3333F},
    {40.4762F, 9.5238F},  {50.0F, -9.5238F},    {59.5238F, -23.8095F},
    {69.0476F, -33.3333F}};

static const SFG_StrokeStrip kCh40st[] = {{10, kCh40st0}};

static const SFG_StrokeChar kCh40 = {104.762F, 1, kCh40st};

/* char: 0x29 */

static const SFG_StrokeVertex kCh41st0[] = {
    {35.7143F, 119.048F}, {45.2381F, 109.524F}, {54.7619F, 95.2381F},
    {64.2857F, 76.1905F}, {69.0476F, 52.381F},  {69.0476F, 33.3333F},
    {64.2857F, 9.5238F},  {54.7619F, -9.5238F}, {45.2381F, -23.8095F},
    {35.7143F, -33.3333F}};

static const SFG_StrokeStrip kCh41st[] = {{10, kCh41st0}};

static const SFG_StrokeChar kCh41 = {104.762F, 1, kCh41st};

/* char: 0x2a */

static const SFG_StrokeVertex kCh42st0[] = {{52.381F, 71.4286F},
                                            {52.381F, 14.2857F}};

static const SFG_StrokeVertex kCh42st1[] = {{28.5715F, 57.1429F},
                                            {76.1905F, 28.5714F}};

static const SFG_StrokeVertex kCh42st2[] = {{76.1905F, 57.1429F},
                                            {28.5715F, 28.5714F}};

static const SFG_StrokeStrip kCh42st[] = {
    {2, kCh42st0}, {2, kCh42st1}, {2, kCh42st2}};

static const SFG_StrokeChar kCh42 = {104.762F, 3, kCh42st};

/* char: 0x2b */

static const SFG_StrokeVertex kCh43st0[] = {{52.3809F, 85.7143F},
                                            {52.3809F, 0.0F}};

static const SFG_StrokeVertex kCh43st1[] = {{9.5238F, 42.8571F},
                                            {95.2381F, 42.8571F}};

static const SFG_StrokeStrip kCh43st[] = {{2, kCh43st0}, {2, kCh43st1}};

static const SFG_StrokeChar kCh43 = {104.762F, 2, kCh43st};

/* char: 0x2c */

static const SFG_StrokeVertex kCh44st0[] = {
    {57.1429F, 4.7619F},  {52.381F, 0.0F},      {47.6191F, 4.7619F},
    {52.381F, 9.5238F},   {57.1429F, 4.7619F},  {57.1429F, -4.7619F},
    {52.381F, -14.2857F}, {47.6191F, -19.0476F}};

static const SFG_StrokeStrip kCh44st[] = {{8, kCh44st0}};

static const SFG_StrokeChar kCh44 = {104.762F, 1, kCh44st};

/* char: 0x2d */

static const SFG_StrokeVertex kCh45st0[] = {{9.5238F, 42.8571F},
                                            {95.2381F, 42.8571F}};

static const SFG_StrokeStrip kCh45st[] = {{2, kCh45st0}};

static const SFG_StrokeChar kCh45 = {104.762F, 1, kCh45st};

/* char: 0x2e */

static const SFG_StrokeVertex kCh46st0[] = {{52.381F, 9.5238F},
                                            {47.6191F, 4.7619F},
                                            {52.381F, 0.0F},
                                            {57.1429F, 4.7619F},
                                            {52.381F, 9.5238F}};

static const SFG_StrokeStrip kCh46st[] = {{5, kCh46st0}};

static const SFG_StrokeChar kCh46 = {104.762F, 1, kCh46st};

/* char: 0x2f */

static const SFG_StrokeVertex kCh47st0[] = {{19.0476F, -14.2857F},
                                            {85.7143F, 100.0F}};

static const SFG_StrokeStrip kCh47st[] = {{2, kCh47st0}};

static const SFG_StrokeChar kCh47 = {104.762F, 1, kCh47st};

/* char: 0x30 */

static const SFG_StrokeVertex kCh48st0[] = {
    {47.619F, 100.0F},    {33.3333F, 95.2381F}, {23.8095F, 80.9524F},
    {19.0476F, 57.1429F}, {19.0476F, 42.8571F}, {23.8095F, 19.0476F},
    {33.3333F, 4.7619F},  {47.619F, 0.0F},      {57.1428F, 0.0F},
    {71.4286F, 4.7619F},  {80.9524F, 19.0476F}, {85.7143F, 42.8571F},
    {85.7143F, 57.1429F}, {80.9524F, 80.9524F}, {71.4286F, 95.2381F},
    {57.1428F, 100.0F},   {47.619F, 100.0F}};

static const SFG_StrokeStrip kCh48st[] = {{17, kCh48st0}};

static const SFG_StrokeChar kCh48 = {104.762F, 1, kCh48st};

/* char: 0x31 */

static const SFG_StrokeVertex kCh49st0[] = {{40.4762F, 80.9524F},
                                            {50.0F, 85.7143F},
                                            {64.2857F, 100.0F},
                                            {64.2857F, 0.0F}};

static const SFG_StrokeStrip kCh49st[] = {{4, kCh49st0}};

static const SFG_StrokeChar kCh49 = {104.762F, 1, kCh49st};

/* char: 0x32 */

static const SFG_StrokeVertex kCh50st0[] = {
    {23.8095F, 76.1905F}, {23.8095F, 80.9524F}, {28.5714F, 90.4762F},
    {33.3333F, 95.2381F}, {42.8571F, 100.0F},   {61.9047F, 100.0F},
    {71.4286F, 95.2381F}, {76.1905F, 90.4762F}, {80.9524F, 80.9524F},
    {80.9524F, 71.4286F}, {76.1905F, 61.9048F}, {66.6666F, 47.619F},
    {19.0476F, 0.0F},     {85.7143F, 0.0F}};

static const SFG_StrokeStrip kCh50st[] = {{14, kCh50st0}};

static const SFG_StrokeChar kCh50 = {104.762F, 1, kCh50st};

/* char: 0x33 */

static const SFG_StrokeVertex kCh51st0[] = {
    {28.5714F, 100.0F},   {80.9524F, 100.0F},   {52.3809F, 61.9048F},
    {66.6666F, 61.9048F}, {76.1905F, 57.1429F}, {80.9524F, 52.381F},
    {85.7143F, 38.0952F}, {85.7143F, 28.5714F}, {80.9524F, 14.2857F},
    {71.4286F, 4.7619F},  {57.1428F, 0.0F},     {42.8571F, 0.0F},
    {28.5714F, 4.7619F},  {23.8095F, 9.5238F},  {19.0476F, 19.0476F}};

static const SFG_StrokeStrip kCh51st[] = {{15, kCh51st0}};

static const SFG_StrokeChar kCh51 = {104.762F, 1, kCh51st};

/* char: 0x34 */

static const SFG_StrokeVertex kCh52st0[] = {
    {64.2857F, 100.0F}, {16.6667F, 33.3333F}, {88.0952F, 33.3333F}};

static const SFG_StrokeVertex kCh52st1[] = {{64.2857F, 100.0F},
                                            {64.2857F, 0.0F}};

static const SFG_StrokeStrip kCh52st[] = {{3, kCh52st0}, {2, kCh52st1}};

static const SFG_StrokeChar kCh52 = {104.762F, 2, kCh52st};

/* char: 0x35 */

static const SFG_StrokeVertex kCh53st0[] = {
    {76.1905F, 100.0F},   {28.5714F, 100.0F},   {23.8095F, 57.1429F},
    {28.5714F, 61.9048F}, {42.8571F, 66.6667F}, {57.1428F, 66.6667F},
    {71.4286F, 61.9048F}, {80.9524F, 52.381F},  {85.7143F, 38.0952F},
    {85.7143F, 28.5714F}, {80.9524F, 14.2857F}, {71.4286F, 4.7619F},
    {57.1428F, 0.0F},     {42.8571F, 0.0F},     {28.5714F, 4.7619F},
    {23.8095F, 9.5238F},  {19.0476F, 19.0476F}};

static const SFG_StrokeStrip kCh53st[] = {{17, kCh53st0}};

static const SFG_StrokeChar kCh53 = {104.762F, 1, kCh53st};

/* char: 0x36 */

static const SFG_StrokeVertex kCh54st0[] = {
    {78.5714F, 85.7143F}, {73.8096F, 95.2381F}, {59.5238F, 100.0F},
    {50.0F, 100.0F},      {35.7143F, 95.2381F}, {26.1905F, 80.9524F},
    {21.4286F, 57.1429F}, {21.4286F, 33.3333F}, {26.1905F, 14.2857F},
    {35.7143F, 4.7619F},  {50.0F, 0.0F},        {54.7619F, 0.0F},
    {69.0476F, 4.7619F},  {78.5714F, 14.2857F}, {83.3334F, 28.5714F},
    {83.3334F, 33.3333F}, {78.5714F, 47.619F},  {69.0476F, 57.1429F},
    {54.7619F, 61.9048F}, {50.0F, 61.9048F},    {35.7143F, 57.1429F},
    {26.1905F, 47.619F},  {21.4286F, 33.3333F}};

static const SFG_StrokeStrip kCh54st[] = {{23, kCh54st0}};

static const SFG_StrokeChar kCh54 = {104.762F, 1, kCh54st};

/* char: 0x37 */

static const SFG_StrokeVertex kCh55st0[] = {{85.7143F, 100.0F},
                                            {38.0952F, 0.0F}};

static const SFG_StrokeVertex kCh55st1[] = {{19.0476F, 100.0F},
                                            {85.7143F, 100.0F}};

static const SFG_StrokeStrip kCh55st[] = {{2, kCh55st0}, {2, kCh55st1}};

static const SFG_StrokeChar kCh55 = {104.762F, 2, kCh55st};

/* char: 0x38 */

static const SFG_StrokeVertex kCh56st0[] = {
    {42.8571F, 100.0F},   {28.5714F, 95.2381F}, {23.8095F, 85.7143F},
    {23.8095F, 76.1905F}, {28.5714F, 66.6667F}, {38.0952F, 61.9048F},
    {57.1428F, 57.1429F}, {71.4286F, 52.381F},  {80.9524F, 42.8571F},
    {85.7143F, 33.3333F}, {85.7143F, 19.0476F}, {80.9524F, 9.5238F},
    {76.1905F, 4.7619F},  {61.9047F, 0.0F},     {42.8571F, 0.0F},
    {28.5714F, 4.7619F},  {23.8095F, 9.5238F},  {19.0476F, 19.0476F},
    {19.0476F, 33.3333F}, {23.8095F, 42.8571F}, {33.3333F, 52.381F},
    {47.619F, 57.1429F},  {66.6666F, 61.9048F}, {76.1905F, 66.6667F},
    {80.9524F, 76.1905F}, {80.9524F, 85.7143F}, {76.1905F, 95.2381F},
    {61.9047F, 100.0F},   {42.8571F, 100.0F}};

static const SFG_StrokeStrip kCh56st[] = {{29, kCh56st0}};

static const SFG_StrokeChar kCh56 = {104.762F, 1, kCh56st};

/* char: 0x39 */

static const SFG_StrokeVertex kCh57st0[] = {
    {83.3334F, 66.6667F}, {78.5714F, 52.381F},  {69.0476F, 42.8571F},
    {54.7619F, 38.0952F}, {50.0F, 38.0952F},    {35.7143F, 42.8571F},
    {26.1905F, 52.381F},  {21.4286F, 66.6667F}, {21.4286F, 71.4286F},
    {26.1905F, 85.7143F}, {35.7143F, 95.2381F}, {50.0F, 100.0F},
    {54.7619F, 100.0F},   {69.0476F, 95.2381F}, {78.5714F, 85.7143F},
    {83.3334F, 66.6667F}, {83.3334F, 42.8571F}, {78.5714F, 19.0476F},
    {69.0476F, 4.7619F},  {54.7619F, 0.0F},     {45.2381F, 0.0F},
    {30.9524F, 4.7619F},  {26.1905F, 14.2857F}};

static const SFG_StrokeStrip kCh57st[] = {{23, kCh57st0}};

static const SFG_StrokeChar kCh57 = {104.762F, 1, kCh57st};

/* char: 0x3a */

static const SFG_StrokeVertex kCh58st0[] = {{52.381F, 66.6667F},
                                            {47.6191F, 61.9048F},
                                            {52.381F, 57.1429F},
                                            {57.1429F, 61.9048F},
                                            {52.381F, 66.6667F}};

static const SFG_StrokeVertex kCh58st1[] = {{52.381F, 9.5238F},
                                            {47.6191F, 4.7619F},
                                            {52.381F, 0.0F},
                                            {57.1429F, 4.7619F},
                                            {52.381F, 9.5238F}};

static const SFG_StrokeStrip kCh58st[] = {{5, kCh58st0}, {5, kCh58st1}};

static const SFG_StrokeChar kCh58 = {104.762F, 2, kCh58st};

/* char: 0x3b */

static const SFG_StrokeVertex kCh59st0[] = {{52.381F, 66.6667F},
                                            {47.6191F, 61.9048F},
                                            {52.381F, 57.1429F},
                                            {57.1429F, 61.9048F},
                                            {52.381F, 66.6667F}};

static const SFG_StrokeVertex kCh59st1[] = {
    {57.1429F, 4.7619F},  {52.381F, 0.0F},      {47.6191F, 4.7619F},
    {52.381F, 9.5238F},   {57.1429F, 4.7619F},  {57.1429F, -4.7619F},
    {52.381F, -14.2857F}, {47.6191F, -19.0476F}};

static const SFG_StrokeStrip kCh59st[] = {{5, kCh59st0}, {8, kCh59st1}};

static const SFG_StrokeChar kCh59 = {104.762F, 2, kCh59st};

/* char: 0x3c */

static const SFG_StrokeVertex kCh60st0[] = {
    {90.4762F, 85.7143F}, {14.2857F, 42.8571F}, {90.4762F, 0.0F}};

static const SFG_StrokeStrip kCh60st[] = {{3, kCh60st0}};

static const SFG_StrokeChar kCh60 = {104.762F, 1, kCh60st};

/* char: 0x3d */

static const SFG_StrokeVertex kCh61st0[] = {{9.5238F, 57.1429F},
                                            {95.2381F, 57.1429F}};

static const SFG_StrokeVertex kCh61st1[] = {{9.5238F, 28.5714F},
                                            {95.2381F, 28.5714F}};

static const SFG_StrokeStrip kCh61st[] = {{2, kCh61st0}, {2, kCh61st1}};

static const SFG_StrokeChar kCh61 = {104.762F, 2, kCh61st};

/* char: 0x3e */

static const SFG_StrokeVertex kCh62st0[] = {
    {14.2857F, 85.7143F}, {90.4762F, 42.8571F}, {14.2857F, 0.0F}};

static const SFG_StrokeStrip kCh62st[] = {{3, kCh62st0}};

static const SFG_StrokeChar kCh62 = {104.762F, 1, kCh62st};

/* char: 0x3f */

static const SFG_StrokeVertex kCh63st0[] = {
    {23.8095F, 76.1905F}, {23.8095F, 80.9524F}, {28.5714F, 90.4762F},
    {33.3333F, 95.2381F}, {42.8571F, 100.0F},   {61.9047F, 100.0F},
    {71.4285F, 95.2381F}, {76.1905F, 90.4762F}, {80.9524F, 80.9524F},
    {80.9524F, 71.4286F}, {76.1905F, 61.9048F}, {71.4285F, 57.1429F},
    {52.3809F, 47.619F},  {52.3809F, 33.3333F}};

static const SFG_StrokeVertex kCh63st1[] = {{52.3809F, 9.5238F},
                                            {47.619F, 4.7619F},
                                            {52.3809F, 0.0F},
                                            {57.1428F, 4.7619F},
                                            {52.3809F, 9.5238F}};

static const SFG_StrokeStrip kCh63st[] = {{14, kCh63st0}, {5, kCh63st1}};

static const SFG_StrokeChar kCh63 = {104.762F, 2, kCh63st};

/* char: 0x40 */

static const SFG_StrokeVertex kCh64st0[] = {
    {64.2857F, 52.381F},  {54.7619F, 57.1429F}, {45.2381F, 57.1429F},
    {40.4762F, 47.619F},  {40.4762F, 42.8571F}, {45.2381F, 33.3333F},
    {54.7619F, 33.3333F}, {64.2857F, 38.0952F}};

static const SFG_StrokeVertex kCh64st1[] = {
    {64.2857F, 57.1429F}, {64.2857F, 38.0952F}, {69.0476F, 33.3333F},
    {78.5714F, 33.3333F}, {83.3334F, 42.8571F}, {83.3334F, 47.619F},
    {78.5714F, 61.9048F}, {69.0476F, 71.4286F}, {54.7619F, 76.1905F},
    {50.0F, 76.1905F},    {35.7143F, 71.4286F}, {26.1905F, 61.9048F},
    {21.4286F, 47.619F},  {21.4286F, 42.8571F}, {26.1905F, 28.5714F},
    {35.7143F, 19.0476F}, {50.0F, 14.2857F},    {54.7619F, 14.2857F},
    {69.0476F, 19.0476F}};

static const SFG_StrokeStrip kCh64st[] = {{8, kCh64st0}, {19, kCh64st1}};

static const SFG_StrokeChar kCh64 = {104.762F, 2, kCh64st};

/* char: 0x41 */

static const SFG_StrokeVertex kCh65st0[] = {{52.3809F, 100.0F},
                                            {14.2857F, 0.0F}};

static const SFG_StrokeVertex kCh65st1[] = {{52.3809F, 100.0F},
                                            {90.4762F, 0.0F}};

static const SFG_StrokeVertex kCh65st2[] = {{28.5714F, 33.3333F},
                                            {76.1905F, 33.3333F}};

static const SFG_StrokeStrip kCh65st[] = {
    {2, kCh65st0}, {2, kCh65st1}, {2, kCh65st2}};

static const SFG_StrokeChar kCh65 = {104.762F, 3, kCh65st};

/* char: 0x42 */

static const SFG_StrokeVertex kCh66st0[] = {{19.0476F, 100.0F},
                                            {19.0476F, 0.0F}};

static const SFG_StrokeVertex kCh66st1[] = {
    {19.0476F, 100.0F},   {61.9047F, 100.0F},   {76.1905F, 95.2381F},
    {80.9524F, 90.4762F}, {85.7143F, 80.9524F}, {85.7143F, 71.4286F},
    {80.9524F, 61.9048F}, {76.1905F, 57.1429F}, {61.9047F, 52.381F}};

static const SFG_StrokeVertex kCh66st2[] = {
    {19.0476F, 52.381F},  {61.9047F, 52.381F},  {76.1905F, 47.619F},
    {80.9524F, 42.8571F}, {85.7143F, 33.3333F}, {85.7143F, 19.0476F},
    {80.9524F, 9.5238F},  {76.1905F, 4.7619F},  {61.9047F, 0.0F},
    {19.0476F, 0.0F}};

static const SFG_StrokeStrip kCh66st[] = {
    {2, kCh66st0}, {9, kCh66st1}, {10, kCh66st2}};

static const SFG_StrokeChar kCh66 = {104.762F, 3, kCh66st};

/* char: 0x43 */

static const SFG_StrokeVertex kCh67st0[] = {
    {88.0952F, 76.1905F}, {83.3334F, 85.7143F}, {73.8096F, 95.2381F},
    {64.2857F, 100.0F},   {45.2381F, 100.0F},   {35.7143F, 95.2381F},
    {26.1905F, 85.7143F}, {21.4286F, 76.1905F}, {16.6667F, 61.9048F},
    {16.6667F, 38.0952F}, {21.4286F, 23.8095F}, {26.1905F, 14.2857F},
    {35.7143F, 4.7619F},  {45.2381F, 0.0F},     {64.2857F, 0.0F},
    {73.8096F, 4.7619F},  {83.3334F, 14.2857F}, {88.0952F, 23.8095F}};

static const SFG_StrokeStrip kCh67st[] = {{18, kCh67st0}};

static const SFG_StrokeChar kCh67 = {104.762F, 1, kCh67st};

/* char: 0x44 */

static const SFG_StrokeVertex kCh68st0[] = {{19.0476F, 100.0F},
                                            {19.0476F, 0.0F}};

static const SFG_StrokeVertex kCh68st1[] = {
    {19.0476F, 100.0F},   {52.3809F, 100.0F},   {66.6666F, 95.2381F},
    {76.1905F, 85.7143F}, {80.9524F, 76.1905F}, {85.7143F, 61.9048F},
    {85.7143F, 38.0952F}, {80.9524F, 23.8095F}, {76.1905F, 14.2857F},
    {66.6666F, 4.7619F},  {52.3809F, 0.0F},     {19.0476F, 0.0F}};

static const SFG_StrokeStrip kCh68st[] = {{2, kCh68st0}, {12, kCh68st1}};

static const SFG_StrokeChar kCh68 = {104.762F, 2, kCh68st};

/* char: 0x45 */

static const SFG_StrokeVertex kCh69st0[] = {{21.4286F, 100.0F},
                                            {21.4286F, 0.0F}};

static const SFG_StrokeVertex kCh69st1[] = {{21.4286F, 100.0F},
                                            {83.3334F, 100.0F}};

static const SFG_StrokeVertex kCh69st2[] = {{21.4286F, 52.381F},
                                            {59.5238F, 52.381F}};

static const SFG_StrokeVertex kCh69st3[] = {{21.4286F, 0.0F}, {83.3334F, 0.0F}};

static const SFG_StrokeStrip kCh69st[] = {
    {2, kCh69st0}, {2, kCh69st1}, {2, kCh69st2}, {2, kCh69st3}};

static const SFG_StrokeChar kCh69 = {104.762F, 4, kCh69st};

/* char: 0x46 */

static const SFG_StrokeVertex kCh70st0[] = {{21.4286F, 100.0F},
                                            {21.4286F, 0.0F}};

static const SFG_StrokeVertex kCh70st1[] = {{21.4286F, 100.0F},
                                            {83.3334F, 100.0F}};

static const SFG_StrokeVertex kCh70st2[] = {{21.4286F, 52.381F},
                                            {59.5238F, 52.381F}};

static const SFG_StrokeStrip kCh70st[] = {
    {2, kCh70st0}, {2, kCh70st1}, {2, kCh70st2}};

static const SFG_StrokeChar kCh70 = {104.762F, 3, kCh70st};

/* char: 0x47 */

static const SFG_StrokeVertex kCh71st0[] = {
    {88.0952F, 76.1905F}, {83.3334F, 85.7143F}, {73.8096F, 95.2381F},
    {64.2857F, 100.0F},   {45.2381F, 100.0F},   {35.7143F, 95.2381F},
    {26.1905F, 85.7143F}, {21.4286F, 76.1905F}, {16.6667F, 61.9048F},
    {16.6667F, 38.0952F}, {21.4286F, 23.8095F}, {26.1905F, 14.2857F},
    {35.7143F, 4.7619F},  {45.2381F, 0.0F},     {64.2857F, 0.0F},
    {73.8096F, 4.7619F},  {83.3334F, 14.2857F}, {88.0952F, 23.8095F},
    {88.0952F, 38.0952F}};

static const SFG_StrokeVertex kCh71st1[] = {{64.2857F, 38.0952F},
                                            {88.0952F, 38.0952F}};

static const SFG_StrokeStrip kCh71st[] = {{19, kCh71st0}, {2, kCh71st1}};

static const SFG_StrokeChar kCh71 = {104.762F, 2, kCh71st};

/* char: 0x48 */

static const SFG_StrokeVertex kCh72st0[] = {{19.0476F, 100.0F},
                                            {19.0476F, 0.0F}};

static const SFG_StrokeVertex kCh72st1[] = {{85.7143F, 100.0F},
                                            {85.7143F, 0.0F}};

static const SFG_StrokeVertex kCh72st2[] = {{19.0476F, 52.381F},
                                            {85.7143F, 52.381F}};

static const SFG_StrokeStrip kCh72st[] = {
    {2, kCh72st0}, {2, kCh72st1}, {2, kCh72st2}};

static const SFG_StrokeChar kCh72 = {104.762F, 3, kCh72st};

/* char: 0x49 */

static const SFG_StrokeVertex kCh73st0[] = {{52.381F, 100.0F}, {52.381F, 0.0F}};

static const SFG_StrokeStrip kCh73st[] = {{2, kCh73st0}};

static const SFG_StrokeChar kCh73 = {104.762F, 1, kCh73st};

/* char: 0x4a */

static const SFG_StrokeVertex kCh74st0[] = {
    {76.1905F, 100.0F},  {76.1905F, 23.8095F}, {71.4286F, 9.5238F},
    {66.6667F, 4.7619F}, {57.1429F, 0.0F},     {47.6191F, 0.0F},
    {38.0953F, 4.7619F}, {33.3334F, 9.5238F},  {28.5715F, 23.8095F},
    {28.5715F, 33.3333F}};

static const SFG_StrokeStrip kCh74st[] = {{10, kCh74st0}};

static const SFG_StrokeChar kCh74 = {104.762F, 1, kCh74st};

/* char: 0x4b */

static const SFG_StrokeVertex kCh75st0[] = {{19.0476F, 100.0F},
                                            {19.0476F, 0.0F}};

static const SFG_StrokeVertex kCh75st1[] = {{85.7143F, 100.0F},
                                            {19.0476F, 33.3333F}};

static const SFG_StrokeVertex kCh75st2[] = {{42.8571F, 57.1429F},
                                            {85.7143F, 0.0F}};

static const SFG_StrokeStrip kCh75st[] = {
    {2, kCh75st0}, {2, kCh75st1}, {2, kCh75st2}};

static const SFG_StrokeChar kCh75 = {104.762F, 3, kCh75st};

/* char: 0x4c */

static const SFG_StrokeVertex kCh76st0[] = {{23.8095F, 100.0F},
                                            {23.8095F, 0.0F}};

static const SFG_StrokeVertex kCh76st1[] = {{23.8095F, 0.0F}, {80.9524F, 0.0F}};

static const SFG_StrokeStrip kCh76st[] = {{2, kCh76st0}, {2, kCh76st1}};

static const SFG_StrokeChar kCh76 = {104.762F, 2, kCh76st};

/* char: 0x4d */

static const SFG_StrokeVertex kCh77st0[] = {{14.2857F, 100.0F},
                                            {14.2857F, 0.0F}};

static const SFG_StrokeVertex kCh77st1[] = {{14.2857F, 100.0F},
                                            {52.3809F, 0.0F}};

static const SFG_StrokeVertex kCh77st2[] = {{90.4762F, 100.0F},
                                            {52.3809F, 0.0F}};

static const SFG_StrokeVertex kCh77st3[] = {{90.4762F, 100.0F},
                                            {90.4762F, 0.0F}};

static const SFG_StrokeStrip kCh77st[] = {
    {2, kCh77st0}, {2, kCh77st1}, {2, kCh77st2}, {2, kCh77st3}};

static const SFG_StrokeChar kCh77 = {104.762F, 4, kCh77st};

/* char: 0x4e */

static const SFG_StrokeVertex kCh78st0[] = {{19.0476F, 100.0F},
                                            {19.0476F, 0.0F}};

static const SFG_StrokeVertex kCh78st1[] = {{19.0476F, 100.0F},
                                            {85.7143F, 0.0F}};

static const SFG_StrokeVertex kCh78st2[] = {{85.7143F, 100.0F},
                                            {85.7143F, 0.0F}};

static const SFG_StrokeStrip kCh78st[] = {
    {2, kCh78st0}, {2, kCh78st1}, {2, kCh78st2}};

static const SFG_StrokeChar kCh78 = {104.762F, 3, kCh78st};

/* char: 0x4f */

static const SFG_StrokeVertex kCh79st0[] = {
    {42.8571F, 100.0F},   {33.3333F, 95.2381F}, {23.8095F, 85.7143F},
    {19.0476F, 76.1905F}, {14.2857F, 61.9048F}, {14.2857F, 38.0952F},
    {19.0476F, 23.8095F}, {23.8095F, 14.2857F}, {33.3333F, 4.7619F},
    {42.8571F, 0.0F},     {61.9047F, 0.0F},     {71.4286F, 4.7619F},
    {80.9524F, 14.2857F}, {85.7143F, 23.8095F}, {90.4762F, 38.0952F},
    {90.4762F, 61.9048F}, {85.7143F, 76.1905F}, {80.9524F, 85.7143F},
    {71.4286F, 95.2381F}, {61.9047F, 100.0F},   {42.8571F, 100.0F}};

static const SFG_StrokeStrip kCh79st[] = {{21, kCh79st0}};

static const SFG_StrokeChar kCh79 = {104.762F, 1, kCh79st};

/* char: 0x50 */

static const SFG_StrokeVertex kCh80st0[] = {{19.0476F, 100.0F},
                                            {19.0476F, 0.0F}};

static const SFG_StrokeVertex kCh80st1[] = {
    {19.0476F, 100.0F},   {61.9047F, 100.0F},   {76.1905F, 95.2381F},
    {80.9524F, 90.4762F}, {85.7143F, 80.9524F}, {85.7143F, 66.6667F},
    {80.9524F, 57.1429F}, {76.1905F, 52.381F},  {61.9047F, 47.619F},
    {19.0476F, 47.619F}};

static const SFG_StrokeStrip kCh80st[] = {{2, kCh80st0}, {10, kCh80st1}};

static const SFG_StrokeChar kCh80 = {104.762F, 2, kCh80st};

/* char: 0x51 */

static const SFG_StrokeVertex kCh81st0[] = {
    {42.8571F, 100.0F},   {33.3333F, 95.2381F}, {23.8095F, 85.7143F},
    {19.0476F, 76.1905F}, {14.2857F, 61.9048F}, {14.2857F, 38.0952F},
    {19.0476F, 23.8095F}, {23.8095F, 14.2857F}, {33.3333F, 4.7619F},
    {42.8571F, 0.0F},     {61.9047F, 0.0F},     {71.4286F, 4.7619F},
    {80.9524F, 14.2857F}, {85.7143F, 23.8095F}, {90.4762F, 38.0952F},
    {90.4762F, 61.9048F}, {85.7143F, 76.1905F}, {80.9524F, 85.7143F},
    {71.4286F, 95.2381F}, {61.9047F, 100.0F},   {42.8571F, 100.0F}};

static const SFG_StrokeVertex kCh81st1[] = {{57.1428F, 19.0476F},
                                            {85.7143F, -9.5238F}};

static const SFG_StrokeStrip kCh81st[] = {{21, kCh81st0}, {2, kCh81st1}};

static const SFG_StrokeChar kCh81 = {104.762F, 2, kCh81st};

/* char: 0x52 */

static const SFG_StrokeVertex kCh82st0[] = {{19.0476F, 100.0F},
                                            {19.0476F, 0.0F}};

static const SFG_StrokeVertex kCh82st1[] = {
    {19.0476F, 100.0F},   {61.9047F, 100.0F},   {76.1905F, 95.2381F},
    {80.9524F, 90.4762F}, {85.7143F, 80.9524F}, {85.7143F, 71.4286F},
    {80.9524F, 61.9048F}, {76.1905F, 57.1429F}, {61.9047F, 52.381F},
    {19.0476F, 52.381F}};

static const SFG_StrokeVertex kCh82st2[] = {{52.3809F, 52.381F},
                                            {85.7143F, 0.0F}};

static const SFG_StrokeStrip kCh82st[] = {
    {2, kCh82st0}, {10, kCh82st1}, {2, kCh82st2}};

static const SFG_StrokeChar kCh82 = {104.762F, 3, kCh82st};

/* char: 0x53 */

static const SFG_StrokeVertex kCh83st0[] = {
    {85.7143F, 85.7143F}, {76.1905F, 95.2381F}, {61.9047F, 100.0F},
    {42.8571F, 100.0F},   {28.5714F, 95.2381F}, {19.0476F, 85.7143F},
    {19.0476F, 76.1905F}, {23.8095F, 66.6667F}, {28.5714F, 61.9048F},
    {38.0952F, 57.1429F}, {66.6666F, 47.619F},  {76.1905F, 42.8571F},
    {80.9524F, 38.0952F}, {85.7143F, 28.5714F}, {85.7143F, 14.2857F},
    {76.1905F, 4.7619F},  {61.9047F, 0.0F},     {42.8571F, 0.0F},
    {28.5714F, 4.7619F},  {19.0476F, 14.2857F}};

static const SFG_StrokeStrip kCh83st[] = {{20, kCh83st0}};

static const SFG_StrokeChar kCh83 = {104.762F, 1, kCh83st};

/* char: 0x54 */

static const SFG_StrokeVertex kCh84st0[] = {{52.3809F, 100.0F},
                                            {52.3809F, 0.0F}};

static const SFG_StrokeVertex kCh84st1[] = {{19.0476F, 100.0F},
                                            {85.7143F, 100.0F}};

static const SFG_StrokeStrip kCh84st[] = {{2, kCh84st0}, {2, kCh84st1}};

static const SFG_StrokeChar kCh84 = {104.762F, 2, kCh84st};

/* char: 0x55 */

static const SFG_StrokeVertex kCh85st0[] = {
    {19.0476F, 100.0F},  {19.0476F, 28.5714F}, {23.8095F, 14.2857F},
    {33.3333F, 4.7619F}, {47.619F, 0.0F},      {57.1428F, 0.0F},
    {71.4286F, 4.7619F}, {80.9524F, 14.2857F}, {85.7143F, 28.5714F},
    {85.7143F, 100.0F}};

static const SFG_StrokeStrip kCh85st[] = {{10, kCh85st0}};

static const SFG_StrokeChar kCh85 = {104.762F, 1, kCh85st};

/* char: 0x56 */

static const SFG_StrokeVertex kCh86st0[] = {{14.2857F, 100.0F},
                                            {52.3809F, 0.0F}};

static const SFG_StrokeVertex kCh86st1[] = {{90.4762F, 100.0F},
                                            {52.3809F, 0.0F}};

static const SFG_StrokeStrip kCh86st[] = {{2, kCh86st0}, {2, kCh86st1}};

static const SFG_StrokeChar kCh86 = {104.762F, 2, kCh86st};

/* char: 0x57 */

static const SFG_StrokeVertex kCh87st0[] = {{4.7619F, 100.0F},
                                            {28.5714F, 0.0F}};

static const SFG_StrokeVertex kCh87st1[] = {{52.3809F, 100.0F},
                                            {28.5714F, 0.0F}};

static const SFG_StrokeVertex kCh87st2[] = {{52.3809F, 100.0F},
                                            {76.1905F, 0.0F}};

static const SFG_StrokeVertex kCh87st3[] = {{100.0F, 100.0F}, {76.1905F, 0.0F}};

static const SFG_StrokeStrip kCh87st[] = {
    {2, kCh87st0}, {2, kCh87st1}, {2, kCh87st2}, {2, kCh87st3}};

static const SFG_StrokeChar kCh87 = {104.762F, 4, kCh87st};

/* char: 0x58 */

static const SFG_StrokeVertex kCh88st0[] = {{19.0476F, 100.0F},
                                            {85.7143F, 0.0F}};

static const SFG_StrokeVertex kCh88st1[] = {{85.7143F, 100.0F},
                                            {19.0476F, 0.0F}};

static const SFG_StrokeStrip kCh88st[] = {{2, kCh88st0}, {2, kCh88st1}};

static const SFG_StrokeChar kCh88 = {104.762F, 2, kCh88st};

/* char: 0x59 */

static const SFG_StrokeVertex kCh89st0[] = {
    {14.2857F, 100.0F}, {52.3809F, 52.381F}, {52.3809F, 0.0F}};

static const SFG_StrokeVertex kCh89st1[] = {{90.4762F, 100.0F},
                                            {52.3809F, 52.381F}};

static const SFG_StrokeStrip kCh89st[] = {{3, kCh89st0}, {2, kCh89st1}};

static const SFG_StrokeChar kCh89 = {104.762F, 2, kCh89st};

/* char: 0x5a */

static const SFG_StrokeVertex kCh90st0[] = {{85.7143F, 100.0F},
                                            {19.0476F, 0.0F}};

static const SFG_StrokeVertex kCh90st1[] = {{19.0476F, 100.0F},
                                            {85.7143F, 100.0F}};

static const SFG_StrokeVertex kCh90st2[] = {{19.0476F, 0.0F}, {85.7143F, 0.0F}};

static const SFG_StrokeStrip kCh90st[] = {
    {2, kCh90st0}, {2, kCh90st1}, {2, kCh90st2}};

static const SFG_StrokeChar kCh90 = {104.762F, 3, kCh90st};

/* char: 0x5b */

static const SFG_StrokeVertex kCh91st0[] = {{35.7143F, 119.048F},
                                            {35.7143F, -33.3333F}};

static const SFG_StrokeVertex kCh91st1[] = {{40.4762F, 119.048F},
                                            {40.4762F, -33.3333F}};

static const SFG_StrokeVertex kCh91st2[] = {{35.7143F, 119.048F},
                                            {69.0476F, 119.048F}};

static const SFG_StrokeVertex kCh91st3[] = {{35.7143F, -33.3333F},
                                            {69.0476F, -33.3333F}};

static const SFG_StrokeStrip kCh91st[] = {
    {2, kCh91st0}, {2, kCh91st1}, {2, kCh91st2}, {2, kCh91st3}};

static const SFG_StrokeChar kCh91 = {104.762F, 4, kCh91st};

/* char: 0x5c */

static const SFG_StrokeVertex kCh92st0[] = {{19.0476F, 100.0F},
                                            {85.7143F, -14.2857F}};

static const SFG_StrokeStrip kCh92st[] = {{2, kCh92st0}};

static const SFG_StrokeChar kCh92 = {104.762F, 1, kCh92st};

/* char: 0x5d */

static const SFG_StrokeVertex kCh93st0[] = {{64.2857F, 119.048F},
                                            {64.2857F, -33.3333F}};

static const SFG_StrokeVertex kCh93st1[] = {{69.0476F, 119.048F},
                                            {69.0476F, -33.3333F}};

static const SFG_StrokeVertex kCh93st2[] = {{35.7143F, 119.048F},
                                            {69.0476F, 119.048F}};

static const SFG_StrokeVertex kCh93st3[] = {{35.7143F, -33.3333F},
                                            {69.0476F, -33.3333F}};

static const SFG_StrokeStrip kCh93st[] = {
    {2, kCh93st0}, {2, kCh93st1}, {2, kCh93st2}, {2, kCh93st3}};

static const SFG_StrokeChar kCh93 = {104.762F, 4, kCh93st};

/* char: 0x5e */

static const SFG_StrokeVertex kCh94st0[] = {{52.3809F, 109.524F},
                                            {14.2857F, 42.8571F}};

static const SFG_StrokeVertex kCh94st1[] = {{52.3809F, 109.524F},
                                            {90.4762F, 42.8571F}};

static const SFG_StrokeStrip kCh94st[] = {{2, kCh94st0}, {2, kCh94st1}};

static const SFG_StrokeChar kCh94 = {104.762F, 2, kCh94st};

/* char: 0x5f */

static const SFG_StrokeVertex kCh95st0[] = {{0, -33.3333F},
                                            {104.762F, -33.3333F},
                                            {104.762F, -28.5714F},
                                            {0, -28.5714F},
                                            {0, -33.3333F}};

static const SFG_StrokeStrip kCh95st[] = {{5, kCh95st0}};

static const SFG_StrokeChar kCh95 = {104.762F, 1, kCh95st};

/* char: 0x60 */

static const SFG_StrokeVertex kCh96st0[] = {{42.8572F, 100.0F},
                                            {66.6667F, 71.4286F}};

static const SFG_StrokeVertex kCh96st1[] = {
    {42.8572F, 100.0F}, {38.0953F, 95.2381F}, {66.6667F, 71.4286F}};

static const SFG_StrokeStrip kCh96st[] = {{2, kCh96st0}, {3, kCh96st1}};

static const SFG_StrokeChar kCh96 = {104.762F, 2, kCh96st};

/* char: 0x61 */

static const SFG_StrokeVertex kCh97st0[] = {{80.9524F, 66.6667F},
                                            {80.9524F, 0.0F}};

static const SFG_StrokeVertex kCh97st1[] = {
    {80.9524F, 52.381F},  {71.4285F, 61.9048F}, {61.9047F, 66.6667F},
    {47.619F, 66.6667F},  {38.0952F, 61.9048F}, {28.5714F, 52.381F},
    {23.8095F, 38.0952F}, {23.8095F, 28.5714F}, {28.5714F, 14.2857F},
    {38.0952F, 4.7619F},  {47.619F, 0.0F},      {61.9047F, 0.0F},
    {71.4285F, 4.7619F},  {80.9524F, 14.2857F}};

static const SFG_StrokeStrip kCh97st[] = {{2, kCh97st0}, {14, kCh97st1}};

static const SFG_StrokeChar kCh97 = {104.762F, 2, kCh97st};

/* char: 0x62 */

static const SFG_StrokeVertex kCh98st0[] = {{23.8095F, 100.0F},
                                            {23.8095F, 0.0F}};

static const SFG_StrokeVertex kCh98st1[] = {
    {23.8095F, 52.381F},  {33.3333F, 61.9048F}, {42.8571F, 66.6667F},
    {57.1428F, 66.6667F}, {66.6666F, 61.9048F}, {76.1905F, 52.381F},
    {80.9524F, 38.0952F}, {80.9524F, 28.5714F}, {76.1905F, 14.2857F},
    {66.6666F, 4.7619F},  {57.1428F, 0.0F},     {42.8571F, 0.0F},
    {33.3333F, 4.7619F},  {23.8095F, 14.2857F}};

static const SFG_StrokeStrip kCh98st[] = {{2, kCh98st0}, {14, kCh98st1}};

static const SFG_StrokeChar kCh98 = {104.762F, 2, kCh98st};

/* char: 0x63 */

static const SFG_StrokeVertex kCh99st0[] = {
    {80.9524F, 52.381F},  {71.4285F, 61.9048F}, {61.9047F, 66.6667F},
    {47.619F, 66.6667F},  {38.0952F, 61.9048F}, {28.5714F, 52.381F},
    {23.8095F, 38.0952F}, {23.8095F, 28.5714F}, {28.5714F, 14.2857F},
    {38.0952F, 4.7619F},  {47.619F, 0.0F},      {61.9047F, 0.0F},
    {71.4285F, 4.7619F},  {80.9524F, 14.2857F}};

static const SFG_StrokeStrip kCh99st[] = {{14, kCh99st0}};

static const SFG_StrokeChar kCh99 = {104.762F, 1, kCh99st};

/* char: 0x64 */

static const SFG_StrokeVertex kCh100st0[] = {{80.9524F, 100.0F},
                                             {80.9524F, 0.0F}};

static const SFG_StrokeVertex kCh100st1[] = {
    {80.9524F, 52.381F},  {71.4285F, 61.9048F}, {61.9047F, 66.6667F},
    {47.619F, 66.6667F},  {38.0952F, 61.9048F}, {28.5714F, 52.381F},
    {23.8095F, 38.0952F}, {23.8095F, 28.5714F}, {28.5714F, 14.2857F},
    {38.0952F, 4.7619F},  {47.619F, 0.0F},      {61.9047F, 0.0F},
    {71.4285F, 4.7619F},  {80.9524F, 14.2857F}};

static const SFG_StrokeStrip kCh100st[] = {{2, kCh100st0}, {14, kCh100st1}};

static const SFG_StrokeChar kCh100 = {104.762F, 2, kCh100st};

/* char: 0x65 */

static const SFG_StrokeVertex kCh101st0[] = {
    {23.8095F, 38.0952F}, {80.9524F, 38.0952F}, {80.9524F, 47.619F},
    {76.1905F, 57.1429F}, {71.4285F, 61.9048F}, {61.9047F, 66.6667F},
    {47.619F, 66.6667F},  {38.0952F, 61.9048F}, {28.5714F, 52.381F},
    {23.8095F, 38.0952F}, {23.8095F, 28.5714F}, {28.5714F, 14.2857F},
    {38.0952F, 4.7619F},  {47.619F, 0.0F},      {61.9047F, 0.0F},
    {71.4285F, 4.7619F},  {80.9524F, 14.2857F}};

static const SFG_StrokeStrip kCh101st[] = {{17, kCh101st0}};

static const SFG_StrokeChar kCh101 = {104.762F, 1, kCh101st};

/* char: 0x66 */

static const SFG_StrokeVertex kCh102st0[] = {{71.4286F, 100.0F},
                                             {61.9048F, 100.0F},
                                             {52.381F, 95.2381F},
                                             {47.6191F, 80.9524F},
                                             {47.6191F, 0.0F}};

static const SFG_StrokeVertex kCh102st1[] = {{33.3334F, 66.6667F},
                                             {66.6667F, 66.6667F}};

static const SFG_StrokeStrip kCh102st[] = {{5, kCh102st0}, {2, kCh102st1}};

static const SFG_StrokeChar kCh102 = {104.762F, 2, kCh102st};

/* char: 0x67 */

static const SFG_StrokeVertex kCh103st0[] = {
    {80.9524F, 66.6667F},  {80.9524F, -9.5238F},  {76.1905F, -23.8095F},
    {71.4285F, -28.5714F}, {61.9047F, -33.3333F}, {47.619F, -33.3333F},
    {38.0952F, -28.5714F}};

static const SFG_StrokeVertex kCh103st1[] = {
    {80.9524F, 52.381F},  {71.4285F, 61.9048F}, {61.9047F, 66.6667F},
    {47.619F, 66.6667F},  {38.0952F, 61.9048F}, {28.5714F, 52.381F},
    {23.8095F, 38.0952F}, {23.8095F, 28.5714F}, {28.5714F, 14.2857F},
    {38.0952F, 4.7619F},  {47.619F, 0.0F},      {61.9047F, 0.0F},
    {71.4285F, 4.7619F},  {80.9524F, 14.2857F}};

static const SFG_StrokeStrip kCh103st[] = {{7, kCh103st0}, {14, kCh103st1}};

static const SFG_StrokeChar kCh103 = {104.762F, 2, kCh103st};

/* char: 0x68 */

static const SFG_StrokeVertex kCh104st0[] = {{26.1905F, 100.0F},
                                             {26.1905F, 0.0F}};

static const SFG_StrokeVertex kCh104st1[] = {
    {26.1905F, 47.619F},  {40.4762F, 61.9048F}, {50.0F, 66.6667F},
    {64.2857F, 66.6667F}, {73.8095F, 61.9048F}, {78.5715F, 47.619F},
    {78.5715F, 0.0F}};

static const SFG_StrokeStrip kCh104st[] = {{2, kCh104st0}, {7, kCh104st1}};

static const SFG_StrokeChar kCh104 = {104.762F, 2, kCh104st};

/* char: 0x69 */

static const SFG_StrokeVertex kCh105st0[] = {{47.6191F, 100.0F},
                                             {52.381F, 95.2381F},
                                             {57.1429F, 100.0F},
                                             {52.381F, 104.762F},
                                             {47.6191F, 100.0F}};

static const SFG_StrokeVertex kCh105st1[] = {{52.381F, 66.6667F},
                                             {52.381F, 0.0F}};

static const SFG_StrokeStrip kCh105st[] = {{5, kCh105st0}, {2, kCh105st1}};

static const SFG_StrokeChar kCh105 = {104.762F, 2, kCh105st};

/* char: 0x6a */

static const SFG_StrokeVertex kCh106st0[] = {{57.1429F, 100.0F},
                                             {61.9048F, 95.2381F},
                                             {66.6667F, 100.0F},
                                             {61.9048F, 104.762F},
                                             {57.1429F, 100.0F}};

static const SFG_StrokeVertex kCh106st1[] = {{61.9048F, 66.6667F},
                                             {61.9048F, -14.2857F},
                                             {57.1429F, -28.5714F},
                                             {47.6191F, -33.3333F},
                                             {38.0953F, -33.3333F}};

static const SFG_StrokeStrip kCh106st[] = {{5, kCh106st0}, {5, kCh106st1}};

static const SFG_StrokeChar kCh106 = {104.762F, 2, kCh106st};

/* char: 0x6b */

static const SFG_StrokeVertex kCh107st0[] = {{26.1905F, 100.0F},
                                             {26.1905F, 0.0F}};

static const SFG_StrokeVertex kCh107st1[] = {{73.8095F, 66.6667F},
                                             {26.1905F, 19.0476F}};

static const SFG_StrokeVertex kCh107st2[] = {{45.2381F, 38.0952F},
                                             {78.5715F, 0.0F}};

static const SFG_StrokeStrip kCh107st[] = {
    {2, kCh107st0}, {2, kCh107st1}, {2, kCh107st2}};

static const SFG_StrokeChar kCh107 = {104.762F, 3, kCh107st};

/* char: 0x6c */

static const SFG_StrokeVertex kCh108st0[] = {{52.381F, 100.0F},
                                             {52.381F, 0.0F}};

static const SFG_StrokeStrip kCh108st[] = {{2, kCh108st0}};

static const SFG_StrokeChar kCh108 = {104.762F, 1, kCh108st};

/* char: 0x6d */

static const SFG_StrokeVertex kCh109st0[] = {{0, 66.6667F}, {0, 0.0F}};

static const SFG_StrokeVertex kCh109st1[] = {
    {0, 47.619F},         {14.2857F, 61.9048F}, {23.8095F, 66.6667F},
    {38.0952F, 66.6667F}, {47.619F, 61.9048F},  {52.381F, 47.619F},
    {52.381F, 0.0F}};

static const SFG_StrokeVertex kCh109st2[] = {
    {52.381F, 47.619F},   {66.6667F, 61.9048F}, {76.1905F, 66.6667F},
    {90.4762F, 66.6667F}, {100.0F, 61.9048F},   {104.762F, 47.619F},
    {104.762F, 0.0F}};

static const SFG_StrokeStrip kCh109st[] = {
    {2, kCh109st0}, {7, kCh109st1}, {7, kCh109st2}};

static const SFG_StrokeChar kCh109 = {104.762F, 3, kCh109st};

/* char: 0x6e */

static const SFG_StrokeVertex kCh110st0[] = {{26.1905F, 66.6667F},
                                             {26.1905F, 0.0F}};

static const SFG_StrokeVertex kCh110st1[] = {
    {26.1905F, 47.619F},  {40.4762F, 61.9048F}, {50.0F, 66.6667F},
    {64.2857F, 66.6667F}, {73.8095F, 61.9048F}, {78.5715F, 47.619F},
    {78.5715F, 0.0F}};

static const SFG_StrokeStrip kCh110st[] = {{2, kCh110st0}, {7, kCh110st1}};

static const SFG_StrokeChar kCh110 = {104.762F, 2, kCh110st};

/* char: 0x6f */

static const SFG_StrokeVertex kCh111st0[] = {
    {45.2381F, 66.6667F}, {35.7143F, 61.9048F}, {26.1905F, 52.381F},
    {21.4286F, 38.0952F}, {21.4286F, 28.5714F}, {26.1905F, 14.2857F},
    {35.7143F, 4.7619F},  {45.2381F, 0.0F},     {59.5238F, 0.0F},
    {69.0476F, 4.7619F},  {78.5714F, 14.2857F}, {83.3334F, 28.5714F},
    {83.3334F, 38.0952F}, {78.5714F, 52.381F},  {69.0476F, 61.9048F},
    {59.5238F, 66.6667F}, {45.2381F, 66.6667F}};

static const SFG_StrokeStrip kCh111st[] = {{17, kCh111st0}};

static const SFG_StrokeChar kCh111 = {104.762F, 1, kCh111st};

/* char: 0x70 */

static const SFG_StrokeVertex kCh112st0[] = {{23.8095F, 66.6667F},
                                             {23.8095F, -33.3333F}};

static const SFG_StrokeVertex kCh112st1[] = {
    {23.8095F, 52.381F},  {33.3333F, 61.9048F}, {42.8571F, 66.6667F},
    {57.1428F, 66.6667F}, {66.6666F, 61.9048F}, {76.1905F, 52.381F},
    {80.9524F, 38.0952F}, {80.9524F, 28.5714F}, {76.1905F, 14.2857F},
    {66.6666F, 4.7619F},  {57.1428F, 0.0F},     {42.8571F, 0.0F},
    {33.3333F, 4.7619F},  {23.8095F, 14.2857F}};

static const SFG_StrokeStrip kCh112st[] = {{2, kCh112st0}, {14, kCh112st1}};

static const SFG_StrokeChar kCh112 = {104.762F, 2, kCh112st};

/* char: 0x71 */

static const SFG_StrokeVertex kCh113st0[] = {{80.9524F, 66.6667F},
                                             {80.9524F, -33.3333F}};

static const SFG_StrokeVertex kCh113st1[] = {
    {80.9524F, 52.381F},  {71.4285F, 61.9048F}, {61.9047F, 66.6667F},
    {47.619F, 66.6667F},  {38.0952F, 61.9048F}, {28.5714F, 52.381F},
    {23.8095F, 38.0952F}, {23.8095F, 28.5714F}, {28.5714F, 14.2857F},
    {38.0952F, 4.7619F},  {47.619F, 0.0F},      {61.9047F, 0.0F},
    {71.4285F, 4.7619F},  {80.9524F, 14.2857F}};

static const SFG_StrokeStrip kCh113st[] = {{2, kCh113st0}, {14, kCh113st1}};

static const SFG_StrokeChar kCh113 = {104.762F, 2, kCh113st};

/* char: 0x72 */

static const SFG_StrokeVertex kCh114st0[] = {{33.3334F, 66.6667F},
                                             {33.3334F, 0.0F}};

static const SFG_StrokeVertex kCh114st1[] = {{33.3334F, 38.0952F},
                                             {38.0953F, 52.381F},
                                             {47.6191F, 61.9048F},
                                             {57.1429F, 66.6667F},
                                             {71.4286F, 66.6667F}};

static const SFG_StrokeStrip kCh114st[] = {{2, kCh114st0}, {5, kCh114st1}};

static const SFG_StrokeChar kCh114 = {104.762F, 2, kCh114st};

/* char: 0x73 */

static const SFG_StrokeVertex kCh115st0[] = {
    {78.5715F, 52.381F},  {73.8095F, 61.9048F}, {59.5238F, 66.6667F},
    {45.2381F, 66.6667F}, {30.9524F, 61.9048F}, {26.1905F, 52.381F},
    {30.9524F, 42.8571F}, {40.4762F, 38.0952F}, {64.2857F, 33.3333F},
    {73.8095F, 28.5714F}, {78.5715F, 19.0476F}, {78.5715F, 14.2857F},
    {73.8095F, 4.7619F},  {59.5238F, 0.0F},     {45.2381F, 0.0F},
    {30.9524F, 4.7619F},  {26.1905F, 14.2857F}};

static const SFG_StrokeStrip kCh115st[] = {{17, kCh115st0}};

static const SFG_StrokeChar kCh115 = {104.762F, 1, kCh115st};

/* char: 0x74 */

static const SFG_StrokeVertex kCh116st0[] = {{47.6191F, 100.0F},
                                             {47.6191F, 19.0476F},
                                             {52.381F, 4.7619F},
                                             {61.9048F, 0.0F},
                                             {71.4286F, 0.0F}};

static const SFG_StrokeVertex kCh116st1[] = {{33.3334F, 66.6667F},
                                             {66.6667F, 66.6667F}};

static const SFG_StrokeStrip kCh116st[] = {{5, kCh116st0}, {2, kCh116st1}};

static const SFG_StrokeChar kCh116 = {104.762F, 2, kCh116st};

/* char: 0x75 */

static const SFG_StrokeVertex kCh117st0[] = {
    {26.1905F, 66.6667F}, {26.1905F, 19.0476F}, {30.9524F, 4.7619F},
    {40.4762F, 0.0F},     {54.7619F, 0.0F},     {64.2857F, 4.7619F},
    {78.5715F, 19.0476F}};

static const SFG_StrokeVertex kCh117st1[] = {{78.5715F, 66.6667F},
                                             {78.5715F, 0.0F}};

static const SFG_StrokeStrip kCh117st[] = {{7, kCh117st0}, {2, kCh117st1}};

static const SFG_StrokeChar kCh117 = {104.762F, 2, kCh117st};

/* char: 0x76 */

static const SFG_StrokeVertex kCh118st0[] = {{23.8095F, 66.6667F},
                                             {52.3809F, 0.0F}};

static const SFG_StrokeVertex kCh118st1[] = {{80.9524F, 66.6667F},
                                             {52.3809F, 0.0F}};

static const SFG_StrokeStrip kCh118st[] = {{2, kCh118st0}, {2, kCh118st1}};

static const SFG_StrokeChar kCh118 = {104.762F, 2, kCh118st};

/* char: 0x77 */

static const SFG_StrokeVertex kCh119st0[] = {{14.2857F, 66.6667F},
                                             {33.3333F, 0.0F}};

static const SFG_StrokeVertex kCh119st1[] = {{52.3809F, 66.6667F},
                                             {33.3333F, 0.0F}};

static const SFG_StrokeVertex kCh119st2[] = {{52.3809F, 66.6667F},
                                             {71.4286F, 0.0F}};

static const SFG_StrokeVertex kCh119st3[] = {{90.4762F, 66.6667F},
                                             {71.4286F, 0.0F}};

static const SFG_StrokeStrip kCh119st[] = {
    {2, kCh119st0}, {2, kCh119st1}, {2, kCh119st2}, {2, kCh119st3}};

static const SFG_StrokeChar kCh119 = {104.762F, 4, kCh119st};

/* char: 0x78 */

static const SFG_StrokeVertex kCh120st0[] = {{26.1905F, 66.6667F},
                                             {78.5715F, 0.0F}};

static const SFG_StrokeVertex kCh120st1[] = {{78.5715F, 66.6667F},
                                             {26.1905F, 0.0F}};

static const SFG_StrokeStrip kCh120st[] = {{2, kCh120st0}, {2, kCh120st1}};

static const SFG_StrokeChar kCh120 = {104.762F, 2, kCh120st};

/* char: 0x79 */

static const SFG_StrokeVertex kCh121st0[] = {{26.1905F, 66.6667F},
                                             {54.7619F, 0.0F}};

static const SFG_StrokeVertex kCh121st1[] = {
    {83.3334F, 66.6667F},  {54.7619F, 0.0F},      {45.2381F, -19.0476F},
    {35.7143F, -28.5714F}, {26.1905F, -33.3333F}, {21.4286F, -33.3333F}};

static const SFG_StrokeStrip kCh121st[] = {{2, kCh121st0}, {6, kCh121st1}};

static const SFG_StrokeChar kCh121 = {104.762F, 2, kCh121st};

/* char: 0x7a */

static const SFG_StrokeVertex kCh122st0[] = {{78.5715F, 66.6667F},
                                             {26.1905F, 0.0F}};

static const SFG_StrokeVertex kCh122st1[] = {{26.1905F, 66.6667F},
                                             {78.5715F, 66.6667F}};

static const SFG_StrokeVertex kCh122st2[] = {{26.1905F, 0.0F},
                                             {78.5715F, 0.0F}};

static const SFG_StrokeStrip kCh122st[] = {
    {2, kCh122st0}, {2, kCh122st1}, {2, kCh122st2}};

static const SFG_StrokeChar kCh122 = {104.762F, 3, kCh122st};

/* char: 0x7b */

static const SFG_StrokeVertex kCh123st0[] = {
    {64.2857F, 119.048F}, {54.7619F, 114.286F}, {50.0F, 109.524F},
    {45.2381F, 100.0F},   {45.2381F, 90.4762F}, {50.0F, 80.9524F},
    {54.7619F, 76.1905F}, {59.5238F, 66.6667F}, {59.5238F, 57.1429F},
    {50.0F, 47.619F}};

static const SFG_StrokeVertex kCh123st1[] = {
    {54.7619F, 114.286F}, {50.0F, 104.762F},    {50.0F, 95.2381F},
    {54.7619F, 85.7143F}, {59.5238F, 80.9524F}, {64.2857F, 71.4286F},
    {64.2857F, 61.9048F}, {59.5238F, 52.381F},  {40.4762F, 42.8571F},
    {59.5238F, 33.3333F}, {64.2857F, 23.8095F}, {64.2857F, 14.2857F},
    {59.5238F, 4.7619F},  {54.7619F, 0.0F},     {50.0F, -9.5238F},
    {50.0F, -19.0476F},   {54.7619F, -28.5714F}};

static const SFG_StrokeVertex kCh123st2[] = {
    {50.0F, 38.0952F},     {59.5238F, 28.5714F}, {59.5238F, 19.0476F},
    {54.7619F, 9.5238F},   {50.0F, 4.7619F},     {45.2381F, -4.7619F},
    {45.2381F, -14.2857F}, {50.0F, -23.8095F},   {54.7619F, -28.5714F},
    {64.2857F, -33.3333F}};

static const SFG_StrokeStrip kCh123st[] = {
    {10, kCh123st0}, {17, kCh123st1}, {10, kCh123st2}};

static const SFG_StrokeChar kCh123 = {104.762F, 3, kCh123st};

/* char: 0x7c */

static const SFG_StrokeVertex kCh124st0[] = {{52.381F, 119.048F},
                                             {52.381F, -33.3333F}};

static const SFG_StrokeStrip kCh124st[] = {{2, kCh124st0}};

static const SFG_StrokeChar kCh124 = {104.762F, 1, kCh124st};

/* char: 0x7d */

static const SFG_StrokeVertex kCh125st0[] = {
    {40.4762F, 119.048F}, {50.0F, 114.286F},    {54.7619F, 109.524F},
    {59.5238F, 100.0F},   {59.5238F, 90.4762F}, {54.7619F, 80.9524F},
    {50.0F, 76.1905F},    {45.2381F, 66.6667F}, {45.2381F, 57.1429F},
    {54.7619F, 47.619F}};

static const SFG_StrokeVertex kCh125st1[] = {
    {50.0F, 114.286F},     {54.7619F, 104.762F}, {54.7619F, 95.2381F},
    {50.0F, 85.7143F},     {45.2381F, 80.9524F}, {40.4762F, 71.4286F},
    {40.4762F, 61.9048F},  {45.2381F, 52.381F},  {64.2857F, 42.8571F},
    {45.2381F, 33.3333F},  {40.4762F, 23.8095F}, {40.4762F, 14.2857F},
    {45.2381F, 4.7619F},   {50.0F, 0.0F},        {54.7619F, -9.5238F},
    {54.7619F, -19.0476F}, {50.0F, -28.5714F}};

static const SFG_StrokeVertex kCh125st2[] = {
    {54.7619F, 38.0952F},  {45.2381F, 28.5714F},  {45.2381F, 19.0476F},
    {50.0F, 9.5238F},      {54.7619F, 4.7619F},   {59.5238F, -4.7619F},
    {59.5238F, -14.2857F}, {54.7619F, -23.8095F}, {50.0F, -28.5714F},
    {40.4762F, -33.3333F}};

static const SFG_StrokeStrip kCh125st[] = {
    {10, kCh125st0}, {17, kCh125st1}, {10, kCh125st2}};

static const SFG_StrokeChar kCh125 = {104.762F, 3, kCh125st};

/* char: 0x7e */

static const SFG_StrokeVertex kCh126st0[] = {
    {9.5238F, 28.5714F},  {9.5238F, 38.0952F},  {14.2857F, 52.381F},
    {23.8095F, 57.1429F}, {33.3333F, 57.1429F}, {42.8571F, 52.381F},
    {61.9048F, 38.0952F}, {71.4286F, 33.3333F}, {80.9524F, 33.3333F},
    {90.4762F, 38.0952F}, {95.2381F, 47.619F}};

static const SFG_StrokeVertex kCh126st1[] = {
    {9.5238F, 38.0952F},  {14.2857F, 47.619F},  {23.8095F, 52.381F},
    {33.3333F, 52.381F},  {42.8571F, 47.619F},  {61.9048F, 33.3333F},
    {71.4286F, 28.5714F}, {80.9524F, 28.5714F}, {90.4762F, 33.3333F},
    {95.2381F, 47.619F},  {95.2381F, 57.1429F}};

static const SFG_StrokeStrip kCh126st[] = {{11, kCh126st0}, {11, kCh126st1}};

static const SFG_StrokeChar kCh126 = {104.762F, 2, kCh126st};

/* char: 0x7f */

static const SFG_StrokeVertex kCh127st0[] = {{71.4286F, 100.0F},
                                             {33.3333F, -33.3333F}};

static const SFG_StrokeVertex kCh127st1[] = {
    {47.619F, 66.6667F},  {33.3333F, 61.9048F}, {23.8095F, 52.381F},
    {19.0476F, 38.0952F}, {19.0476F, 23.8095F}, {23.8095F, 14.2857F},
    {33.3333F, 4.7619F},  {47.619F, 0.0F},      {57.1428F, 0.0F},
    {71.4286F, 4.7619F},  {80.9524F, 14.2857F}, {85.7143F, 28.5714F},
    {85.7143F, 42.8571F}, {80.9524F, 52.381F},  {71.4286F, 61.9048F},
    {57.1428F, 66.6667F}, {47.619F, 66.6667F}};

static const SFG_StrokeStrip kCh127st[] = {{2, kCh127st0}, {17, kCh127st1}};

static const SFG_StrokeChar kCh127 = {104.762F, 2, kCh127st};

static const SFG_StrokeChar *chars[] = {
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
    &kCh32,  &kCh33,  &kCh34,  &kCh35,  &kCh36,  &kCh37,  &kCh38,  &kCh39,
    &kCh40,  &kCh41,  &kCh42,  &kCh43,  &kCh44,  &kCh45,  &kCh46,  &kCh47,
    &kCh48,  &kCh49,  &kCh50,  &kCh51,  &kCh52,  &kCh53,  &kCh54,  &kCh55,
    &kCh56,  &kCh57,  &kCh58,  &kCh59,  &kCh60,  &kCh61,  &kCh62,  &kCh63,
    &kCh64,  &kCh65,  &kCh66,  &kCh67,  &kCh68,  &kCh69,  &kCh70,  &kCh71,
    &kCh72,  &kCh73,  &kCh74,  &kCh75,  &kCh76,  &kCh77,  &kCh78,  &kCh79,
    &kCh80,  &kCh81,  &kCh82,  &kCh83,  &kCh84,  &kCh85,  &kCh86,  &kCh87,
    &kCh88,  &kCh89,  &kCh90,  &kCh91,  &kCh92,  &kCh93,  &kCh94,  &kCh95,
    &kCh96,  &kCh97,  &kCh98,  &kCh99,  &kCh100, &kCh101, &kCh102, &kCh103,
    &kCh104, &kCh105, &kCh106, &kCh107, &kCh108, &kCh109, &kCh110, &kCh111,
    &kCh112, &kCh113, &kCh114, &kCh115, &kCh116, &kCh117, &kCh118, &kCh119,
    &kCh120, &kCh121, &kCh122, &kCh123, &kCh124, &kCh125, &kCh126, &kCh127};

const SFG_StrokeFont kFgStrokeMonoRoman = {const_cast<char *>("MonoRoman"), 128,
                                           152.381F, chars};

}  // namespace freeglut_minimal
