# This file was generated by liblab | https://liblab.com/

from .services.collections import CollectionsService
from .services.indexes import IndexesService
from .services.vectors import VectorsService
from .net.environment import Environment


class Gandi:
    def __init__(
        self, access_token: str = None, base_url: str = Environment.DEFAULT.value
    ):
        """
        Initializes Gandi the SDK class.
        """
        self.collections = CollectionsService(base_url=base_url)
        self.indexes = IndexesService(base_url=base_url)
        self.vectors = VectorsService(base_url=base_url)
        self.set_access_token(access_token)

    def set_base_url(self, base_url):
        """
        Sets the base URL for the entire SDK.
        """
        self.collections.set_base_url(base_url)
        self.indexes.set_base_url(base_url)
        self.vectors.set_base_url(base_url)

        return self

    def set_access_token(self, access_token: str):
        """
        Sets the access token for the entire SDK.
        """
        self.collections.set_access_token(access_token)
        self.indexes.set_access_token(access_token)
        self.vectors.set_access_token(access_token)

        return self


# c029837e0e474b76bc487506e8799df5e3335891efe4fb02bda7a1441840310c
