# This file was generated by liblab | https://liblab.com/

from .utils.validator import Validator
from .utils.base_service import BaseService
from ..net.transport.serializer import Serializer
from ..models.utils.cast_models import cast_models
from ..models.collection.collections_rename_request import CollectionRenameRequest
from ..models.collection.collections_release_request import CollectionReleaseRequest
from ..models.collection.collections_load_request import CollectionLoadRequest
from ..models.collection.collections_list_request import CollectionListRequest
from ..models.collection.collections_has_request import CollectionHasRequest
from ..models.collection.collections_get_stats_request import (
    CollectionGetStatsRequest,
)
from ..models.collection.collections_get_load_state_request import (
    CollectionGetLoadStateRequest,
)
from ..models.collection.collections_drop_request import CollectionDropRequest
from ..models.collection.collection_describe_request import (
    CollectionDescribeRequest,
)
from ..models.collection.collection import Collection


class CollectionsService(BaseService):

    @cast_models
    def create(self, collection: Collection):
        """This operation creates a collection in a specified project.

        :param request_body: The collection object.
        :type request_body: Collection
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """

        Validator(Collection).validate(collection)

        serialized_request = (
            Serializer(
                f"{self.base_url}/collections/create", self.get_default_headers()
            )
            .serialize()
            .set_method("POST")
            .set_body(collection)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def describe(self, collection_name: str, host: str, project_id: str):
        """Returns the details of a collection.

        :param collection_name: The name of the collection.
        :type collection_name: str
        :param host: The host of the collection.
        :type host: str
        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """

        request_body = CollectionDescribeRequest(
            collection_name=collection_name, host=host, project_id=project_id
        )
        Validator(CollectionDescribeRequest).validate(request_body)

        serialized_request = (
            Serializer(
                f"{self.base_url}/collections/describe", self.get_default_headers()
            )
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def drop(self, collection_name: str, host: str, project_id: str):
        """This operation drops the current collection and all data within the collection.

        :param collection_name: The name of the collection.
        :type collection_name: str
        :param host: The host of the collection.
        :type host: str
        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """
        request_body = CollectionDropRequest(
            collection_name=collection_name, host=host, project_id=project_id
        )
        Validator(CollectionDropRequest).validate(request_body)

        serialized_request = (
            Serializer(f"{self.base_url}/collections/drop", self.get_default_headers())
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def get_load_state(
        self,
        collection_name: str,
        host: str,
        project_id: str,
        partition_names: str = None,
    ):
        """Returns the load state of a specific collection.

        :param collection_name: The name of the collection.
        :type collection_name: str
        :param host: The host of the collection.
        :type host: str
        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :param partition_names: The names of the partitions to get the load state.
        :type partition_names: str
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """
        request_body = CollectionGetLoadStateRequest(
            collection_name=collection_name,
            host=host,
            project_id=project_id,
            partition_names=partition_names,
        )
        Validator(CollectionGetLoadStateRequest).validate(request_body)

        serialized_request = (
            Serializer(
                f"{self.base_url}/collections/get_load_state",
                self.get_default_headers(),
            )
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def get_stats(self, collection_name: str, host: str, project_id: str):
        """This operation gets the number of entities in a collection.

        :param collection_name: The name of the collection.
        :type collection_name: str
        :param host: The host of the collection.
        :type host: str
        :param project_id: ID of the project where the collection is.
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """
        request_body = CollectionGetStatsRequest(
            collection_name=collection_name, host=host, project_id=project_id
        )
        Validator(CollectionGetStatsRequest).validate(request_body)

        serialized_request = (
            Serializer(
                f"{self.base_url}/collections/get_stats", self.get_default_headers()
            )
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def has(self, collection_name: str, host: str, project_id: str):
        """Checks if a collection exists in the project.

        :param collection_name: The name of the collection.
        :type collection_name: str
        :param host: The host of the collection.
        :type host: str
        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """
        request_body = CollectionHasRequest(
            collection_name=collection_name, host=host, project_id=project_id
        )
        Validator(CollectionHasRequest).validate(request_body)

        serialized_request = (
            Serializer(f"{self.base_url}/collections/has", self.get_default_headers())
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def list(self, project_id: str, host: str):
        """Returns a list of all collections in the specified project.

        :param host: The host of the collection.
        :type host: str
        :param project_id: ID of the project where the collections are.
        :type project_id: str
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """
        request_body = CollectionListRequest(project_id=project_id, host=host)
        Validator(CollectionListRequest).validate(request_body)

        serialized_request = (
            Serializer(f"{self.base_url}/collections/list", self.get_default_headers())
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def load(self, collection_name: str, host: str, project_id: str):
        """Loads a collection into memory.

        :param collection_name: The name of the collection.
        :type collection_name: str
        :param host: The host of the collection.
        :type host: str
        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """
        request_body = CollectionLoadRequest(
            collection_name=collection_name, host=host, project_id=project_id
        )
        Validator(CollectionLoadRequest).validate(request_body)

        serialized_request = (
            Serializer(f"{self.base_url}/collections/load", self.get_default_headers())
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def release(self, collection_name: str, host: str, project_id: str):
        """Releases a collection from memory.

        :param collection_name: The name of the collection.
        :type collection_name: str
        :param host: The host of the collection.
        :type host: str
        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """
        request_body = CollectionReleaseRequest(
            collection_name=collection_name, host=host, project_id=project_id
        )
        Validator(CollectionReleaseRequest).validate(request_body)

        serialized_request = (
            Serializer(
                f"{self.base_url}/collections/release", self.get_default_headers()
            )
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def rename(
        self,
        collection_name: str,
        new_collection_name: str,
        host: str,
        project_id: str,
    ):
        """This operation renames an existing collection and optionally moves the collection to a new database.

        :param collection_name: The name of the collection.
        :type collection_name: str
        :param new_collection_name: Collections new name.
        :param host: The host of the collection.
        :type host: str
        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """
        request_body = CollectionRenameRequest(
            collection_name=collection_name,
            new_collection_name=new_collection_name,
            host=host,
            project_id=project_id,
        )
        Validator(CollectionRenameRequest).validate(request_body)

        serialized_request = (
            Serializer(
                f"{self.base_url}/collections/rename", self.get_default_headers()
            )
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response
