# This file was generated by liblab | https://liblab.com/

from typing import List, Union
from .utils.validator import Validator
from .utils.base_service import BaseService
from ..net.transport.serializer import Serializer
from ..models.utils.cast_models import cast_models
from ..models.vector.vectors_upsert_request import VectorsUpsertRequest
from ..models.vector.vectors_search_request import VectorsSearchRequest, SearchParams
from ..models.vector.vectors_query_request import VectorsQueryRequest
from ..models.vector.vectors_insert_request import VectorsInsertRequest
from ..models.vector.vectors_get_request import VectorsGetRequest
from ..models.vector.vectors_delete_request import VectorsDeleteRequest
from ..models.vector.vectors_hybrid_search_request import VectorsHybridSearchRequest


class VectorsService(BaseService):

    @cast_models
    def delete(
        self,
        collection_name: str,
        project_id: str,
        filter: str,
        host: str,
        partition_name: str = None,
    ):
        """This operation deletes entities by their IDs or with a boolean expression.

        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :param collection_name: The name of the collection.
        :type collection_name: str
        :param filter: Filter that can be used to match IDs or used as a scalar filtering condition to specify entities.
        :type filter: str
        :param partition_name: The entities will be deleted from this partition in the collection if specified.
        :type partition_name: str, optional
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """

        request_body = VectorsDeleteRequest(
            collection_name=collection_name,
            project_id=project_id,
            filter=filter,
            partition_name=partition_name,
            host=host,
        )

        Validator(VectorsDeleteRequest).validate(request_body)

        serialized_request = (
            Serializer(f"{self.base_url}/vectors/delete", self.get_default_headers())
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def get(
        self,
        collection_name: str,
        project_id: str,
        id: Union[int, str, List[int], List[str]] = None,
        host: str = "",
        partition_names: List[str] = None,
        output_fields: List[str] = None,
    ):
        """This operation gets vectors by their IDs.

        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :param collection_name: The name of the collection.
        :type collection_name: str
        :param id: ID of the vectors to return.
        :type id: int, str, List[int], List[str]
        :param partition_names: Partitions to get the vectors from.
        :type partition_names: List[str], optional
        :param output_fields: The fields to return with data.
        :type output_fields: List[str], optional
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """
        request_body = VectorsGetRequest(
            project_id=project_id,
            collection_name=collection_name,
            id_=id,
            host=host,
            partition_names=partition_names,
            output_fields=output_fields,
        )

        Validator(VectorsGetRequest).validate(request_body)

        serialized_request = (
            Serializer(f"{self.base_url}/vectors/get", self.get_default_headers())
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def insert(
        self,
        project_id: str,
        collection_name: str,
        host: str,
        data: Union[dict, List[dict]] = {},
        partition_name: str = None,
    ):
        """This operation inserts vectors into a specified collection.

        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :param collection_name: The name of the collection to insert.
        :type collection_name: str
        :param data: The data to insert into the collection. It should match the schema of the given collection.
        :type data: dict, List[dict]
        :param partition_names: The name of a partition in the current collection. If specified, the data is to be inserted into the specified partition.
        :type partition_name: str, optional
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """

        request_body = VectorsInsertRequest(
            collection_name=collection_name,
            project_id=project_id,
            partition_name=partition_name,
            data=data,
            host=host,
        )

        Validator(VectorsInsertRequest).validate(request_body)

        serialized_request = (
            Serializer(f"{self.base_url}/vectors/insert", self.get_default_headers())
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def query(
        self,
        project_id: str,
        collection_name: str,
        filter: str,
        partition_names: List[str] = None,
        output_fields: List[str] = None,
    ):
        """This operation queries vectors in a specified collection.

        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :param collection_name: The name of the collection to query.
        :type collection_name: str
        :param filter: Filter that can be used to match IDs or used as a scalar filtering condition to specify entities.
        :type filter: str
        :param partition_names: Partitions to get the vectors from.
        :type partition_names: List[str], optional
        :param output_fields: The fields to return with data.
        :type output_fields: List[str], optional
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """

        request_body = VectorsQueryRequest(
            project_id=project_id,
            collection_name=collection_name,
            filter=filter,
            partition_names=partition_names,
            output_fields=output_fields,
        )

        Validator(VectorsQueryRequest).validate(request_body)

        serialized_request = (
            Serializer(f"{self.base_url}/vectors/query", self.get_default_headers())
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def search(
        self,
        collection_name: str,
        project_id: str,
        partition_names: List[str] = None,
        output_fields: List[str] = None,
        anss_field: str = None,
        limit: int = None,
        offset: int = None,
        filter: str = None,
        grouping_field: str = None,
        search_params: SearchParams = None,
    ):
        """This operation searches vectors in a specified collection.

        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :param collection_name: The name of the collection to query.
        :type collection_name: str
        :param partition_names: Partitions to get the vectors from.
        :type partition_names: List[str], optional
        :param output_fields: The fields to return with data.
        :type output_fields: List[str], optional
        :param anss_field: The name of the field that contains the vectors.
        :type anss_field: str, optional
        :param limit: The maximum number of results to return from the search.
        :type limit: int, optional
        :param offset: The number of results to skip before starting to return results. Used for pagination.
        :type offset: int, optional
        :param filter: A filter expression used to narrow down the search results.
        :type filter: str, optional
        :param grouping_field: The field by which to group the search results.
        :type grouping_field: str, optional
        :param search_params: Additional parameters for the search
        :type search_params: SearchParams, optional
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """

        request_body = VectorsSearchRequest(
            project_id=project_id,
            collection_name=collection_name,
            partition_names=partition_names,
            output_fields=output_fields,
            anss_field=anss_field,
            limit=limit,
            offset=offset,
            filter=filter,
            grouping_field=grouping_field,
            search_params=search_params,
        )

        Validator(VectorsSearchRequest).validate(request_body)

        serialized_request = (
            Serializer(f"{self.base_url}/vectors/search", self.get_default_headers())
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def hybrid_search(self, request_body: VectorsHybridSearchRequest):
        """This operation searches vectors in a specified collection.

        :param request_body: The request body.
        :type request_body: VectorsHybridSearchRequest
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """

        Validator(VectorsHybridSearchRequest).validate(request_body)

        serialized_request = (
            Serializer(
                f"{self.base_url}/vectors/hybrid_search", self.get_default_headers()
            )
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response

    @cast_models
    def upsert(
        self,
        project_id: str,
        collection_name: str,
        host: str,
        data: Union[dict, List[dict]] = {},
        partition_name: str = None,
    ):
        """This operation inserts vectors into a specified collection and updates the existing ones.

        :param project_id: ID of the project where the collection is.
        :type project_id: str
        :param collection_name: The name of the collection to upsert.
        :type collection_name: str
        :param data: The data to upsert into the collection. It should match the schema of the given collection.
        :type data: dict, List[dict]
        :param partition_names: The name of a partition in the current collection. If specified, the data is to be upserted into the specified partition.
        :type partition_name: str, optional
        :raises RequestError: Raised when a request fails, with optional HTTP status code and details.
        """

        request_body = VectorsUpsertRequest(
            collection_name=collection_name,
            project_id=project_id,
            partition_name=partition_name,
            data=data,
            host=host,
        )

        Validator(VectorsUpsertRequest).validate(request_body)

        serialized_request = (
            Serializer(f"{self.base_url}/vectors/upsert", self.get_default_headers())
            .serialize()
            .set_method("POST")
            .set_body(request_body)
        )

        response = self.send_request(serialized_request)

        return response
