# GCP Python Client Functions

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Installation

Launch a terminal and install by entering:

``` sh
conda install gcp_python_client_functions
```

…or

``` sh
pip install gcp_python_client_functions
```

## Usage Prerequisites

### 1. GCP environment

- Create a GCP project by going to the [Resource
  Manager](https://console.cloud.google.com/project?_ga=2.198902124.2143434848.1693760593-97706481.1691864848)
  page in the cloud console ([cloud resources naming
  convention](https://stepan.wtf/cloud-naming-convention/#:~:text=The%20rule%20of%20thumb%20is,or%20within%20a%20given%20scope.)).
- Enable billing for the project you’ll work with by going to the [Cloud
  Billing](https://console.cloud.google.com/billing/) page and selecting
  your project on the top right corner (300 USD free credits are
  associated with new billing accounts + a [big list of free tier
  products](https://cloud.google.com/free?_ga=2.49992806.-1313173218.1693453955)).
- Enable BigQuery API by going to [APIs &
  Services](https://console.cloud.google.com/apis/) page on the cloud
  console and looking for the BigQuery API.

### 2. Authentication

[Authenticating](https://googleapis.dev/python/google-api-core/latest/auth.html)
by… - (locally) using the [Google Cloud
SDK](http://cloud.google.com/sdk)(installation needed). Launch a
terminal enter:

``` sh
gcloud auth login --update-adc
```

- (elsewhere) [downloading a service account JSON
  keyfile](https://cloud.google.com/iam/docs/keys-create-delete#creating)
  and point to it using an environment variable:

``` sh
export GOOGLE_APPLICATION_CREDENTIALS="/path/to/keyfile.json"
```

- or through [Workflow Identity
  Provider](https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/configuring-openid-connect-in-google-cloud-platform)
  (what we used to authenticate within GitHub Actions, see [Cloud
  Advocate’s video](https://www.youtube.com/watch?v=zRF5uTWXV8Y) and
  [stackoverflow
  question](https://stackoverflow.com/questions/75573270/github-action-doesnt-work-with-gcp-403-permission-iam-serviceaccounts-getacc)
  for additional support).

## How to use

``` python
from gcp_python_client_functions.clients import *

PROJECT_ID = 'dz-learning-d'

# BigQuery
bq_obj = BigQuery(PROJECT_ID)

# Cloud Storage
stg_obj = Storage(PROJECT_ID)
```
