# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['geekbench_browser']

package_data = \
{'': ['*']}

install_requires = \
['click',
 'pandas>=1.3',
 'py-cpuinfo>=9.0.0,<10.0.0',
 'requests-cache',
 'rich>=13.3.1,<14.0.0']

entry_points = \
{'console_scripts': ['gbr = geekbench_browser.__main__:cli',
                     'geekbench-browser = geekbench_browser.__main__:cli']}

setup_kwargs = {
    'name': 'geekbench-browser-python',
    'version': '0.1.1',
    'description': 'Simple package for getting data from browser.geekbench.com',
    'long_description': '# Geekbench Browser Python\n\n<p align="center">\n  <a href="https://github.com/34j/geekbench-browser-python/actions/workflows/ci.yml?query=branch%3Amain">\n    <img src="https://img.shields.io/github/actions/workflow/status/34j/geekbench-browser-python/ci.yml?branch=main&label=CI&logo=github&style=flat-square" alt="CI Status" >\n  </a>\n  <a href="https://geekbench-browser-python.readthedocs.io">\n    <img src="https://img.shields.io/readthedocs/geekbench-browser-python.svg?logo=read-the-docs&logoColor=fff&style=flat-square" alt="Documentation Status">\n  </a>\n  <a href="https://codecov.io/gh/34j/geekbench-browser-python">\n    <img src="https://img.shields.io/codecov/c/github/34j/geekbench-browser-python.svg?logo=codecov&logoColor=fff&style=flat-square" alt="Test coverage percentage">\n  </a>\n</p>\n<p align="center">\n  <a href="https://python-poetry.org/">\n    <img src="https://img.shields.io/badge/packaging-poetry-299bd7?style=flat-square&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAASCAYAAABrXO8xAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAJJSURBVHgBfZLPa1NBEMe/s7tNXoxW1KJQKaUHkXhQvHgW6UHQQ09CBS/6V3hKc/AP8CqCrUcpmop3Cx48eDB4yEECjVQrlZb80CRN8t6OM/teagVxYZi38+Yz853dJbzoMV3MM8cJUcLMSUKIE8AzQ2PieZzFxEJOHMOgMQQ+dUgSAckNXhapU/NMhDSWLs1B24A8sO1xrN4NECkcAC9ASkiIJc6k5TRiUDPhnyMMdhKc+Zx19l6SgyeW76BEONY9exVQMzKExGKwwPsCzza7KGSSWRWEQhyEaDXp6ZHEr416ygbiKYOd7TEWvvcQIeusHYMJGhTwF9y7sGnSwaWyFAiyoxzqW0PM/RjghPxF2pWReAowTEXnDh0xgcLs8l2YQmOrj3N7ByiqEoH0cARs4u78WgAVkoEDIDoOi3AkcLOHU60RIg5wC4ZuTC7FaHKQm8Hq1fQuSOBvX/sodmNJSB5geaF5CPIkUeecdMxieoRO5jz9bheL6/tXjrwCyX/UYBUcjCaWHljx1xiX6z9xEjkYAzbGVnB8pvLmyXm9ep+W8CmsSHQQY77Zx1zboxAV0w7ybMhQmfqdmmw3nEp1I0Z+FGO6M8LZdoyZnuzzBdjISicKRnpxzI9fPb+0oYXsNdyi+d3h9bm9MWYHFtPeIZfLwzmFDKy1ai3p+PDls1Llz4yyFpferxjnyjJDSEy9CaCx5m2cJPerq6Xm34eTrZt3PqxYO1XOwDYZrFlH1fWnpU38Y9HRze3lj0vOujZcXKuuXm3jP+s3KbZVra7y2EAAAAAASUVORK5CYII=" alt="Poetry">\n  </a>\n  <a href="https://github.com/ambv/black">\n    <img src="https://img.shields.io/badge/code%20style-black-000000.svg?style=flat-square" alt="black">\n  </a>\n  <a href="https://github.com/pre-commit/pre-commit">\n    <img src="https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white&style=flat-square" alt="pre-commit">\n  </a>\n</p>\n<p align="center">\n  <a href="https://pypi.org/project/geekbench-browser-python/">\n    <img src="https://img.shields.io/pypi/v/geekbench-browser-python.svg?logo=python&logoColor=fff&style=flat-square" alt="PyPI Version">\n  </a>\n  <img src="https://img.shields.io/pypi/pyversions/geekbench-browser-python.svg?style=flat-square&logo=python&amp;logoColor=fff" alt="Supported Python versions">\n  <img src="https://img.shields.io/pypi/l/geekbench-browser-python.svg?style=flat-square" alt="License">\n</p>\n\nSimple package for getting data from [browser.geekbench.com](https://browser.geekbench.com/).\n\n## Usage\n\nBoth `geekbench-browser` and `gbr` are available as CLI commands. Requests are cached in `~/.cache/geekbench-browser-python` by default and refreshed every 24 hours.\n\n- Getting all data\n\n```shell\n$ gbr\n(very long output)\n```\n\n- Getting specific CPU data (Not case sensitive)\n\n```shell\n$ gbr 3600x 3900x\n┏━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━┳━━━━━━━┳━━━━━━━━━━━━┳━━━━━━━━━┳━━━━━━━━━┓\n┃                    ┃ description        ┃ single ┃ multi ┃ icon       ┃ family  ┃ samples ┃\n┡━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━╇━━━━━━━╇━━━━━━━━━━━━╇━━━━━━━━━╇━━━━━━━━━┩\n│ AMD Ryzen 5 3600X  │ 3.8 GHz (6 cores)  │ 1243   │ 6857  │ amd-ryzen5 │ Matisse │ 9606    │\n│ AMD Ryzen 5 3600XT │ 3.8 GHz (6 cores)  │ 1301   │ 7041  │ amd        │ Matisse │ 3241    │\n│ AMD Ryzen 9 3900X  │ 3.8 GHz (12 cores) │ 1275   │ 11664 │ amd-ryzen9 │ Matisse │ 24420   │\n│ AMD Ryzen 9 3900XT │ 3.8 GHz (12 cores) │ 1316   │ 11958 │ amd        │ Matisse │ 3409    │\n└────────────────────┴────────────────────┴────────┴───────┴────────────┴─────────┴─────────┘\n```\n\n- Getting current CPU data and speific CPU data\n\n```shell\n$ gbr current 3900x\n┏━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━┳━━━━━━━┳━━━━━━━━━━━━┳━━━━━━━━━┳━━━━━━━━━┓\n┃                    ┃ description        ┃ single ┃ multi ┃ icon       ┃ family  ┃ samples ┃\n┡━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━╇━━━━━━━╇━━━━━━━━━━━━╇━━━━━━━━━╇━━━━━━━━━┩\n│ AMD Ryzen 9 3900X  │ 3.8 GHz (12 cores) │ 1275   │ 11664 │ amd-ryzen9 │ Matisse │ 24420   │\n│ AMD Ryzen 9 3900XT │ 3.8 GHz (12 cores) │ 1316   │ 11958 │ amd        │ Matisse │ 3409    │\n│ AMD Ryzen 9 3950X  │ 3.5 GHz (16 cores) │ 1295   │ 14127 │ amd-ryzen9 │ Matisse │ 11023   │\n└────────────────────┴────────────────────┴────────┴───────┴────────────┴─────────┴─────────┘\n```\n\n- Sorting by single score\n\n```shell\n$ gbr "ryzen 9" -s single\n┏━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━┳━━━━━━━┳━━━━━━━━━━━━┳━━━━━━━━━━━┳━━━━━━━━━┓\n┃                    ┃ description        ┃ single ┃ multi ┃ icon       ┃ family    ┃ samples ┃\n┡━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━╇━━━━━━━╇━━━━━━━━━━━━╇━━━━━━━━━━━╇━━━━━━━━━┩\n│ AMD Ryzen 9 7950X  │ 4.5 GHz (16 cores) │ 2191   │ 23093 │ amd        │ Raphael   │ 5996    │\n│ AMD Ryzen 9 7900X  │ 4.7 GHz (12 cores) │ 2181   │ 19243 │ amd        │ Raphael   │ 1857    │\n│ AMD Ryzen 9 7900   │ 3.7 GHz (12 cores) │ 2098   │ 17982 │ amd        │ Raphael   │ 177     │\n│ AMD Ryzen 9 5950X  │ 3.4 GHz (16 cores) │ 1682   │ 16439 │ amd        │ Vermeer   │ 58690   │\n│ AMD Ryzen 9 5900X  │ 3.7 GHz (12 cores) │ 1671   │ 13899 │ amd        │ Vermeer   │ 60238   │\n│ AMD Ryzen 9 5900   │ 3.0 GHz (12 cores) │ 1626   │ 12224 │ amd        │ Vermeer   │ 345     │\n│ AMD Ryzen 9 6900HX │ 3.3 GHz (8 cores)  │ 1513   │ 9174  │ amd        │ Rembrandt │ 1639    │\n│ AMD Ryzen 9 6900HS │ 3.3 GHz (8 cores)  │ 1416   │ 8479  │ amd        │ Rembrandt │ 1696    │\n│ AMD Ryzen 9 5900HX │ 3.3 GHz (8 cores)  │ 1410   │ 7640  │ amd        │ Cezanne   │ 13702   │\n│ AMD Ryzen 9 3900XT │ 3.8 GHz (12 cores) │ 1316   │ 11958 │ amd        │ Matisse   │ 3409    │\n│ AMD Ryzen 9 3950X  │ 3.5 GHz (16 cores) │ 1295   │ 14127 │ amd-ryzen9 │ Matisse   │ 11023   │\n│ AMD Ryzen 9 3900X  │ 3.8 GHz (12 cores) │ 1275   │ 11664 │ amd-ryzen9 │ Matisse   │ 24420   │\n│ AMD Ryzen 9 3900   │ 3.1 GHz (12 cores) │ 1222   │ 10768 │ amd        │ Matisse   │ 1078    │\n│ AMD Ryzen 9 4900H  │ 3.3 GHz (8 cores)  │ 1144   │ 6854  │ amd        │ Renoir    │ 1316    │\n│ AMD Ryzen 9 4900HS │ 3.0 GHz (8 cores)  │ 1079   │ 6862  │ amd-ryzen9 │ Renoir    │ 4532    │\n└────────────────────┴────────────────────┴────────┴───────┴────────────┴───────────┴─────────┘\n```\n\n- All options\n\n```shell\n$ gbr -h\nUsage: gbr [OPTIONS] [NAMES]...\n\nOptions:\n  -mc, --min-cores INTEGER        Minimum number of cores\n  -xc, --max-cores INTEGER        Maximum number of cores\n  -mf, --min-frequency FLOAT      Minimum frequency in GHz\n  -xf, --max-frequency FLOAT      Maximum frequency in GHz\n  -ms, --min-single FLOAT         Minimum single core score\n  -xs, --max-single FLOAT         Maximum single core score\n  -mm, --min-multi FLOAT          Minimum multi core score\n  -xm, --max-multi FLOAT          Maximum multi core score\n  -i, --icon TUPLE                Icon to search for\n  -f, --family TUPLE              Family to search for\n  -s, --sort [name|single|multi|frequency|cores|id]\n                                  Sort by (reverse is default except for name,\n                                  id)\n  -r, --reverse                  Reverse the sort order\n  -v, --verbose                   Verbose output\n  -h, --help                      Show this message and exit.\n```\n\n## Installation\n\nInstall this via pip (or your favourite package manager):\n\n`pip install geekbench-browser-python`\n\n## Contributors ✨\n\nThanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- prettier-ignore-start -->\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<table>\n  <tbody>\n    <tr>\n      <td align="center" valign="top" width="14.28%"><a href="https://github.com/34j"><img src="https://avatars.githubusercontent.com/u/55338215?v=4?s=80" width="80px;" alt="34j"/><br /><sub><b>34j</b></sub></a><br /><a href="https://github.com/34j/geekbench-browser-python/commits?author=34j" title="Code">💻</a></td>\n    </tr>\n  </tbody>\n</table>\n\n<!-- markdownlint-restore -->\n<!-- prettier-ignore-end -->\n\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n<!-- prettier-ignore-end -->\n\nThis project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!\n\n## Credits\n\nThis package was created with\n[Copier](https://copier.readthedocs.io/) and the\n[browniebroke/pypackage-template](https://github.com/browniebroke/pypackage-template)\nproject template.\n',
    'author': '34j',
    'author_email': '34j.95a2p@simplelogin.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/34j/geekbench-browser-python',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
