# Genal Code Review Report

This report provides a thorough theoretical, methodological, and mathematical analysis of the `genal` codebase, following the guidelines provided in `CODE_REVIEW_GUIDE.md`.

---

## **Finding 1: Allele harmonization logic for palindromic SNPs is flawed**

**Severity:** Critical

**Concern:** The `apply_action_2` function in `MR.py`, which is responsible for harmonizing palindromic SNPs using allele frequencies, contains flawed logic. The decision to flip an allele is based almost exclusively on the exposure allele frequency (`EAF_e`), without correctly considering the outcome allele frequency (`EAF_o`) or the relationship between the two. Specifically, it may incorrectly flip SNPs whose alleles are already concordant, simply because the exposure allele frequency is high. This can lead to incorrectly aligned effect alleles between the exposure and outcome, causing a sign error in the effect estimate (`BETA_e`). Such an error will severely bias the resulting Mendelian Randomization estimates, potentially reversing the direction of the causal effect or introducing spurious null results.

**Recommendation:** The harmonization logic for palindromic SNPs should be rewritten to follow established best practices, such as those implemented in the `TwoSampleMR` R package. The corrected logic must properly compare `EAF_e` and `EAF_o` to infer strand orientation. For example, when alleles match, a flip should only be considered if frequencies are complementary (e.g., `EAF_e` > 0.5 and `EAF_o` < 0.5, or vice-versa, within a defined tolerance).

**Evidence/Rationale:** The faulty logic is in the `apply_action_2` function in `genal/MR.py`. A correct implementation would compare both `EAF_e` and `EAF_o` to determine if they are on opposite strands. The current implementation's reliance on `EAF_e` alone is methodologically incorrect for inferring strand flips for palindromic SNPs.

---

## **Finding 2: The MR-PRESSO distortion test implementation is incorrect**

**Severity:** High

**Concern:** The implementation of the MR-PRESSO distortion test in `MRpresso.py` appears to deviate from the methodology described in the original publication (Verbanck et al., *Nature Genetics*, 2018). The purpose of the distortion test is to assess whether the causal estimate changes significantly after removing outlier SNPs. This is tested by comparing the observed change to a null distribution of changes generated by removing the same number of *random* SNPs. The current implementation generates a null distribution by removing subsets of *non-outlier* SNPs, as indicated by a comment in the code from the original author expressing uncertainty (`## Is there an error in the MRPRESSO code?...`). This approach does not correctly simulate the null hypothesis and will likely produce an inaccurate p-value for the distortion test, leading to incorrect conclusions about the impact of pleiotropy.

**Recommendation:** The logic for the distortion test's permutation procedure should be corrected to follow the original MR-PRESSO method. The null distribution should be generated by repeatedly removing a random set of SNPs (equal in number to the identified outliers) from the full dataset and calculating the resulting change in the causal estimate.

**Evidence/Rationale:** The implementation in `genal/MRpresso.py` (around line 130 and in the `get_random_bias` function) and the associated comment from the developer strongly suggest the implementation is not faithful to the published MR-PRESSO methodology for the distortion test.

---

## **Finding 3: The default LD clumping window size is excessively large**

**Severity:** High

**Concern:** The `clump` method in the `Geno` class uses a default clumping window of 10,000 kb (`kb=10000`). This is substantially larger than the commonly recommended window sizes of 250 kb to 1000 kb. Using such a large window risks incorrectly grouping SNPs that are not in linkage disequilibrium, especially across regions with moderate to high recombination rates. This can lead to the erroneous removal of genuinely independent genetic variants, reducing the resolution of the analysis and potentially biasing downstream results for Polygenic Risk Scores and Mendelian Randomization by discarding valid instruments.

**Recommendation:** The default value for the `kb` parameter should be reduced to a more conventional and evidence-based value, such as 250 kb or 500 kb. The docstring should be updated to explain the choice and guide the user on selecting an appropriate window size based on their specific analysis and population.

**Evidence/Rationale:** The `Geno.py` file, line 356, defines `def clump(self, kb=10000, ...)`. Peer-reviewed literature and best-practice guides (e.g., Privé et al., *Am J Hum Genet*, 2019; PLINK documentation) use smaller windows (e.g., 250kb-1000kb) as defaults for LD clumping. A 10,000kb window is typically only used for special cases like checking for long-range LD, not as a general-purpose default. A search of recent literature confirms this ("plink ld clumping window size best practice GWAS MR").

---

## **Finding 4: The default window size for proxy SNP searching is inefficient**

**Severity:** Medium

**Concern:** The `query_outcome` and `prs` methods, when finding proxies, default to a search window of 5,000 kb. While the `r2` threshold of 0.8 is appropriate, searching for proxies over a 5 Mb window is computationally inefficient and methodologically questionable. Linkage disequilibrium is a local phenomenon, and proxies are almost always found within a much smaller window (e.g., 50-250 kb). Searching a 5 Mb window significantly increases computation time and risks identifying spurious, long-range correlations that do not reflect true local LD structure.

**Recommendation:** Reduce the default `kb` parameter for proxy searches to a more standard and efficient value, such as 250 kb or 500 kb.

**Evidence/Rationale:** `Geno.py`, line 810: `query_outcome(..., kb=5000, r2=0.8, ...)` and line 536: `prs(..., kb=5000, r2=0.8, ...)`. Standard practice for proxy searching is to use a much smaller window as LD is not expected to extend over several megabases. This large window offers little benefit at a significant computational cost.

---

## **Finding 5: The default LD clumping r-squared threshold is unusually stringent**

**Severity:** Medium

**Concern:** The `clump` method defaults to an `r2` threshold of 0.01. While this ensures a set of highly independent SNPs, it is a very stringent cutoff compared to values commonly used in the literature (e.g., 0.1, 0.2, or 0.5 for selecting instruments). This may lead to an overly aggressive clumping procedure that retains multiple, weakly correlated signals from the same locus. For methods that assume independent instruments (like standard IVW MR), this could be problematic. Furthermore, for PRS construction, this stringent threshold might not be optimal for predictive power.

**Recommendation:** Consider changing the default `r2` to a more moderate and widely used value, such as 0.2 or 0.1. The rationale for the default should be clearly documented, and the user should be encouraged to select a threshold appropriate for their specific analysis.

**Evidence/Rationale:** `Geno.py`, line 356: `def clump(self, kb=10000, r2=0.01, ...)`. The paper "Making the Most of Clumping and Thresholding for Polygenic Scores" by Privé et al. (2019) demonstrates that the optimal `r2` varies widely by trait and that values higher than 0.01 are often optimal. Many tutorials and standard pipelines use less stringent thresholds. 