# Contributing

Contributions and suggestions are **welcome** and will be fully **credited**.

We accept contributions via Pull Requests on [GitHub](https://github.com/GeneratePDFs/python-sdk).

## Pull Requests

- **Follow PEP 8** - Use a code formatter like `black` or `autopep8` to ensure code style consistency. The easiest way to apply the conventions is to install a code formatter.
- **Add tests!** - Your patch won't be accepted if it doesn't have tests.
- **Document any change in behaviour** - Make sure the README / CHANGELOG and any other relevant documentation are kept up-to-date.
- **Consider our release cycle** - We try to follow semver. Randomly breaking public APIs is not an option.
- **Create topic branches** - Don't ask us to pull from your master branch.
- **One pull request per feature** - If you want to do more than one thing, send multiple pull requests.
- **Send coherent history** - Make sure each individual commit in your pull request is meaningful. If you had to make multiple intermediate commits while developing, please squash them before submitting.
