# GentelShield Python SDK

Welcome to the official Python SDK for the GentelShield API. This SDK provides a convenient way to integrate GentelShield's content moderation services into your Python applications.

## Installation

You can install the SDK directly from PyPI using pip:

```bash
pip install gentelshield-python-sdk
```

## Quick Start

Here's a simple example of how to configure the SDK and check a piece of text.

```python
import gentelsdkcore
import gentelsdkshd

# 1. Initialize configuration
configuration = gentelsdkcore.Configuration()
configuration.ak = "YOUR_SHIELD_API_KEY"  # Replace with your actual API Key
# If you are accessing a private deployment, you might need to set the host
# configuration.host = "your_custom_domain.com"
gentelsdkcore.Configuration.set_default(configuration)

# 2. Create an API instance
api_instance = gentelsdkshd.SHDApi()

# 3. Create a request object for non-streaming text check
check_llm_text_trunk_request = gentelsdkshd.CheckLLMTextTrunkRequest(
    content="This is the text content you want to check."
)

try:
    # 4. Call the API and get the result
    result = api_instance.check_llm_text_trunk(check_llm_text_trunk_request)
    print(result)
except Exception as e:
    print(f"An error occurred: {e}")

```

## Usage

The SDK provides three main functionalities:
- `CheckLLMTextStream`: For streaming text content moderation.
- `CheckLLMTextTrunk`: For non-streaming (batch) text content moderation.
- `CheckLLMPhoto`: For image content moderation.

Please refer to the official documentation for more detailed examples and API references. 