# 🐍 Geo-Engine Python SDK

Cliente oficial en **Python** para interactuar con la plataforma **Geo-Engine**.
Permite enviar ubicaciones en tiempo real, gestionar geocercas y consumir la API de Geo-Engine desde aplicaciones **Django**, **Flask**, scripts o entornos de **Data Science**.

Diseñado para ser **simple**, **rápido** y **fácil de integrar**.

---

## 🚀 Instalación

Instala el SDK usando `pip`:

```bash
pip install geo-engine-python
```

---

## ⚡ Uso Rápido

Envía la ubicación de un dispositivo en pocos pasos:

```python
from geo_engine import GeoEngine

# 1. Inicializar el cliente
# Por defecto se conecta al entorno de producción
client = GeoEngine(api_key="sk_live_123456")

# 2. Enviar ubicación
try:
    res = client.send_location(
        device_id="camion-01",
        lat=19.4326,
        lng=-99.1332
    )
    print(f"✅ Enviado: {res}")
except Exception as e:
    print(f"❌ Error: {e}")
```

---

## 🔧 Configuración Avanzada

Puedes personalizar la configuración para conectarte a otros entornos (por ejemplo, local o staging) o modificar URLs internas:

```python
client = GeoEngine(
    api_key="sk_test_...",
    ingest_url="http://localhost:8080",
    management_url="http://localhost:8081"
)
```

---

## 🧩 Casos de Uso Comunes

* 📍 **Tracking en tiempo real** de vehículos o dispositivos IoT
* 🚚 **Logística y última milla**
* 🗺️ **Geocercas** y eventos por entrada/salida
* 📊 **Análisis de datos geoespaciales** en notebooks o pipelines

---

## 🔐 Autenticación

El SDK utiliza **API Keys** para autenticarse.
Asegúrate de mantenerlas seguras y **no exponerlas en el frontend**.

```python
GeoEngine(api_key="sk_live_...")
```

---

## 🧪 Compatibilidad

* Python **3.8+**
* Funciona con:

  * Django
  * Flask
  * FastAPI
  * Scripts CLI
  * Jupyter / Data Science

---

## 📄 Licencia

MIT © Geo-Engine

---

## 🤝 Soporte

¿Tienes dudas o sugerencias?
Abre un issue o contáctanos en **[support@geoengine.dev](mailto:support@geoengine.dev)**

---
