from setuptools import setup, find_packages
import os

setup(
    name="geo-engine-python",
    version="1.0.0",
    description="Official Python Client for the Geo-Engine Platform",
    author="AlexG695",
    author_email="alexg@geoengine.dev",
    url="https://github.com/AlexG695/geo-engine-python",
    license="MIT",
    packages=find_packages(),
    install_requires=[
        "requests>=2.25.0",
    ],
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Scientific/Engineering :: GIS",
    ],
    python_requires=">=3.7",
    keywords="geofencing, maps, location, sdk, geojson",
)