# Code of conduct


## Our pledge

To promote an open and inclusive environment, we, as contributors and maintainers
pledge to ensure participation in the `gfw-api-python-client` and
community is free from harassment for everyone, regardless of age, body
size, visible or invisible disability, ethnicity, sex characteristics, gender
identity and expression, level of experience, education, socio-economic status,
nationality, personal appearance, race, caste, color, religion, or sexual
identity and orientation. We pledge to act and interact in ways that contribute to a welcoming,
diverse, inclusive, and healthy community.


## Our standards

Examples of behavior that contributes to a positive environment for the
community include:

* Demonstrating empathy and kindness toward other people.
* Being respectful of differing opinions, viewpoints, and experiences.
* Giving and gracefully accepting constructive feedback.
* Accepting responsibility and apologizing to those affected by our mistakes and learning from the experience.
* Focusing on what is best not just for us as individuals, but for the overall community.

Examples of unacceptable behavior include:

* The use of sexualized language or imagery and sexual attention or advances of any kind.
* Trolling, insulting or derogatory comments, and personal or political attacks.
* Public or private harassment.
* Publishing others' private information, such as a physical or email address, without their explicit permission.
* Other conduct that could reasonably be considered inappropriate in a professional setting.


## Enforcement responsibilities

The `gfw-api-python-client` maintainers are responsible for clarifying and enforcing our standards of
acceptable behavior and will take appropriate and fair corrective action in
response to any behavior that they deem inappropriate, threatening, offensive,
or harmful.

The maintainers have the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, and will communicate reasons for moderation
decisions when appropriate.


## Scope

This Code of Conduct applies within all `gfw-api-python-client` community spaces and also applies when
an individual is officially representing the community in public spaces.
Examples of representing the `gfw-api-python-client` community include using an official `gfw-api-python-client`
communication channel, such as the GitHub community discussions, posting via an
official social media account, or acting as an appointed representative at an online
or offline event.


## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported to the `gfw-api-python-client` package maintainers either publicly by
[opening an issue](https://github.com/GlobalFishingWatch/gfw-api-python-client/issues) in the `gfw-api-python-client`
repository or privately by e-mail to any maintainer (emails in the [pyproject.toml](https://github.com/GlobalFishingWatch/gfw-api-python-client/blob/develop/pyproject.toml) file
of the package), e.g., reporting unacceptable behavior of another maintainer).
All complaints will be reviewed and investigated promptly and fairly.

All maintainers are obligated to respect the privacy and security of the
reporter of any incident.


## Enforcement guidelines

The maintainers will follow these Community Impact Guidelines in determining
the consequences for any action they deem in violation of this Code of Conduct:

**1. Correction**

_Community impact:_ Use of inappropriate language or other behavior deemed
unprofessional or unwelcome in the community.

_Consequence:_ A private, written warning from the maintainers, providing
clarity around the nature of the violation and an explanation of why the
behavior was inappropriate. A public apology may be requested.

**2. Warning**

_Community impact:_ A violation through a single incident or series of actions.

_Consequence:_ A warning with consequences for continued behavior. No
interaction with the people involved, including unsolicited interaction with
those enforcing the Code of Conduct, for a specified period of time. This
includes avoiding interactions in community spaces as well as external channels
like social media. Violating these terms may lead to a temporary or permanent
ban.


**3. Temporary ban**

_Community impact:_ A serious violation of community standards, including
sustained inappropriate behavior.

_Consequence:_ A temporary ban from any sort of interaction or public
communication with the community for a specified period of time. No public or
private interaction with the people involved, including unsolicited interaction
with those enforcing the Code of Conduct, is allowed during this period.
Violating these terms may lead to a permanent ban.

**4. Permanent ban**

_Community impact:_ Demonstrating a pattern of violation of community standards,
including sustained inappropriate behavior, harassment of an individual, or
aggression toward or disparagement of classes of individuals.

_Consequence:_ A permanent ban from any sort of public interaction within the
`gfw-api-python-client` community.


### Attribution

This Code of Conduct is adapted from the Contributor Covenant, version 2.1,
available at <https://www.contributor-covenant.org/version/2/1/code_of_conduct.html>.
