# CHANGELOG

## [2.0.1] - 2025-01-28

### 🐛 Bug Fixes

#### Critical Packaging Fix
- **🔧 Fixed missing `token_manager.py` in package**: The security module's `token_manager.py` was inadvertently excluded from the built wheel due to an overly broad `.gitignore` pattern (`**/token*`)
- **📦 Package integrity restored**: Updated `.gitignore` to use more specific pattern (`**/token_*`) that only excludes temporary token files
- **🛡️ Security functionality preserved**: Interactive authentication and token management features now work correctly in distributed package
- **✅ Validation completed**: Rebuilt package and confirmed all security components are properly included

#### Test & Code Quality Improvements
- **🧪 Enhanced test utilities**: Improved formatting and robustness of test helper functions
- **✅ Full test suite validation**: All 101 tests pass successfully after packaging fix
- **🔍 Health check verified**: CLI health check confirms all components including security module are operational

### Technical Details
- **Root Cause**: Overly broad `.gitignore` pattern excluded legitimate source files
- **Solution**: More precise ignore patterns to prevent similar issues
- **Impact**: Ensures complete v2.0.0 feature set is fully functional for all users

### Upgrade Notes
- **No configuration changes required**: Existing v2.0.0 setups remain valid
- **Simple upgrade path**: Standard package update restores full functionality
- **Recommended for all v2.0.0 users**: Critical fix for security features

## [2.0.0] - 2025-07-01

### 🚀 **COMPLETE ARCHITECTURE REWRITE**

This is a **major rewrite** of git-batch-pull with a modern, modular architecture and significantly enhanced functionality.

### Added
- **🔧 Modern Modular Architecture**: Complete refactor with service layers, dependency injection, and clean separation of concerns
- **🔐 Interactive HTTPS Authentication**: New `--interactive-auth` flag for secure credential prompting with memory-only caching
- **🖥️ Enhanced CLI Interface**: Intuitive command structure with aliases (`sync`, `clone`, `pull`, `batch`)
- **🔄 Protocol Switching**: Seamless switching between SSH and HTTPS with user prompts and automatic URL updates
- **🏥 Health Check System**: Comprehensive dependency and configuration validation
- **📦 Repository Management**: Advanced filtering (archived, forks, specific repos) and batch operations
- **⚡ Performance Optimizations**: Parallel processing with configurable workers and efficient caching
- **🛡️ Security Enhancements**: Input sanitization, path validation, safe subprocess execution, keyring support
- **🧪 Comprehensive Testing**: 100+ test cases covering unit, integration, and end-to-end scenarios
- **📚 Complete Documentation Suite**:
  - Interactive Auth Guide with examples and troubleshooting (`docs/INTERACTIVE_AUTH_GUIDE.md`)
  - SSH Setup and Usage Guide (`docs/SSH_GUIDE.md`)
  - Architecture documentation (`docs/ARCHITECTURE.md`)
  - API Reference documentation (`docs/API.md`)
  - Security best practices guide (`docs/SECURITY.md`)
  - Command reference (`docs/COMMAND_REFERENCE.md`)
  - Installation guide (`docs/INSTALLATION.md`)
- **🏗️ Development & Operations**:
  - GitHub Actions CI/CD pipeline with automated testing
  - Docker support with multi-stage builds
  - Dependabot configuration for dependency updates
  - Pre-commit hooks with code quality checks
  - Performance benchmarking suite
  - Release automation with version bumping
- **📦 Enhanced Installation Methods**: pipx support for clean system-wide installation
- **🔧 Plugin System Foundation**: Extensible architecture for future plugin development
- **🧾 Configuration Templates**: `.env.template` and `config.toml.example` for easy setup
- **🛠️ Development Tools**: Advanced build tools with `Makefile`, `bumpver.toml`, and automation scripts
- **📊 Performance Benchmarking**: Dedicated benchmarking suite for monitoring performance regression
- **🔄 Release Automation**: Automated release workflows with GitHub Actions and release drafting

### Security
- **🔐 Secure Credential Management**: Interactive authentication with memory-only credential caching
- **🧹 Credential Cleanup**: Automatic clearing of cached credentials after operations complete
- **🔑 Enhanced Token Security**: Hidden input for tokens and secure URL authentication embedding
- **🛡️ Security Tooling**: Safety checks for dependency vulnerabilities, bandit security linting
- **🚫 Path Traversal Protection**: Comprehensive path validation and sanitization
- **⚡ Safe Subprocess Execution**: Secure command execution with timeout and error handling
- **🔐 Keyring Integration**: Secure OS-level credential storage with automatic encryption
- **🧼 Token Sanitization**: Automatic removal of sensitive data from logs and error messages

### Breaking Changes
- **🔄 Complete CLI redesign** - old commands deprecated
- **📋 New command structure**: `git-batch-pull {sync|clone|pull|batch} {user|org} <name>`
- **⚙️ Configuration file format updated** - see `config.toml.example`
- **🐍 Python 3.9+ required** - dropped support for older versions
- **📦 Package structure reorganized** - imports may need updating

### Technical
- **🏗️ Modular Architecture**: Service layers with dependency injection container
- **📝 Type Hints**: Complete type annotation throughout codebase
- **🔧 Comprehensive Error Handling**: Structured exception hierarchy and error recovery
- **🔍 Protocol Detection**: Automatic SSH/HTTPS protocol detection and switching
- **📦 Repository Batch Processing**: Efficient handling of multiple repositories
- **🔌 Plugin System Foundation**: Extensible architecture for future enhancements
- **⚡ Performance Improvements**: Optimized Git operations and API calls
- **🧪 Test Coverage**: Extensive test suite with mocking and integration tests
- **🧪 Cross-Platform Testing**: Comprehensive testing across Windows, macOS, and Linux environments
- **🛡️ Security Testing**: Dedicated security test scenarios and vulnerability assessments
- **📊 Memory Management**: Efficient resource usage with proper cleanup and garbage collection
- **🔧 Configuration Management**: Robust configuration system with validation and multiple sources

### Documentation
- **📖 Professional Documentation Site**: MkDocs integration with search and navigation
- **🔗 Link Strategy Optimization**: Consistent use of relative links for internal references
- **📚 Comprehensive Guides**: Step-by-step guides for all major features
- **🔄 Cross-referencing**: Improved navigation and link consistency across docs
- **🚀 Enhanced Quick Start**: Interactive authentication examples and improved onboarding
- **🏗️ Technical Architecture Guides**: Deep-dive documentation for enterprise users and developers
- **📋 Migration Documentation**: Comprehensive upgrade guide from v1.x to v2.0

### Migration Guide
- **📋 Command Structure**: Update scripts to use new command format: `git-batch-pull {sync|clone|pull|batch} {user|org} <name>`
- **⚙️ Configuration Files**: Migrate to new TOML format - see `config.toml.example` for reference
- **🐍 Python Version**: Ensure Python 3.9+ is installed (older versions no longer supported)
- **📦 Installation**: Consider using `pipx` for isolated system-wide installation
- **🔧 Import Statements**: Update any direct imports to use new package structure
- **🔑 Authentication**: Review new interactive authentication options and keyring support
- **🔒 Security**: Update security configurations to leverage new safety features

### Removed
- **📦 Legacy Dependencies**: Removed outdated or insecure dependency versions
- **🗂️ Duplicate Modules**: Eliminated redundant code structure from v1.x
- **🔧 Deprecated CLI Options**: Removed legacy command-line arguments (see migration guide)
- **🐍 Python 3.8 Support**: Dropped support for Python versions below 3.9
- **📁 Development Artifacts**: Cleaned up temporary files and development-only utilities

## [1.0.0] - 2025-06-30

### Added
- Initial stable release of the legacy architecture
- Basic repository cloning and pulling functionality
- Support for GitHub users and organizations
- Simple CLI interface
- Configuration via environment variables

### Features
- Clone all repositories for a GitHub user or organization
- Pull latest changes for existing repositories
- Basic error handling and logging
- SSH and HTTPS protocol support

## [0.x.x] - Previous Versions
- Legacy implementation (deprecated)
