# GitCode CLI

基于OpenMind SDK的GitCode平台模型文件上传下载CLI工具

## 简介

GitCode CLI 是一个命令行工具，用于与GitCode平台交互，支持模型和数据集的上传、下载等操作。工具基于OpenMind Hub SDK开发，并配置为连接GitCode API端点。

## 功能特性

- 🔐 用户认证和登录管理
- 🔗 **Git集成**：自动配置Git凭证，支持标准Git命令
- 📁 支持模型和数据集仓库创建
- ⬆️ 文件和目录批量上传
- ⬇️ 仓库内容下载
- 🎨 彩色终端输出
- 📊 上传下载进度显示
- 🔧 配置文件管理

## 系统要求

- **Python 3.8+** (推荐Python 3.11+)
- 支持的操作系统：Windows, macOS, Linux

## 安装

### 从源码安装

```bash
git clone https://gitcode.com/gitcode-ai/gitcode_cli.git
cd gitcode_cli
pip install -e .
```

### 使用pip安装（如果已发布）

```bash
pip install gitcode
```

### 虚拟环境推荐

```bash
# 创建虚拟环境
python -m venv venv

# 激活虚拟环境
source venv/bin/activate  # Linux/macOS
# 或
venv\Scripts\activate     # Windows

# 安装依赖
pip install -r requirements.txt
```

## 使用方法

### 1. 登录

首先需要登录到GitCode平台：

```bash
gitcode login
```

系统会提示输入访问令牌（从GitCode平台获取）。

**🎉 Git集成功能**：登录成功后，工具会自动配置Git凭证助手，这样你就可以直接使用标准的Git命令来操作GitCode仓库，无需再次输入token。凭证助手会自动从GitCode API获取你的真实用户名用于Git认证：

```bash
# 登录后，这些Git命令将自动使用保存的token
# 支持两种域名格式
git clone https://gitcode.com/username/repo-name.git
git clone https://hub.gitcode.com/username/repo-name.git
git push origin main
git pull origin main
```




### 2. 上传文件

#### 上传模型

```bash
gitcode upload ./your-model-dir --repo-id your-username/your-model-name
```

#### 上传数据集

```bash
gitcode upload ./your-dataset-dir --repo-id your-username/your-dataset-name
```

#### 上传单个文件

```bash
gitcode upload ./model.bin --repo-id your-username/your-model-name
```

### 3. 下载文件

#### 下载到当前目录

```bash
gitcode download your-username/your-model-name
```

#### 下载到指定目录

```bash
gitcode download your-username/your-model-name -d ./models/
```

### 4. 其他命令

#### 退出登录

```bash
gitcode logout
```

#### 显示配置信息

```bash
gitcode config-show
```



## 配置文件

配置文件保存在 `~/.gitcode/config.json`，包含用户认证信息和其他设置。

## API端点配置

工具已预配置为连接GitCode平台API端点：
- **API端点**：`https://hub.gitcode.com`
- **环境变量**：`OPENMIND_HUB_ENDPOINT=https://hub.gitcode.com`

此配置在程序启动时自动设置，用户无需手动配置。

## Git集成功能详解

### 自动配置

当你使用 `gitcode login` 登录成功后，工具会自动配置Git凭证，让你可以直接使用标准Git命令操作GitCode仓库。

### 支持的Git操作

登录后，你可以直接使用以下Git命令，无需手动输入token：

```bash
# 克隆仓库（支持两种域名格式）
git clone https://gitcode.com/username/repo-name.git
git clone https://hub.gitcode.com/username/repo-name.git

# 推送代码
git push origin main

# 拉取更新
git pull origin main

# 添加远程仓库
git remote add origin https://gitcode.com/username/repo-name.git
```

### 安全性

- 凭证配置仅对 `gitcode.com` 和 `hub.gitcode.com` 域名生效
- token 安全存储在本地配置文件中
- 不影响其他Git仓库的认证配置
- `gitcode logout` 时自动清除凭证配置

### 注意事项

- 支持的URL格式：`https://gitcode.com/...` 或 `https://hub.gitcode.com/...`
- 如果Git命令仍需要输入密码，请重新登录：`gitcode logout` 然后 `gitcode login`

## 错误处理

- 如果遇到网络错误，工具会自动重试
- 上传大文件时会显示进度条
- 所有操作都有详细的错误信息提示

## 支持的文件类型

- 支持所有文件类型的上传和下载
- 自动处理目录结构
- 支持大文件传输

## 开发

### 项目结构

```
gitcode/
├── __init__.py          # 包初始化
├── __main__.py          # 主入口
├── cli.py               # CLI命令定义
├── api.py               # OpenMind API客户端
├── config.py            # 配置管理
├── utils.py             # 工具函数
├── requirements.txt     # 依赖包
├── setup.py             # 包安装配置
└── README.md           # 说明文档
```

### 本地开发

```bash
# 克隆项目
git clone https://gitcode.com/gitcode-ai/gitcode_cli.git
cd gitcode_cli

# 安装依赖
pip install -r requirements.txt

# 开发模式安装
pip install -e .

# 运行测试
python -m pytest tests/
```

## Python版本兼容性

本项目支持Python 3.8+版本，包括：

- ✅ Python 3.8
- ✅ Python 3.9  
- ✅ Python 3.10
- ✅ Python 3.11
- ✅ Python 3.12
- ✅ Python 3.13

### 兼容性测试

运行兼容性测试：

```bash
python test_compatibility.py
```

详细兼容性信息请参考 [PYTHON_COMPATIBILITY.md](PYTHON_COMPATIBILITY.md)

## 许可证

MIT License

## 贡献

欢迎提交Issue和Pull Request！

### 贡献指南

在贡献代码时，请确保：

1. 代码兼容Python 3.8+
2. 运行兼容性测试
3. 更新相关文档

## 联系我们

- 邮箱：support@gitcode.com
- 项目地址：https://gitcode.com/gitcode-ai/gitcode_cli
- 问题报告：https://gitcode.com/gitcode-ai/gitcode_cli/issues 