from typing import List, Literal

from pydantic import BaseModel, field_validator


class DiffLine(BaseModel):
    diff_type: Literal['add', 'remove', 'context']
    content: str

    @classmethod
    @field_validator('diff_type', mode='before')
    def map_type(cls, value:str) -> Literal['add', 'remove', 'context']:
        type_map = {
            '+': 'add',
            '-': 'remove',
            ' ': 'context'
        }
        return type_map[value]


class Hunk(BaseModel):
    old_start_line: int
    old_end_line: int
    new_start_line: int
    new_end_line: int
    lines: List[DiffLine]


class ParsedDiff(BaseModel):
    file: str
    hunks: List[Hunk]

class AllParsedDiffs(BaseModel):
    diffs: List[ParsedDiff]
