# diff-parse

## Description

`diff-parse` is a Python project that provides a utility to parse git diff strings into a structured JSON format. This
can be useful for analyzing changes in code, generating reports, or integrating with other tools that require diff
information.

## Installation

To install the dependencies for this project, you can use the following command:

```sh
pip install -r requirements.txt
```

## Usage

You can use the `diff-parse` script to parse a git diff string. The script is defined in the `pyproject.toml` file and
can be executed as follows:

```sh
diff-parse "your_git_diff_string_here"
```

Alternatively, you can run the script directly using Python:

```sh
python src/gitdiffparser/cli.py "your_git_diff_string_here"
```

## Example

Here is an example of how to use the `diff-parse` script:

```sh
diff-parse "diff --git a/file.txt b/file.txt\nindex 83db48f..f735c2d 100644\n--- a/file.txt\n+++ b/file.txt\n@@ -1,3 +1,3 @@\n-Hello World\n+Hello Python\n This is a test file."
```

## Project Structure

- `src/diff_parse/cli.py`: Entry point for the command-line interface.
- `src/diff_parse/app.py`: Contains the main logic for parsing git diff strings.
- `pyproject.toml`: Project configuration file.

## Dependencies

- `fire>=0.7.0`
- `pydantic>=2.10.6`

## License

This project is licensed under the MIT License.

```