# GitFlow Analytics Documentation

Welcome to the complete documentation for GitFlow Analytics - a powerful tool for analyzing Git repositories to generate comprehensive developer productivity insights.

## 🚀 Quick Navigation

### 👋 New to GitFlow Analytics?
Start here to get up and running quickly:
- **[Installation Guide](getting-started/installation.md)** - Set up GitFlow Analytics
- **[Quick Start Tutorial](getting-started/quickstart.md)** - 5-minute walkthrough
- **[Your First Analysis](getting-started/first-analysis.md)** - Analyze your first repository

### 📖 User Guides
Comprehensive guides for common tasks:
- **[Configuration Guide](guides/configuration.md)** - Complete YAML configuration reference
- **[ML Categorization](guides/ml-categorization.md)** - Machine learning features setup
- **[Organization Setup](guides/organization-setup.md)** - Multi-repository analysis
- **[Report Customization](guides/report-customization.md)** - Customize output formats
- **[Troubleshooting](guides/troubleshooting.md)** - Common issues and solutions

### 💡 Examples & Use Cases
Real-world scenarios and templates:
- **[Basic Analysis](examples/basic-analysis.md)** - Single repository analysis
- **[Enterprise Setup](examples/enterprise-setup.md)** - Large organization configuration
- **[CI Integration](examples/ci-integration.md)** - Automated analysis workflows
- **[Custom Workflows](examples/custom-workflows.md)** - Advanced usage patterns

### 📚 Reference Documentation
Technical specifications and API details:
- **[CLI Commands](reference/cli-commands.md)** - Complete command-line reference
- **[Configuration Schema](reference/configuration-schema.md)** - YAML structure specification
- **[JSON Export Format](reference/json-export-schema.md)** - Data export documentation
- **[Caching System](reference/cache-system.md)** - Performance and caching details

### 🛠️ Developer Resources
For contributors and developers:
- **[Contributing Guide](developer/contributing.md)** - How to contribute to the project
- **[Development Setup](developer/development-setup.md)** - Local development environment
- **[Testing Guide](developer/testing-guide.md)** - Testing procedures and standards
- **[Coding Standards](developer/coding-standards.md)** - Code quality guidelines

### 🏗️ Architecture & Design
System design and technical decisions:
- **[System Overview](architecture/system-overview.md)** - High-level architecture
- **[Data Flow](architecture/data-flow.md)** - Processing pipeline design
- **[ML Pipeline](architecture/ml-pipeline.md)** - Machine learning architecture
- **[Design Documents](design/)** - Detailed design decisions

### 🚀 Deployment & Operations
Production deployment and scaling:
- **[Production Installation](deployment/installation.md)** - Deploy in production
- **[Monitoring & Metrics](deployment/monitoring.md)** - Performance monitoring
- **[Security Guide](deployment/security.md)** - Security best practices
- **[Scaling Guide](deployment/scaling.md)** - Large organization deployment

## 🎯 Documentation by Use Case

### I want to...

**Analyze a single repository**
→ [Installation](getting-started/installation.md) → [Quick Start](getting-started/quickstart.md) → [Basic Analysis](examples/basic-analysis.md)

**Set up organization-wide analysis**
→ [Configuration Guide](guides/configuration.md) → [Organization Setup](guides/organization-setup.md) → [Enterprise Example](examples/enterprise-setup.md)

**Integrate with CI/CD pipelines**
→ [CLI Reference](reference/cli-commands.md) → [CI Integration Examples](examples/ci-integration.md)

**Contribute to the project**
→ [Contributing Guide](developer/contributing.md) → [Development Setup](developer/development-setup.md)

**Understand the architecture**
→ [System Overview](architecture/system-overview.md) → [Design Documents](design/)

**Deploy in production**
→ [Production Installation](deployment/installation.md) → [Security Guide](deployment/security.md)

## 🔍 Search Tips

- Use your browser's search (Ctrl/Cmd+F) to find specific topics
- Check the [Configuration Schema](reference/configuration-schema.md) for YAML options
- Review [Troubleshooting](guides/troubleshooting.md) for common issues
- Browse [Examples](examples/) for similar use cases

## 📝 Documentation Standards

This documentation follows our [Documentation Structure](STRUCTURE.md) guidelines:
- **Progressive disclosure** - Start simple, dive deeper as needed
- **Task-oriented** - Organized around what you want to accomplish
- **Tested examples** - All code samples are validated and working
- **Cross-referenced** - Related topics are linked together

## 🤝 Help & Community

- **Issues & Bugs**: [GitHub Issues](https://github.com/bobmatnyc/gitflow-analytics/issues)
- **Feature Requests**: [GitHub Discussions](https://github.com/bobmatnyc/gitflow-analytics/discussions)
- **Contributing**: See our [Contributing Guide](developer/contributing.md)

## 📊 What GitFlow Analytics Does

GitFlow Analytics extracts insights from Git repositories including:
- **Developer productivity metrics** with identity resolution
- **ML-powered commit categorization** (85-95% accuracy)
- **Project activity analysis** across multiple repositories
- **DORA metrics** and development velocity tracking
- **Beautiful reporting** in CSV, JSON, and Markdown formats

All without requiring external project management tools like JIRA or Linear.

---

**Need help?** Start with the [Quick Start Tutorial](getting-started/quickstart.md) or check [Troubleshooting](guides/troubleshooting.md).

**Contributing?** See the [Contributing Guide](developer/contributing.md) and [Development Setup](developer/development-setup.md).

**Last Updated**: January 2025