# Contributing

🌟 Contributions are welcome and will be fully credited! 🌟

## Workflow

To contribute to this project, please note the following steps:

- Fork the repository on GitHub.
- Clone the forked repository to your machine.
- Make the necessary changes in your branch.
- Push your changes to your forked repository.
- Submit a pull request with a description of the changes.

More information can be found in the [GitHub documentation](https://docs.github.com/en/get-started/quickstart/contributing-to-projects).

## Guidelines

- Please ensure to respect the existing style in the codebase and to include tests that cover your changes.

- Document any change in behaviour. Make sure the `README.md` and any other relevant documentation are kept up-to-date.

- One pull request per feature. If you want to do more than one thing, send multiple pull requests.

- Send coherent history. Make sure each individual commit in your pull request is meaningful. If you had to make multiple intermediate commits while developing, please squash them before submitting.


Run code formatter:
```bash
black .
```

Run code style checks:
```bash
flake8 .
pylint .
```

Run tests:
```bash
pytest
```

🚀 **Happy coding**!
