

from typing import Optional
from typing_extensions import Literal

from ...._models import BaseModel
from .dependabot_alert_package import DependabotAlertPackage

__all__ = ["DependabotAlertSecurityVulnerability", "FirstPatchedVersion"]


class FirstPatchedVersion(BaseModel):
    identifier: str
    """The package version that patches this vulnerability."""


class DependabotAlertSecurityVulnerability(BaseModel):
    first_patched_version: Optional[FirstPatchedVersion] = None
    """Details pertaining to the package version that patches this vulnerability."""

    package: DependabotAlertPackage
    """Details for the vulnerable package."""

    severity: Literal["low", "medium", "high", "critical"]
    """The severity of the vulnerability."""

    vulnerable_version_range: str
    """Conditions that identify vulnerable versions of this vulnerability's package."""
