

from __future__ import annotations

from typing_extensions import Literal, TypedDict

__all__ = ["OrgListSecurityAdvisoriesParams"]


class OrgListSecurityAdvisoriesParams(TypedDict, total=False):
    after: str
    """
    A cursor, as given in the
    [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers).
    If specified, the query only searches for results after this cursor. For more
    information, see
    "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
    """

    before: str
    """
    A cursor, as given in the
    [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers).
    If specified, the query only searches for results before this cursor. For more
    information, see
    "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
    """

    direction: Literal["asc", "desc"]
    """The direction to sort the results by."""

    per_page: int
    """The number of advisories to return per page.

    For more information, see
    "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
    """

    sort: Literal["created", "updated", "published"]
    """The property to sort the results by."""

    state: Literal["triage", "draft", "published", "closed"]
    """Filter by the state of the repository advisories.

    Only advisories of this state will be returned.
    """
