

from __future__ import annotations

from typing_extensions import Required, TypedDict

__all__ = ["AutolinkCreateParams"]


class AutolinkCreateParams(TypedDict, total=False):
    owner: Required[str]

    key_prefix: Required[str]
    """
    This prefix appended by certain characters will generate a link any time it is
    found in an issue, pull request, or commit.
    """

    url_template: Required[str]
    """The URL must contain `<num>` for the reference number.

    `<num>` matches different characters depending on the value of
    `is_alphanumeric`.
    """

    is_alphanumeric: bool
    """Whether this autolink reference matches alphanumeric characters.

    If true, the `<num>` parameter of the `url_template` matches alphanumeric
    characters `A-Z` (case insensitive), `0-9`, and `-`. If false, this autolink
    reference only matches numeric characters.
    """
