

from __future__ import annotations

from typing_extensions import Literal, Required, TypedDict

__all__ = ["PackageListPackagesParams"]


class PackageListPackagesParams(TypedDict, total=False):
    package_type: Required[Literal["npm", "maven", "rubygems", "docker", "nuget", "container"]]
    """The type of supported package.

    Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed
    to GitHub's Container registry (`ghcr.io`) have the type `container`. You can
    use the type `docker` to find images that were pushed to GitHub's Docker
    registry (`docker.pkg.github.com`), even if these have now been migrated to the
    Container registry.
    """

    page: int
    """The page number of the results to fetch.

    For more information, see
    "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
    """

    per_page: int
    """The number of results per page (max 100).

    For more information, see
    "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
    """

    visibility: Literal["public", "private", "internal"]
    """The selected visibility of the packages.

    This parameter is optional and only filters an existing result set.

    The `internal` visibility is only supported for GitHub Packages registries that
    allow for granular permissions. For other ecosystems `internal` is synonymous
    with `private`. For the list of GitHub Packages registries that support granular
    permissions, see
    "[About permissions for GitHub Packages](https://docs.github.com/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
    """
