

from __future__ import annotations

from typing_extensions import Literal, Required, TypedDict

__all__ = ["VersionListParams"]


class VersionListParams(TypedDict, total=False):
    package_type: Required[Literal["npm", "maven", "rubygems", "docker", "nuget", "container"]]

    page: int
    """The page number of the results to fetch.

    For more information, see
    "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
    """

    per_page: int
    """The number of results per page (max 100).

    For more information, see
    "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
    """

    state: Literal["active", "deleted"]
    """The state of the package, either active or deleted."""
