# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['github_commit_status']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0,<9.0', 'pygithub>=1.51,<2.0', 'toml>=0.10,<0.11']

entry_points = \
{'console_scripts': ['gcs = github_commit_status.cli:cli',
                     'github_commit_status = github_commit_status.cli:cli']}

setup_kwargs = {
    'name': 'github-commit-status',
    'version': '1.2.0',
    'description': "A simple command line for updating a commit's status on GitHub",
    'long_description': '====================\ngithub_commit_status\n====================\n\nA simple command line for updating a commit\'s status in GitHub\n\nProject and Build Status\n------------------------\n\n.. image:: https://circleci.com/gh/glenjarvis/github-commit-status.svg?style=shield\n     :target: https://circle-ci.com/gh/glenjarvis/github_commit_status.svg\n     :alt: CircleCI build status\n\n.. image:: https://readthedocs.org/projects/github_commit_status/badge/?version=latest\n     :target: http://github_commit_status.readthedocs.io/en/latest/?badge=latest\n     :alt: Documentation Status\n\n\n* `GitHub repo <https://github.com/glenjarvis/github_commit_status/>`_\n* `Online Documentation <https://github-commit-status.readthedocs.io/en/latest/readme.html>`_\n* `Free Software <https://github.com/glenjarvis/github_commit_status/blob/main/LICENSE>`_\n\n\nHow to Use\n----------\n\nBackground and Purpose\n^^^^^^^^^^^^^^^^^^^^^^\n\nIn GitHub, Pull Requests can have some checks against the code in question.\nThis is a great way to check for things such as white space, coding standards,\netc. Continuous Integration tools, like Travis, use this to update the status\nof the commit that you see in Pull Requests in GitHub.\n\n.. image:: https://github.com/glenjarvis/github_commit_status/blob/main/docs/imgs/figure_1_background.png?raw=true\n     :alt: Figure 1 Pull Request Example\n\nThis is a fairly simple integration and you can also place your own checks here.\nIn the following example, I made the status pending with a yellow circle with\nthe phrase "You know you can change this, right?"\n\n.. image:: https://github.com/glenjarvis/github_commit_status/blob/main/docs/imgs/figure_2_custom_status.png?raw=true\n     :alt: Custom Status Example\n\nThis command line tool will allow you to update the status of any commit that\nyou have access to in GitHub. It was built to be a teaching tool for a course\non Source Control Management (Git) and GitHub integrations. However, it is\nstable and can be used in production seamlessly -- especially environments\nwhere it makes sense to use a command line instead of your own library.\n\n\nGather the info that you need\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nTo update the status of a commit in a Pull Request, you will need to provide\nsome basic information:\n\n1. The name of the GitHub repository which has your Pull Request\n2. The commit SHA that is to be updated (e.g., the last commit  in a pull\n   request)\n3. The desired status of the commit:\n    - "success" (GitHub displays a green checkmark)\n    - "pending" (GitHub displays a yellow circle)\n    - "error" or "failure" (GitHub displays a red \'X\')\n4. Description (e.g., "You know you can change this, right?" was the description\n   used in the example above)\n5. Authorization token. This will allow the command to act like you.\n   Instructions on how to create this token follow.\n\n\nPersonal Access Token\n^^^^^^^^^^^^^^^^^^^^^\n\nThis tool is intended to change the status of a GitHub Pull Request. That is\nsomething that should only be allowed by someone who is authorized. You\nwouldn\'t want someone that you hadn\'t authorized updating your Pull Request\nstatuses.\n\nYou will need to generate a Personal Access Token so that this command line can\nact like you. Keep this token safe -- it is like a password.\n\nThis is done in your account settings configuration. Don\'t confuse the\nproject\'s settings with your settings for your account.\n\n\nProfile Settings\n""""""""""""""""\n\nIn the upper right hand corner, you will see your avatar photo (or a default\navatar image). When you click the avatar, there will be a drop down menu with\nmenu options. Choose the **Settings** option.\n\n.. image:: https://github.com/glenjarvis/github_commit_status/blob/main/docs/imgs/figure_3_account_settings.png?raw=true\n     :alt: Upper Right Hand Corner Menu \n\n\nDeveloper Settings\n""""""""""""""""""\n\nOn the next page that is loaded, the Profile settings page, you will see another\nmenu to the left. It is a longer menu where the bottom looks similar to the\nfollowing. Choose **Developer settings**:\n\n.. image:: https://github.com/glenjarvis/github_commit_status/blob/main/docs/imgs/figure_4_developer_settings.png?raw=true\n     :alt: Developer Settings Menu\n\n\nCreate a Personal Access Token\n""""""""""""""""""""""""""""""\nOn the next page, the Developer Settings page, you will see one final menu.\nChoose **Personal access tokens**:\n\n.. image:: https://github.com/glenjarvis/github_commit_status/blob/main/docs/imgs/figure_5_personal_accesstokens.png?raw=true\n     :alt: Personal Access Token Menu\n\n\n1. Press the button to **Generate new token**.\n\n2. In the **Token description** enter "github_commit_status". This way we\n   remember the purpose of this token.\n\n3. Select the **repo:status** scope checkbox. Anyone who has this token could\n   update your GitHub account. So, keep the scope of this token so that it can\n   **only** update or access the commit status.\n\n   .. image:: https://github.com/glenjarvis/github_commit_status/blob/main/docs/imgs/figure_6_generate_personal_access_tokens.png?raw=true\n       :alt: New Token Screenshot\n\n4. Scroll to the bottom of click the green **Generate token** button.\n\n5. Your token should now be displayed. This token will only display this time.\n   You won\'t be able to see it again and it cannot be recovered.\n\n6. Keep your token safe so that you can use it with this program. Remember, if\n   someone else can access this token, they can update your GitHub statuses -\n   even if you don\'t want them to.\n\n\nExample: Prompt mode\n--------------------\n\nIf you only need to use this command line rarely, there\'s no need to worry about\ngetting the command line arguments correct - you will be prompted for any\nrequired arguments that are missing. This is ideal for students in my class who\nonly need to update a Pull Requests a few times for a homework assignment. See\nthe next section for a more scriptable mode and example.\n\n\n1. Install::\n\n     pip install github_commit_status\n\n2. Run::\n\n     github_commit_status prompt\n\n3. Enter the data that you have collected (e.g., Personal Access Token, commit\n   SHA, etc.)\n\n   Here is an example that I used for one of my projects. Remember, don\'t let\n   your Personal Access Token get published like I intentionally did here. I\n   ensured this token was deleted before I published this::\n\n     $ github_commit_status prompt\n\n     GitHub Token [26fee6a5d440111a2648312d458b6b4e44c20c1d]:\n     Name of the GitHub repository []: my_target_repo\n     Commit SHA []: 2dd5f9ce1108d69e863444ee6486e64e0299868f\n     Status: pending\n     Description: Tests have started\n\n     GitHub has been updated.\n\n\nExample: For scripting\n----------------------\n\nThis command can also be used for shell scripts that need to update GitHub.\n\nFor security reasons, this mode/subcommand does not provide an option for::\n\n    --github-token\n\nas this is preserved in most shell histories. Instead, the\nenvironment variable *GITHUB_COMMIT_STATUS_TOKEN* should already be set. For\nexample, in a bash shell::\n\n  export GITHUB_COMMIT_STATUS_TOKEN=26fee6a5d440111a2648312d458b6...\n\n\n1. Install::\n\n     pip install github_commit_status\n\n2. To see command line options that can be provided::\n\n    $ github_commit_status update --help\n    Usage: github_commit_status update [OPTIONS]\n\n      If all options are provided, update GitHub\n\n    Options:\n      --repo TEXT                     Name of the GitHub repository  [required]\n      --commit TEXT                   The 40 character SHA1 string for the commit.\n                                      [required]\n      --status [error|failure|pending|success]\n                                      The status of the commit  [required]\n      --description TEXT              Description for the test  [required]\n      --help                          Show this message and exit.\n\n3. Here is an example usage. Remember, your Personal Access Token\n   needs to be pre-set in environment variable **GITHUB_COMMIT_STATUS_TOKEN**::\n\n      $ github_commit_status update --repo=my_target_repo \\\n          --commit="2dd5f9ce1108d69e863444ee6486e64e0299868f" \\\n          --status=pending \\\n          --description="Tests are running."\n\n\nMake this better by Contributing\n--------------------------------\n\nThis is an Open Source project and contributions are always welcome, and they\nare greatly appreciated! Every little bit helps, and credit will always be\ngiven.\n\nYou can contribute in many ways:\n\n* `Report bugs <https://github.com/glenjarvis/github_commit_status/issues>`__\n* `Write Documentation <https://github_commit_status.readthedocs.io/>`__\n* `Fix bugs <https://github.com/glenjarvis/github_commit_status/issues>`__\n\nTo maximize the chance that your hard work gets merged, we have these guidelines\nto guide you along the way to a successfully merged Pull Request:\n\n* `Contributing <https://github.com/glenjarvis/github_commit_status/blob/main/CONTRIBUTING.rst>`__\n',
    'author': 'Glen Jarvis',
    'author_email': '<glen@glenjarvis.com>',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/glenjarvis/github_commit_status',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
