import os

from setuptools import setup


# Loads _version.py module without importing the whole package.
def get_version_and_cmdclass(pkg_path):
    from importlib.util import module_from_spec, spec_from_file_location

    spec = spec_from_file_location(
        "version",
        os.path.join(pkg_path, "_version.py"),
    )
    module = module_from_spec(spec)
    spec.loader.exec_module(module)
    return module.__version__, module.get_cmdclass(pkg_path)


version, cmdclass = get_version_and_cmdclass(f"src{os.sep}github_ssh_auth")

setup(
    name="github_ssh_auth",
    version=version,
    cmdclass=cmdclass,
    package_dir={"": "src"},
)
