# GitHub Utils API

![Known Vulnerabilities](https://snyk.io/test/github/pablotoledo/GithubUtilsAPI/badge.svg) [![Vulnerabilities](https://sonarcloud.io/api/project_badges/measure?project=pablotoledo_GithubUtilsAPI&metric=vulnerabilities)](https://sonarcloud.io/summary/new_code?id=pablotoledo_GithubUtilsAPI) [![Security Rating](https://sonarcloud.io/api/project_badges/measure?project=pablotoledo_GithubUtilsAPI&metric=security_rating)](https://sonarcloud.io/summary/new_code?id=pablotoledo_GithubUtilsAPI)
[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=pablotoledo_GithubUtilsAPI&metric=alert_status)](https://sonarcloud.io/summary/new_code?id=pablotoledo_GithubUtilsAPI) 
[![Reliability Rating](https://sonarcloud.io/api/project_badges/measure?project=pablotoledo_GithubUtilsAPI&metric=reliability_rating)](https://sonarcloud.io/summary/new_code?id=pablotoledo_GithubUtilsAPI) [![Maintainability Rating](https://sonarcloud.io/api/project_badges/measure?project=pablotoledo_GithubUtilsAPI&metric=sqale_rating)](https://sonarcloud.io/summary/new_code?id=pablotoledo_GithubUtilsAPI) [![Code Smells](https://sonarcloud.io/api/project_badges/measure?project=pablotoledo_GithubUtilsAPI&metric=code_smells)](https://sonarcloud.io/summary/new_code?id=pablotoledo_GithubUtilsAPI) [![Lines of Code](https://sonarcloud.io/api/project_badges/measure?project=pablotoledo_GithubUtilsAPI&metric=ncloc)](https://sonarcloud.io/summary/new_code?id=pablotoledo_GithubUtilsAPI) [![Technical Debt](https://sonarcloud.io/api/project_badges/measure?project=pablotoledo_GithubUtilsAPI&metric=sqale_index)](https://sonarcloud.io/summary/new_code?id=pablotoledo_GithubUtilsAPI) [![Duplicated Lines (%)](https://sonarcloud.io/api/project_badges/measure?project=pablotoledo_GithubUtilsAPI&metric=duplicated_lines_density)](https://sonarcloud.io/summary/new_code?id=pablotoledo_GithubUtilsAPI) 




## What is it?
This package is used to provide a **simple** python interface for interacting with GitHub.
It is based on the official public Rest API documentation and private methods discovered by the community.

This project is documented at [https://githubutilsapi.readthedocs.io/](https://githubutilsapi.readthedocs.io/)

## How to Install?

### From PyPI
```console
$ pip install github-utils-api
```

### From Source
- Git clone repository
- Use `pip install -r requirements.txt` to install the required packages
- or `pipenv install && pipenv install --dev`

## How to use?
Import this python package and code.
```python
from githubutilsapi import GithubUtilsApi
```

## How to contribute?
First of all, I am happy for any PR requests.
Let's fork and provide your changes :)
1. Fork this project
2. Install required software Python3
3. Make your changes
4. Remember to generate documented methods
5. Test your changes and create the pull request

## License
This project is licensed under the terms of the MIT license.

For a copy, see [https://opensource.org/licenses/MIT](https://opensource.org/licenses/MIT).
