# Derived from the Silkscreen font
# http://kottke.org/plus/type/silkscreen/
# Silkscreen is distributed under the Open Font License
# http://scripts.sil.org/OFL

font = {
    "a": [
        "    ",
        " aa ",
        "a  a",
        "aaaa",
        "a  a",
        "a  a",
        "    ",
    ],
    "b": [
        "    ",
        "bbb ",
        "b  b",
        "bbbb",
        "b  b",
        "bbb ",
        "    ",
    ],
    "c": [
        "    ",
        " cc ",
        "c  c",
        "c   ",
        "c  c",
        " cc ",
        "    ",
    ],
    "d": [
        "    ",
        "ddd ",
        "d  d",
        "d  d",
        "d  d",
        "ddd ",
        "    ",
    ],
    "e": [
        "   ",
        "eee",
        "e  ",
        "eee",
        "e  ",
        "eee",
        "   ",
    ],
    "f": [
        "   ",
        "fff",
        "f  ",
        "fff",
        "f  ",
        "f  ",
        "   ",
    ],
    "g": [
        "    ",
        " ggg",
        "g   ",
        "g gg",
        "g  g",
        " gg ",
        "    ",
    ],
    "h": [
        "    ",
        "h  h",
        "h  h",
        "hhhh",
        "h  h",
        "h  h",
        "    ",
    ],
    "i": [
        " ",
        "i",
        "i",
        "i",
        "i",
        "i",
        " ",
    ],
    "j": [
        "    ",
        "   j",
        "   j",
        "   j",
        "j  j",
        " jj ",
        "    ",
    ],
    "k": [
        "    ",
        "k  k",
        "k k ",
        "kk  ",
        "k k ",
        "k  k",
        "    ",
    ],
    "l": [
        "   ",
        "l  ",
        "l  ",
        "l  ",
        "l  ",
        "lll",
        "   ",
    ],
    "m": [
        "     ",
        "m   m",
        "mm mm",
        "m m m",
        "m   m",
        "m   m",
        "     ",
    ],
    "n": [
        "     ",
        "n   n",
        "nn  n",
        "n n n",
        "n  nn",
        "n   n",
        "     ",
    ],
    "o": [
        "    ",
        " oo ",
        "o  o",
        "o  o",
        "o  o",
        " oo ",
        "    ",
    ],
    "p": [
        "    ",
        "ppp ",
        "p  p",
        "ppp ",
        "p   ",
        "p   ",
        "    ",
    ],
    "q": [
        "    ",
        " qq ",
        "q  q",
        "q  q",
        "q  q",
        " qq ",
        "   q",
    ],
    "r": [
        "    ",
        "rrr ",
        "r  r",
        "rrr ",
        "r r ",
        "r  r",
        "    ",
    ],
    "s": [
        "    ",
        " sss",
        "s   ",
        " ss ",
        "   s",
        "sss ",
        "    ",
    ],
    "t": [
        "   ",
        "ttt",
        " t ",
        " t ",
        " t ",
        " t ",
        "   ",
    ],
    "u": [
        "    ",
        "u  u",
        "u  u",
        "u  u",
        "u  u",
        " uu ",
        "    ",
    ],
    "v": [
        "     ",
        "v   v",
        "v   v",
        " v v ",
        " v v ",
        "  v  ",
        "     ",
    ],
    "w": [
        "     ",
        "w   w",
        "w w w",
        "w w w",
        "w w w",
        " w w ",
        "     ",
    ],
    "x": [
        "     ",
        "x   x",
        " x x ",
        "  x  ",
        " x x ",
        "x   x",
        "     ",
    ],
    "y": [
        "     ",
        "y   y",
        " y y ",
        "  y  ",
        "  y  ",
        "  y  ",
        "     ",
    ],
    "z": [
        "   ",
        "zzz",
        "  z",
        " z ",
        "z  ",
        "zzz",
        "   ",
    ],
    ".": [
        " ",
        " ",
        " ",
        " ",
        " ",
        ".",
        " ",
    ],
    ",": [
        "  ",
        "  ",
        "  ",
        "  ",
        "  ",
        " ,",
        ", ",
    ],
    ";": [
        "  ",
        "  ",
        " ;",
        "  ",
        " ;",
        "; ",
        "  ",
    ],
    ":": [
        " ",
        " ",
        ":",
        " ",
        ":",
        " ",
        " ",
    ],
    "(": [
        "  ",
        " (",
        "( ",
        "( ",
        "( ",
        " (",
        "  ",
    ],
    ")": [
        "  ",
        ") ",
        " )",
        " )",
        " )",
        ") ",
        "  ",
    ],
    "[": [
        "  ",
        "[[",
        "[ ",
        "[ ",
        "[ ",
        "[[",
        "  ",
    ],
    "]": [
        "  ",
        "]]",
        " ]",
        " ]",
        " ]",
        "]]",
        "  ",
    ],
    "<": [
        "   ",
        "  <",
        " < ",
        "<  ",
        " < ",
        "  <",
        "   ",
    ],
    ">": [
        "   ",
        ">  ",
        " > ",
        "  >",
        " > ",
        ">  ",
        "   ",
    ],
    "!": [
        " ",
        "!",
        "!",
        "!",
        " ",
        "!",
        " ",
    ],
    "?": [
        "    ",
        "??? ",
        "   ?",
        " ?? ",
        "    ",
        " ?  ",
        "    ",
    ],
    "+": [
        "     ",
        "  +  ",
        "  +  ",
        "+++++",
        "  +  ",
        "  +  ",
        "     ",
    ],
    "-": [
        "   ",
        "   ",
        "   ",
        "---",
        "   ",
        "   ",
        "   ",
    ],
    "_": [
        "   ",
        "   ",
        "   ",
        "   ",
        "   ",
        "___",
        "   ",
    ],
    "*": [
        "     ",
        "  *  ",
        "* * *",
        " *** ",
        "* * *",
        "  *  ",
        "     ",
    ],
    "'": [
        " ",
        "'",
        "'",
        " ",
        " ",
        " ",
        " ",
    ],
}


def get_char_grid(char):
    if char not in font:
        raise Exception("Character '%s' not available" % char)

    return font.get(char)


def get_char_width(char):
    grid = get_char_grid(char)
    return max(len(row) for row in grid)
