"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Missing, exclude_unset

from .types import (
    OrgsOrgPatchBodyType,
    OrgsOrgHooksPostBodyType,
    OrgsOrgInvitationsPostBodyType,
    OrgsOrgHooksHookIdPatchBodyType,
    OrgsOrgHooksPostBodyPropConfigType,
    UserMembershipsOrgsOrgPatchBodyType,
    OrgsOrgHooksHookIdConfigPatchBodyType,
    OrgsOrgMembershipsUsernamePutBodyType,
    OrgsOrgHooksHookIdPatchBodyPropConfigType,
    OrgsOrgOutsideCollaboratorsUsernamePutBodyType,
    OrganizationsOrgPersonalAccessTokensPostBodyType,
    OrganizationsOrgPersonalAccessTokensPatIdPostBodyType,
    OrganizationsOrgPersonalAccessTokenRequestsPostBodyType,
    OrganizationsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
)
from .models import (
    Team,
    OrgHook,
    BasicError,
    SimpleUser,
    TeamSimple,
    HookDelivery,
    OrgMembership,
    WebhookConfig,
    ValidationError,
    HookDeliveryItem,
    OrganizationFull,
    OrgsOrgPatchBody,
    MinimalRepository,
    OrganizationSimple,
    OrgsOrgHooksPostBody,
    ValidationErrorSimple,
    OrganizationInvitation,
    OrgsOrgInvitationsPostBody,
    OrgsOrgHooksHookIdPatchBody,
    UserMembershipsOrgsOrgPatchBody,
    OrgsOrgHooksHookIdConfigPatchBody,
    OrgsOrgMembershipsUsernamePutBody,
    OrgsOrgInstallationsGetResponse200,
    OrganizationProgrammaticAccessGrant,
    OrganizationProgrammaticAccessGrantRequest,
    OrgsOrgOutsideCollaboratorsUsernamePutBody,
    OrganizationsOrgPersonalAccessTokensPostBody,
    OrganizationsOrgPersonalAccessTokensPatIdPostBody,
    OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
    AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    OrganizationsOrgPersonalAccessTokenRequestsPostBody,
    OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
    OrganizationsOrgPersonalAccessTokenRequestsPatRequestIdPostBody,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class OrgsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list(
        self,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = 30,
    ) -> "Response[List[OrganizationSimple]]":
        url = "/organizations"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
        )

    async def async_list(
        self,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = 30,
    ) -> "Response[List[OrganizationSimple]]":
        url = "/organizations"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
        )

    def list_pat_grant_requests(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        sort: Missing[Literal["created_at"]] = "created_at",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        owner: Missing[List[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
    ) -> "Response[List[OrganizationProgrammaticAccessGrantRequest]]":
        url = f"/organizations/{org}/personal-access-token-requests"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationProgrammaticAccessGrantRequest],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_requests(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        sort: Missing[Literal["created_at"]] = "created_at",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        owner: Missing[List[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
    ) -> "Response[List[OrganizationProgrammaticAccessGrantRequest]]":
        url = f"/organizations/{org}/personal-access-token-requests"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationProgrammaticAccessGrantRequest],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def review_pat_grant_requests_in_bulk(
        self, org: str, *, data: OrganizationsOrgPersonalAccessTokenRequestsPostBodyType
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        ...

    @overload
    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        pat_request_ids: Missing[List[int]] = UNSET,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        ...

    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        data: Missing[OrganizationsOrgPersonalAccessTokenRequestsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/organizations/{org}/personal-access-token-requests"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrganizationsOrgPersonalAccessTokenRequestsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_review_pat_grant_requests_in_bulk(
        self, org: str, *, data: OrganizationsOrgPersonalAccessTokenRequestsPostBodyType
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        ...

    @overload
    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        pat_request_ids: Missing[List[int]] = UNSET,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        ...

    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        data: Missing[OrganizationsOrgPersonalAccessTokenRequestsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/organizations/{org}/personal-access-token-requests"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrganizationsOrgPersonalAccessTokenRequestsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: OrganizationsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
    ) -> "Response":
        ...

    @overload
    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> "Response":
        ...

    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: Missing[
            OrganizationsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/organizations/{org}/personal-access-token-requests/{pat_request_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrganizationsOrgPersonalAccessTokenRequestsPatRequestIdPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: OrganizationsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> "Response":
        ...

    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: Missing[
            OrganizationsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/organizations/{org}/personal-access-token-requests/{pat_request_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrganizationsOrgPersonalAccessTokenRequestsPatRequestIdPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_pat_grant_request_repositories(
        self,
        org: str,
        pat_request_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/organizations/{org}/personal-access-token-requests/{pat_request_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_request_repositories(
        self,
        org: str,
        pat_request_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/organizations/{org}/personal-access-token-requests/{pat_request_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_pat_grants(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        sort: Missing[Literal["created_at"]] = "created_at",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        owner: Missing[List[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
    ) -> "Response[List[OrganizationProgrammaticAccessGrant]]":
        url = f"/organizations/{org}/personal-access-tokens"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationProgrammaticAccessGrant],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grants(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        sort: Missing[Literal["created_at"]] = "created_at",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        owner: Missing[List[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
    ) -> "Response[List[OrganizationProgrammaticAccessGrant]]":
        url = f"/organizations/{org}/personal-access-tokens"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationProgrammaticAccessGrant],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update_pat_accesses(
        self, org: str, *, data: OrganizationsOrgPersonalAccessTokensPostBodyType
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        ...

    @overload
    def update_pat_accesses(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        action: Literal["revoke"],
        pat_ids: List[int],
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        ...

    def update_pat_accesses(
        self,
        org: str,
        *,
        data: Missing[OrganizationsOrgPersonalAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/organizations/{org}/personal-access-tokens"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrganizationsOrgPersonalAccessTokensPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pat_accesses(
        self, org: str, *, data: OrganizationsOrgPersonalAccessTokensPostBodyType
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        ...

    @overload
    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        action: Literal["revoke"],
        pat_ids: List[int],
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        ...

    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        data: Missing[OrganizationsOrgPersonalAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/organizations/{org}/personal-access-tokens"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrganizationsOrgPersonalAccessTokensPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: OrganizationsOrgPersonalAccessTokensPatIdPostBodyType,
    ) -> "Response":
        ...

    @overload
    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        action: Literal["revoke"],
    ) -> "Response":
        ...

    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: Missing[OrganizationsOrgPersonalAccessTokensPatIdPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/organizations/{org}/personal-access-tokens/{pat_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrganizationsOrgPersonalAccessTokensPatIdPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: OrganizationsOrgPersonalAccessTokensPatIdPostBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        action: Literal["revoke"],
    ) -> "Response":
        ...

    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: Missing[OrganizationsOrgPersonalAccessTokensPatIdPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/organizations/{org}/personal-access-tokens/{pat_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrganizationsOrgPersonalAccessTokensPatIdPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_pat_grant_repositories(
        self,
        org: str,
        pat_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/organizations/{org}/personal-access-tokens/{pat_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_repositories(
        self,
        org: str,
        pat_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/organizations/{org}/personal-access-tokens/{pat_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def get(
        self,
        org: str,
    ) -> "Response[OrganizationFull]":
        url = f"/orgs/{org}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        org: str,
    ) -> "Response[OrganizationFull]":
        url = f"/orgs/{org}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete(
        self,
        org: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_delete(
        self,
        org: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update(
        self, org: str, *, data: Missing[OrgsOrgPatchBodyType] = UNSET
    ) -> "Response[OrganizationFull]":
        ...

    @overload
    def update(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        billing_email: Missing[str] = UNSET,
        company: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        twitter_username: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        has_organization_projects: Missing[bool] = UNSET,
        has_repository_projects: Missing[bool] = UNSET,
        default_repository_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = "read",
        members_can_create_repositories: Missing[bool] = True,
        members_can_create_internal_repositories: Missing[bool] = UNSET,
        members_can_create_private_repositories: Missing[bool] = UNSET,
        members_can_create_public_repositories: Missing[bool] = UNSET,
        members_allowed_repository_creation_type: Missing[
            Literal["all", "private", "none"]
        ] = UNSET,
        members_can_create_pages: Missing[bool] = True,
        members_can_create_public_pages: Missing[bool] = True,
        members_can_create_private_pages: Missing[bool] = True,
        members_can_fork_private_repositories: Missing[bool] = False,
        web_commit_signoff_required: Missing[bool] = False,
        blog: Missing[str] = UNSET,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependency_graph_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link_enabled: Missing[bool] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[str] = UNSET,
    ) -> "Response[OrganizationFull]":
        ...

    def update(
        self, org: str, *, data: Missing[OrgsOrgPatchBodyType] = UNSET, **kwargs
    ) -> "Response[OrganizationFull]":
        url = f"/orgs/{org}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "422": Union[ValidationError, ValidationErrorSimple],
                "409": BasicError,
            },
        )

    @overload
    async def async_update(
        self, org: str, *, data: Missing[OrgsOrgPatchBodyType] = UNSET
    ) -> "Response[OrganizationFull]":
        ...

    @overload
    async def async_update(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        billing_email: Missing[str] = UNSET,
        company: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        twitter_username: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        has_organization_projects: Missing[bool] = UNSET,
        has_repository_projects: Missing[bool] = UNSET,
        default_repository_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = "read",
        members_can_create_repositories: Missing[bool] = True,
        members_can_create_internal_repositories: Missing[bool] = UNSET,
        members_can_create_private_repositories: Missing[bool] = UNSET,
        members_can_create_public_repositories: Missing[bool] = UNSET,
        members_allowed_repository_creation_type: Missing[
            Literal["all", "private", "none"]
        ] = UNSET,
        members_can_create_pages: Missing[bool] = True,
        members_can_create_public_pages: Missing[bool] = True,
        members_can_create_private_pages: Missing[bool] = True,
        members_can_fork_private_repositories: Missing[bool] = False,
        web_commit_signoff_required: Missing[bool] = False,
        blog: Missing[str] = UNSET,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependency_graph_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link_enabled: Missing[bool] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[str] = UNSET,
    ) -> "Response[OrganizationFull]":
        ...

    async def async_update(
        self, org: str, *, data: Missing[OrgsOrgPatchBodyType] = UNSET, **kwargs
    ) -> "Response[OrganizationFull]":
        url = f"/orgs/{org}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "422": Union[ValidationError, ValidationErrorSimple],
                "409": BasicError,
            },
        )

    def list_blocked_users(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_blocked_users(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    def check_blocked_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_check_blocked_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def block_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    async def async_block_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    def unblock_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_unblock_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/blocks/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_failed_invitations(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/failed_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_failed_invitations(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/failed_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    def list_webhooks(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrgHook]]":
        url = f"/orgs/{org}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrgHook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrgHook]]":
        url = f"/orgs/{org}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrgHook],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_webhook(
        self, org: str, *, data: OrgsOrgHooksPostBodyType
    ) -> "Response[OrgHook]":
        ...

    @overload
    def create_webhook(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        config: OrgsOrgHooksPostBodyPropConfigType,
        events: Missing[List[str]] = ["push"],
        active: Missing[bool] = True,
    ) -> "Response[OrgHook]":
        ...

    def create_webhook(
        self, org: str, *, data: Missing[OrgsOrgHooksPostBodyType] = UNSET, **kwargs
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_webhook(
        self, org: str, *, data: OrgsOrgHooksPostBodyType
    ) -> "Response[OrgHook]":
        ...

    @overload
    async def async_create_webhook(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        config: OrgsOrgHooksPostBodyPropConfigType,
        events: Missing[List[str]] = ["push"],
        active: Missing[bool] = True,
    ) -> "Response[OrgHook]":
        ...

    async def async_create_webhook(
        self, org: str, *, data: Missing[OrgsOrgHooksPostBodyType] = UNSET, **kwargs
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
    ) -> "Response[OrgHook]":
        ...

    @overload
    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        config: Missing[OrgsOrgHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Missing[List[str]] = ["push"],
        active: Missing[bool] = True,
        name: Missing[str] = UNSET,
    ) -> "Response[OrgHook]":
        ...

    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksHookIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
    ) -> "Response[OrgHook]":
        ...

    @overload
    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        config: Missing[OrgsOrgHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Missing[List[str]] = ["push"],
        active: Missing[bool] = True,
        name: Missing[str] = UNSET,
    ) -> "Response[OrgHook]":
        ...

    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgHook]":
        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksHookIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
    ) -> "Response[WebhookConfig]":
        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
    ) -> "Response[WebhookConfig]":
        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    @overload
    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[WebhookConfig]":
        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksHookIdConfigPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    @overload
    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[WebhookConfig]":
        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgHooksHookIdConfigPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        org: str,
        hook_id: int,
        per_page: Missing[int] = 30,
        cursor: Missing[str] = UNSET,
        redelivery: Missing[bool] = UNSET,
    ) -> "Response[List[HookDeliveryItem]]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        org: str,
        hook_id: int,
        per_page: Missing[int] = 30,
        cursor: Missing[str] = UNSET,
        redelivery: Missing[bool] = UNSET,
    ) -> "Response[List[HookDeliveryItem]]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[HookDelivery]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[HookDelivery]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/hooks/{hook_id}/pings"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        org: str,
        hook_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/hooks/{hook_id}/pings"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_app_installations(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[OrgsOrgInstallationsGetResponse200]":
        url = f"/orgs/{org}/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgInstallationsGetResponse200,
        )

    async def async_list_app_installations(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[OrgsOrgInstallationsGetResponse200]":
        url = f"/orgs/{org}/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgInstallationsGetResponse200,
        )

    def list_pending_invitations(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        role: Missing[
            Literal[
                "all", "admin", "direct_member", "billing_manager", "hiring_manager"
            ]
        ] = "all",
        invitation_source: Missing[Literal["all", "member", "scim"]] = "all",
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
            "role": role,
            "invitation_source": invitation_source,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_pending_invitations(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        role: Missing[
            Literal[
                "all", "admin", "direct_member", "billing_manager", "hiring_manager"
            ]
        ] = "all",
        invitation_source: Missing[Literal["all", "member", "scim"]] = "all",
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
            "role": role,
            "invitation_source": invitation_source,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_invitation(
        self, org: str, *, data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET
    ) -> "Response[OrganizationInvitation]":
        ...

    @overload
    def create_invitation(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        invitee_id: Missing[int] = UNSET,
        email: Missing[str] = UNSET,
        role: Missing[
            Literal["admin", "direct_member", "billing_manager"]
        ] = "direct_member",
        team_ids: Missing[List[int]] = UNSET,
    ) -> "Response[OrganizationInvitation]":
        ...

    def create_invitation(
        self,
        org: str,
        *,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrganizationInvitation]":
        url = f"/orgs/{org}/invitations"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgInvitationsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationInvitation,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_invitation(
        self, org: str, *, data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET
    ) -> "Response[OrganizationInvitation]":
        ...

    @overload
    async def async_create_invitation(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        invitee_id: Missing[int] = UNSET,
        email: Missing[str] = UNSET,
        role: Missing[
            Literal["admin", "direct_member", "billing_manager"]
        ] = "direct_member",
        team_ids: Missing[List[int]] = UNSET,
    ) -> "Response[OrganizationInvitation]":
        ...

    async def async_create_invitation(
        self,
        org: str,
        *,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrganizationInvitation]":
        url = f"/orgs/{org}/invitations"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgInvitationsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationInvitation,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def cancel_invitation(
        self,
        org: str,
        invitation_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/invitations/{invitation_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_cancel_invitation(
        self,
        org: str,
        invitation_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/invitations/{invitation_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_invitation_teams(
        self,
        org: str,
        invitation_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/invitations/{invitation_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_invitation_teams(
        self,
        org: str,
        invitation_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/invitations/{invitation_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    def list_members(
        self,
        org: str,
        filter_: Missing[Literal["2fa_disabled", "all"]] = "all",
        role: Missing[Literal["all", "admin", "member"]] = "all",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/members"

        params = {
            "filter": filter_,
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_members(
        self,
        org: str,
        filter_: Missing[Literal["2fa_disabled", "all"]] = "all",
        role: Missing[Literal["all", "admin", "member"]] = "all",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/members"

        params = {
            "filter": filter_,
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    def check_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def remove_member(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_remove_member(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def get_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response[OrgMembership]":
        url = f"/orgs/{org}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response[OrgMembership]":
        url = f"/orgs/{org}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
    ) -> "Response[OrgMembership]":
        ...

    @overload
    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        role: Missing[Literal["admin", "member"]] = "member",
    ) -> "Response[OrgMembership]":
        ...

    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgMembership]":
        url = f"/orgs/{org}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgMembershipsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
    ) -> "Response[OrgMembership]":
        ...

    @overload
    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        role: Missing[Literal["admin", "member"]] = "member",
    ) -> "Response[OrgMembership]":
        ...

    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgMembership]":
        url = f"/orgs/{org}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgMembershipsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_outside_collaborators(
        self,
        org: str,
        filter_: Missing[Literal["2fa_disabled", "all"]] = "all",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/outside_collaborators"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_outside_collaborators(
        self,
        org: str,
        filter_: Missing[Literal["2fa_disabled", "all"]] = "all",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/outside_collaborators"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    @overload
    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        ...

    @overload
    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        async_: Missing[bool] = False,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        ...

    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgOutsideCollaboratorsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        ...

    @overload
    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        async_: Missing[bool] = False,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        ...

    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]":
        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgOutsideCollaboratorsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
            error_models={
                "404": BasicError,
            },
        )

    def remove_outside_collaborator(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
            },
        )

    async def async_remove_outside_collaborator(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
            },
        )

    def list_public_members(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/public_members"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_public_members(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/public_members"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    def check_public_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_public_membership_for_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def set_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_set_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def remove_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/public_members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_security_manager_teams(
        self,
        org: str,
    ) -> "Response[List[TeamSimple]]":
        url = f"/orgs/{org}/security-managers"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[TeamSimple],
        )

    async def async_list_security_manager_teams(
        self,
        org: str,
    ) -> "Response[List[TeamSimple]]":
        url = f"/orgs/{org}/security-managers"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[TeamSimple],
        )

    def add_security_manager_team(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_add_security_manager_team(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def remove_security_manager_team(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_security_manager_team(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
    ) -> "Response":
        url = f"/orgs/{org}/{security_product}/{enablement}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
    ) -> "Response":
        url = f"/orgs/{org}/{security_product}/{enablement}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_memberships_for_authenticated_user(
        self,
        state: Missing[Literal["active", "pending"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrgMembership]]":
        url = "/user/memberships/orgs"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrgMembership],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_memberships_for_authenticated_user(
        self,
        state: Missing[Literal["active", "pending"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrgMembership]]":
        url = "/user/memberships/orgs"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrgMembership],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def get_membership_for_authenticated_user(
        self,
        org: str,
    ) -> "Response[OrgMembership]":
        url = f"/user/memberships/orgs/{org}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_membership_for_authenticated_user(
        self,
        org: str,
    ) -> "Response[OrgMembership]":
        url = f"/user/memberships/orgs/{org}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_membership_for_authenticated_user(
        self, org: str, *, data: UserMembershipsOrgsOrgPatchBodyType
    ) -> "Response[OrgMembership]":
        ...

    @overload
    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        state: Literal["active"],
    ) -> "Response[OrgMembership]":
        ...

    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: Missing[UserMembershipsOrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgMembership]":
        url = f"/user/memberships/orgs/{org}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserMembershipsOrgsOrgPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_membership_for_authenticated_user(
        self, org: str, *, data: UserMembershipsOrgsOrgPatchBodyType
    ) -> "Response[OrgMembership]":
        ...

    @overload
    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        state: Literal["active"],
    ) -> "Response[OrgMembership]":
        ...

    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: Missing[UserMembershipsOrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgMembership]":
        url = f"/user/memberships/orgs/{org}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserMembershipsOrgsOrgPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrganizationSimple]]":
        url = "/user/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrganizationSimple]]":
        url = "/user/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrganizationSimple]]":
        url = f"/users/{username}/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
        )

    async def async_list_for_user(
        self,
        username: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrganizationSimple]]":
        url = f"/users/{username}/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
        )
