"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Missing, exclude_unset

from .types import (
    UserProjectsPostBodyType,
    OrgsOrgProjectsPostBodyType,
    ProjectsProjectIdPatchBodyType,
    ReposOwnerRepoProjectsPostBodyType,
    ProjectsColumnsColumnIdPatchBodyType,
    ProjectsProjectIdColumnsPostBodyType,
    ProjectsColumnsCardsCardIdPatchBodyType,
    ProjectsColumnsColumnIdMovesPostBodyType,
    ProjectsColumnsCardsCardIdMovesPostBodyType,
    ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
    ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
    ProjectsProjectIdCollaboratorsUsernamePutBodyType,
)
from .models import (
    Project,
    BasicError,
    SimpleUser,
    ProjectCard,
    ProjectColumn,
    ValidationError,
    UserProjectsPostBody,
    ValidationErrorSimple,
    OrgsOrgProjectsPostBody,
    ProjectsProjectIdPatchBody,
    ProjectCollaboratorPermission,
    ReposOwnerRepoProjectsPostBody,
    ProjectsColumnsColumnIdPatchBody,
    ProjectsProjectIdColumnsPostBody,
    ProjectsProjectIdPatchResponse403,
    ProjectsProjectIdDeleteResponse403,
    ProjectsColumnsCardsCardIdPatchBody,
    ProjectsColumnsColumnIdMovesPostBody,
    ProjectsColumnsCardsCardIdMovesPostBody,
    ProjectsColumnsColumnIdCardsPostBodyOneof0,
    ProjectsColumnsColumnIdCardsPostBodyOneof1,
    ProjectsColumnsCardsCardIdDeleteResponse403,
    ProjectsColumnsColumnIdCardsPostResponse503,
    ProjectsColumnsColumnIdMovesPostResponse201,
    ProjectsProjectIdCollaboratorsUsernamePutBody,
    ProjectsColumnsCardsCardIdMovesPostResponse201,
    ProjectsColumnsCardsCardIdMovesPostResponse403,
    ProjectsColumnsCardsCardIdMovesPostResponse503,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class ProjectsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_for_org(
        self,
        org: str,
        state: Missing[Literal["open", "closed", "all"]] = "open",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/orgs/{org}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Project],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_for_org(
        self,
        org: str,
        state: Missing[Literal["open", "closed", "all"]] = "open",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/orgs/{org}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Project],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_for_org(
        self, org: str, *, data: OrgsOrgProjectsPostBodyType
    ) -> "Response[Project]":
        ...

    @overload
    def create_for_org(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        body: Missing[str] = UNSET,
    ) -> "Response[Project]":
        ...

    def create_for_org(
        self, org: str, *, data: Missing[OrgsOrgProjectsPostBodyType] = UNSET, **kwargs
    ) -> "Response[Project]":
        url = f"/orgs/{org}/projects"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgProjectsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_for_org(
        self, org: str, *, data: OrgsOrgProjectsPostBodyType
    ) -> "Response[Project]":
        ...

    @overload
    async def async_create_for_org(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        body: Missing[str] = UNSET,
    ) -> "Response[Project]":
        ...

    async def async_create_for_org(
        self, org: str, *, data: Missing[OrgsOrgProjectsPostBodyType] = UNSET, **kwargs
    ) -> "Response[Project]":
        url = f"/orgs/{org}/projects"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgProjectsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_card(
        self,
        card_id: int,
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_card(
        self,
        card_id: int,
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    def delete_card(
        self,
        card_id: int,
    ) -> "Response":
        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ProjectsColumnsCardsCardIdDeleteResponse403,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_card(
        self,
        card_id: int,
    ) -> "Response":
        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ProjectsColumnsCardsCardIdDeleteResponse403,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_card(
        self,
        card_id: int,
        *,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
    ) -> "Response[ProjectCard]":
        ...

    @overload
    def update_card(
        self,
        card_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        note: Missing[Union[str, None]] = UNSET,
        archived: Missing[bool] = UNSET,
    ) -> "Response[ProjectCard]":
        ...

    def update_card(
        self,
        card_id: int,
        *,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsColumnsCardsCardIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_card(
        self,
        card_id: int,
        *,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
    ) -> "Response[ProjectCard]":
        ...

    @overload
    async def async_update_card(
        self,
        card_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        note: Missing[Union[str, None]] = UNSET,
        archived: Missing[bool] = UNSET,
    ) -> "Response[ProjectCard]":
        ...

    async def async_update_card(
        self,
        card_id: int,
        *,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsColumnsCardsCardIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def move_card(
        self, card_id: int, *, data: ProjectsColumnsCardsCardIdMovesPostBodyType
    ) -> "Response[ProjectsColumnsCardsCardIdMovesPostResponse201]":
        ...

    @overload
    def move_card(
        self,
        card_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        position: str,
        column_id: Missing[int] = UNSET,
    ) -> "Response[ProjectsColumnsCardsCardIdMovesPostResponse201]":
        ...

    def move_card(
        self,
        card_id: int,
        *,
        data: Missing[ProjectsColumnsCardsCardIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProjectsColumnsCardsCardIdMovesPostResponse201]":
        url = f"/projects/columns/cards/{card_id}/moves"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsColumnsCardsCardIdMovesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectsColumnsCardsCardIdMovesPostResponse201,
            error_models={
                "403": ProjectsColumnsCardsCardIdMovesPostResponse403,
                "401": BasicError,
                "503": ProjectsColumnsCardsCardIdMovesPostResponse503,
                "422": ValidationError,
            },
        )

    @overload
    async def async_move_card(
        self, card_id: int, *, data: ProjectsColumnsCardsCardIdMovesPostBodyType
    ) -> "Response[ProjectsColumnsCardsCardIdMovesPostResponse201]":
        ...

    @overload
    async def async_move_card(
        self,
        card_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        position: str,
        column_id: Missing[int] = UNSET,
    ) -> "Response[ProjectsColumnsCardsCardIdMovesPostResponse201]":
        ...

    async def async_move_card(
        self,
        card_id: int,
        *,
        data: Missing[ProjectsColumnsCardsCardIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProjectsColumnsCardsCardIdMovesPostResponse201]":
        url = f"/projects/columns/cards/{card_id}/moves"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsColumnsCardsCardIdMovesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectsColumnsCardsCardIdMovesPostResponse201,
            error_models={
                "403": ProjectsColumnsCardsCardIdMovesPostResponse403,
                "401": BasicError,
                "503": ProjectsColumnsCardsCardIdMovesPostResponse503,
                "422": ValidationError,
            },
        )

    def get_column(
        self,
        column_id: int,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/columns/{column_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_column(
        self,
        column_id: int,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/columns/{column_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    def delete_column(
        self,
        column_id: int,
    ) -> "Response":
        url = f"/projects/columns/{column_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_column(
        self,
        column_id: int,
    ) -> "Response":
        url = f"/projects/columns/{column_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def update_column(
        self, column_id: int, *, data: ProjectsColumnsColumnIdPatchBodyType
    ) -> "Response[ProjectColumn]":
        ...

    @overload
    def update_column(
        self,
        column_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
    ) -> "Response[ProjectColumn]":
        ...

    def update_column(
        self,
        column_id: int,
        *,
        data: Missing[ProjectsColumnsColumnIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/columns/{column_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsColumnsColumnIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_update_column(
        self, column_id: int, *, data: ProjectsColumnsColumnIdPatchBodyType
    ) -> "Response[ProjectColumn]":
        ...

    @overload
    async def async_update_column(
        self,
        column_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
    ) -> "Response[ProjectColumn]":
        ...

    async def async_update_column(
        self,
        column_id: int,
        *,
        data: Missing[ProjectsColumnsColumnIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/columns/{column_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsColumnsColumnIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_cards(
        self,
        column_id: int,
        archived_state: Missing[
            Literal["all", "archived", "not_archived"]
        ] = "not_archived",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[ProjectCard]]":
        url = f"/projects/columns/{column_id}/cards"

        params = {
            "archived_state": archived_state,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ProjectCard],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_cards(
        self,
        column_id: int,
        archived_state: Missing[
            Literal["all", "archived", "not_archived"]
        ] = "not_archived",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[ProjectCard]]":
        url = f"/projects/columns/{column_id}/cards"

        params = {
            "archived_state": archived_state,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ProjectCard],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_card(
        self,
        column_id: int,
        *,
        data: Union[
            ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
            ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ],
    ) -> "Response[ProjectCard]":
        ...

    @overload
    def create_card(
        self,
        column_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        note: Union[str, None],
    ) -> "Response[ProjectCard]":
        ...

    @overload
    def create_card(
        self,
        column_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        content_id: int,
        content_type: str,
    ) -> "Response[ProjectCard]":
        ...

    def create_card(
        self,
        column_id: int,
        *,
        data: Missing[
            Union[
                ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
                ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/{column_id}/cards"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ProjectsColumnsColumnIdCardsPostBodyOneof0,
                ProjectsColumnsColumnIdCardsPostBodyOneof1,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": Union[ValidationError, ValidationErrorSimple],
                "503": ProjectsColumnsColumnIdCardsPostResponse503,
            },
        )

    @overload
    async def async_create_card(
        self,
        column_id: int,
        *,
        data: Union[
            ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
            ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ],
    ) -> "Response[ProjectCard]":
        ...

    @overload
    async def async_create_card(
        self,
        column_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        note: Union[str, None],
    ) -> "Response[ProjectCard]":
        ...

    @overload
    async def async_create_card(
        self,
        column_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        content_id: int,
        content_type: str,
    ) -> "Response[ProjectCard]":
        ...

    async def async_create_card(
        self,
        column_id: int,
        *,
        data: Missing[
            Union[
                ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
                ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/{column_id}/cards"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ProjectsColumnsColumnIdCardsPostBodyOneof0,
                ProjectsColumnsColumnIdCardsPostBodyOneof1,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": Union[ValidationError, ValidationErrorSimple],
                "503": ProjectsColumnsColumnIdCardsPostResponse503,
            },
        )

    @overload
    def move_column(
        self, column_id: int, *, data: ProjectsColumnsColumnIdMovesPostBodyType
    ) -> "Response[ProjectsColumnsColumnIdMovesPostResponse201]":
        ...

    @overload
    def move_column(
        self,
        column_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        position: str,
    ) -> "Response[ProjectsColumnsColumnIdMovesPostResponse201]":
        ...

    def move_column(
        self,
        column_id: int,
        *,
        data: Missing[ProjectsColumnsColumnIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProjectsColumnsColumnIdMovesPostResponse201]":
        url = f"/projects/columns/{column_id}/moves"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsColumnsColumnIdMovesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    @overload
    async def async_move_column(
        self, column_id: int, *, data: ProjectsColumnsColumnIdMovesPostBodyType
    ) -> "Response[ProjectsColumnsColumnIdMovesPostResponse201]":
        ...

    @overload
    async def async_move_column(
        self,
        column_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        position: str,
    ) -> "Response[ProjectsColumnsColumnIdMovesPostResponse201]":
        ...

    async def async_move_column(
        self,
        column_id: int,
        *,
        data: Missing[ProjectsColumnsColumnIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProjectsColumnsColumnIdMovesPostResponse201]":
        url = f"/projects/columns/{column_id}/moves"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsColumnsColumnIdMovesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    def get(
        self,
        project_id: int,
    ) -> "Response[Project]":
        url = f"/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get(
        self,
        project_id: int,
    ) -> "Response[Project]":
        url = f"/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete(
        self,
        project_id: int,
    ) -> "Response":
        url = f"/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ProjectsProjectIdDeleteResponse403,
                "401": BasicError,
                "410": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete(
        self,
        project_id: int,
    ) -> "Response":
        url = f"/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ProjectsProjectIdDeleteResponse403,
                "401": BasicError,
                "410": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update(
        self, project_id: int, *, data: Missing[ProjectsProjectIdPatchBodyType] = UNSET
    ) -> "Response[Project]":
        ...

    @overload
    def update(
        self,
        project_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[Union[str, None]] = UNSET,
        state: Missing[str] = UNSET,
        organization_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> "Response[Project]":
        ...

    def update(
        self,
        project_id: int,
        *,
        data: Missing[ProjectsProjectIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Project]":
        url = f"/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsProjectIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": ProjectsProjectIdPatchResponse403,
                "401": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update(
        self, project_id: int, *, data: Missing[ProjectsProjectIdPatchBodyType] = UNSET
    ) -> "Response[Project]":
        ...

    @overload
    async def async_update(
        self,
        project_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[Union[str, None]] = UNSET,
        state: Missing[str] = UNSET,
        organization_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> "Response[Project]":
        ...

    async def async_update(
        self,
        project_id: int,
        *,
        data: Missing[ProjectsProjectIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Project]":
        url = f"/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsProjectIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": ProjectsProjectIdPatchResponse403,
                "401": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_collaborators(
        self,
        project_id: int,
        affiliation: Missing[Literal["outside", "direct", "all"]] = "all",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_collaborators(
        self,
        project_id: int,
        affiliation: Missing[Literal["outside", "direct", "all"]] = "all",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        permission: Missing[Literal["read", "write", "admin"]] = "write",
    ) -> "Response":
        ...

    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ProjectsProjectIdCollaboratorsUsernamePutBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        permission: Missing[Literal["read", "write", "admin"]] = "write",
    ) -> "Response":
        ...

    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ProjectsProjectIdCollaboratorsUsernamePutBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def remove_collaborator(
        self,
        project_id: int,
        username: str,
    ) -> "Response":
        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    async def async_remove_collaborator(
        self,
        project_id: int,
        username: str,
    ) -> "Response":
        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    def get_permission_for_user(
        self,
        project_id: int,
        username: str,
    ) -> "Response[ProjectCollaboratorPermission]":
        url = f"/projects/{project_id}/collaborators/{username}/permission"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_permission_for_user(
        self,
        project_id: int,
        username: str,
    ) -> "Response[ProjectCollaboratorPermission]":
        url = f"/projects/{project_id}/collaborators/{username}/permission"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_columns(
        self,
        project_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[ProjectColumn]]":
        url = f"/projects/{project_id}/columns"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ProjectColumn],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_columns(
        self,
        project_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[ProjectColumn]]":
        url = f"/projects/{project_id}/columns"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ProjectColumn],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_column(
        self, project_id: int, *, data: ProjectsProjectIdColumnsPostBodyType
    ) -> "Response[ProjectColumn]":
        ...

    @overload
    def create_column(
        self,
        project_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
    ) -> "Response[ProjectColumn]":
        ...

    def create_column(
        self,
        project_id: int,
        *,
        data: Missing[ProjectsProjectIdColumnsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/{project_id}/columns"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsProjectIdColumnsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_column(
        self, project_id: int, *, data: ProjectsProjectIdColumnsPostBodyType
    ) -> "Response[ProjectColumn]":
        ...

    @overload
    async def async_create_column(
        self,
        project_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
    ) -> "Response[ProjectColumn]":
        ...

    async def async_create_column(
        self,
        project_id: int,
        *,
        data: Missing[ProjectsProjectIdColumnsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/{project_id}/columns"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ProjectsProjectIdColumnsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    def list_for_repo(
        self,
        owner: str,
        repo: str,
        state: Missing[Literal["open", "closed", "all"]] = "open",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/repos/{owner}/{repo}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Project],
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_for_repo(
        self,
        owner: str,
        repo: str,
        state: Missing[Literal["open", "closed", "all"]] = "open",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/repos/{owner}/{repo}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Project],
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_for_repo(
        self, owner: str, repo: str, *, data: ReposOwnerRepoProjectsPostBodyType
    ) -> "Response[Project]":
        ...

    @overload
    def create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        body: Missing[str] = UNSET,
    ) -> "Response[Project]":
        ...

    def create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Missing[ReposOwnerRepoProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Project]":
        url = f"/repos/{owner}/{repo}/projects"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoProjectsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_for_repo(
        self, owner: str, repo: str, *, data: ReposOwnerRepoProjectsPostBodyType
    ) -> "Response[Project]":
        ...

    @overload
    async def async_create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        body: Missing[str] = UNSET,
    ) -> "Response[Project]":
        ...

    async def async_create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Missing[ReposOwnerRepoProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Project]":
        url = f"/repos/{owner}/{repo}/projects"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoProjectsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_for_authenticated_user(
        self, *, data: UserProjectsPostBodyType
    ) -> "Response[Project]":
        ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        body: Missing[Union[str, None]] = UNSET,
    ) -> "Response[Project]":
        ...

    def create_for_authenticated_user(
        self, *, data: Missing[UserProjectsPostBodyType] = UNSET, **kwargs
    ) -> "Response[Project]":
        url = "/user/projects"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserProjectsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self, *, data: UserProjectsPostBodyType
    ) -> "Response[Project]":
        ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        body: Missing[Union[str, None]] = UNSET,
    ) -> "Response[Project]":
        ...

    async def async_create_for_authenticated_user(
        self, *, data: Missing[UserProjectsPostBodyType] = UNSET, **kwargs
    ) -> "Response[Project]":
        url = "/user/projects"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserProjectsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_for_user(
        self,
        username: str,
        state: Missing[Literal["open", "closed", "all"]] = "open",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/users/{username}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Project],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_for_user(
        self,
        username: str,
        state: Missing[Literal["open", "closed", "all"]] = "open",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/users/{username}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Project],
            error_models={
                "422": ValidationError,
            },
        )
