"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Missing, exclude_unset

from .types import (
    OrgsOrgTeamsPostBodyType,
    TeamsTeamIdPatchBodyType,
    OrgsOrgTeamsTeamSlugPatchBodyType,
    TeamsTeamIdDiscussionsPostBodyType,
    TeamsTeamIdReposOwnerRepoPutBodyType,
    TeamsTeamIdProjectsProjectIdPutBodyType,
    TeamsTeamIdMembershipsUsernamePutBodyType,
    OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
    OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType,
    OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType,
    OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType,
    TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType,
    TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
    TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
)
from .models import (
    Team,
    TeamFull,
    BasicError,
    SimpleUser,
    TeamProject,
    TeamDiscussion,
    TeamMembership,
    TeamRepository,
    ValidationError,
    MinimalRepository,
    OrgsOrgTeamsPostBody,
    TeamsTeamIdPatchBody,
    TeamDiscussionComment,
    OrganizationInvitation,
    OrgsOrgTeamsTeamSlugPatchBody,
    TeamsTeamIdDiscussionsPostBody,
    TeamsTeamIdReposOwnerRepoPutBody,
    TeamsTeamIdProjectsProjectIdPutBody,
    TeamsTeamIdMembershipsUsernamePutBody,
    OrgsOrgTeamsTeamSlugDiscussionsPostBody,
    OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody,
    TeamsTeamIdProjectsProjectIdPutResponse403,
    OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody,
    OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody,
    TeamsTeamIdDiscussionsDiscussionNumberPatchBody,
    OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
    TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody,
    TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class TeamsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "403": BasicError,
            },
        )

    async def async_list(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def create(
        self, org: str, *, data: OrgsOrgTeamsPostBodyType
    ) -> "Response[TeamFull]":
        ...

    @overload
    def create(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        maintainers: Missing[List[str]] = UNSET,
        repo_names: Missing[List[str]] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push"]] = "pull",
        parent_team_id: Missing[int] = UNSET,
    ) -> "Response[TeamFull]":
        ...

    def create(
        self, org: str, *, data: Missing[OrgsOrgTeamsPostBodyType] = UNSET, **kwargs
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgTeamsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create(
        self, org: str, *, data: OrgsOrgTeamsPostBodyType
    ) -> "Response[TeamFull]":
        ...

    @overload
    async def async_create(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        maintainers: Missing[List[str]] = UNSET,
        repo_names: Missing[List[str]] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push"]] = "pull",
        parent_team_id: Missing[int] = UNSET,
    ) -> "Response[TeamFull]":
        ...

    async def async_create(
        self, org: str, *, data: Missing[OrgsOrgTeamsPostBodyType] = UNSET, **kwargs
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgTeamsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_by_name(
        self,
        org: str,
        team_slug: str,
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_by_name(
        self,
        org: str,
        team_slug: str,
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete_in_org(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_in_org(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
    ) -> "Response[TeamFull]":
        ...

    @overload
    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: Literal[UNSET] = UNSET,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = "pull",
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> "Response[TeamFull]":
        ...

    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgTeamsTeamSlugPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
    ) -> "Response[TeamFull]":
        ...

    @overload
    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: Literal[UNSET] = UNSET,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = "pull",
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> "Response[TeamFull]":
        ...

    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgTeamsTeamSlugPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_discussions_in_org(
        self,
        org: str,
        team_slug: str,
        direction: Missing[Literal["asc", "desc"]] = "desc",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        pinned: Missing[str] = UNSET,
    ) -> "Response[List[TeamDiscussion]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "pinned": pinned,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussion],
        )

    async def async_list_discussions_in_org(
        self,
        org: str,
        team_slug: str,
        direction: Missing[Literal["asc", "desc"]] = "desc",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        pinned: Missing[str] = UNSET,
    ) -> "Response[List[TeamDiscussion]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "pinned": pinned,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussion],
        )

    @overload
    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
    ) -> "Response[TeamDiscussion]":
        ...

    @overload
    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: Literal[UNSET] = UNSET,
        title: str,
        body: str,
        private: Missing[bool] = False,
    ) -> "Response[TeamDiscussion]":
        ...

    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgTeamsTeamSlugDiscussionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
    ) -> "Response[TeamDiscussion]":
        ...

    @overload
    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: Literal[UNSET] = UNSET,
        title: str,
        body: str,
        private: Missing[bool] = False,
    ) -> "Response[TeamDiscussion]":
        ...

    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgTeamsTeamSlugDiscussionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def get_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    async def async_get_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def delete_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
    ) -> "Response[TeamDiscussion]":
        ...

    @overload
    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> "Response[TeamDiscussion]":
        ...

    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
    ) -> "Response[TeamDiscussion]":
        ...

    @overload
    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> "Response[TeamDiscussion]":
        ...

    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def list_discussion_comments_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        direction: Missing[Literal["asc", "desc"]] = "desc",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamDiscussionComment]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussionComment],
        )

    async def async_list_discussion_comments_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        direction: Missing[Literal["asc", "desc"]] = "desc",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamDiscussionComment]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussionComment],
        )

    @overload
    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> "Response[TeamDiscussionComment]":
        ...

    @overload
    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        ...

    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> "Response[TeamDiscussionComment]":
        ...

    @overload
    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        ...

    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def get_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    async def async_get_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def delete_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> "Response[TeamDiscussionComment]":
        ...

    @overload
    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        ...

    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> "Response[TeamDiscussionComment]":
        ...

    @overload
    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        ...

    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def list_pending_invitations_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/teams/{team_slug}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
        )

    async def async_list_pending_invitations_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/teams/{team_slug}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
        )

    def list_members_in_org(
        self,
        org: str,
        team_slug: str,
        role: Missing[Literal["member", "maintainer", "all"]] = "all",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/teams/{team_slug}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_members_in_org(
        self,
        org: str,
        team_slug: str,
        role: Missing[Literal["member", "maintainer", "all"]] = "all",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/teams/{team_slug}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    def get_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
    ) -> "Response[TeamMembership]":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    async def async_get_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
    ) -> "Response[TeamMembership]":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    @overload
    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
    ) -> "Response[TeamMembership]":
        ...

    @overload
    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        role: Missing[Literal["member", "maintainer"]] = "member",
    ) -> "Response[TeamMembership]":
        ...

    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamMembership]":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    @overload
    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
    ) -> "Response[TeamMembership]":
        ...

    @overload
    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        role: Missing[Literal["member", "maintainer"]] = "member",
    ) -> "Response[TeamMembership]":
        ...

    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamMembership]":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    def remove_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_projects_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamProject]]":
        url = f"/orgs/{org}/teams/{team_slug}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamProject],
        )

    async def async_list_projects_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamProject]]":
        url = f"/orgs/{org}/teams/{team_slug}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamProject],
        )

    def check_permissions_for_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
    ) -> "Response[TeamProject]":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    async def async_check_permissions_for_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
    ) -> "Response[TeamProject]":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    @overload
    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> "Response":
        ...

    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
            },
        )

    @overload
    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> "Response":
        ...

    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
            },
        )

    def remove_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_repos_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/teams/{team_slug}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    async def async_list_repos_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/teams/{team_slug}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    def check_permissions_for_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
    ) -> "Response[TeamRepository]":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    async def async_check_permissions_for_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
    ) -> "Response[TeamRepository]":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    @overload
    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
    ) -> "Response":
        ...

    @overload
    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        permission: Missing[str] = "push",
    ) -> "Response":
        ...

    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        permission: Missing[str] = "push",
    ) -> "Response":
        ...

    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def remove_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_child_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/teams/{team_slug}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
        )

    async def async_list_child_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/teams/{team_slug}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
        )

    def get_legacy(
        self,
        team_id: int,
    ) -> "Response[TeamFull]":
        url = f"/teams/{team_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_legacy(
        self,
        team_id: int,
    ) -> "Response[TeamFull]":
        url = f"/teams/{team_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete_legacy(
        self,
        team_id: int,
    ) -> "Response":
        url = f"/teams/{team_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_delete_legacy(
        self,
        team_id: int,
    ) -> "Response":
        url = f"/teams/{team_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def update_legacy(
        self, team_id: int, *, data: TeamsTeamIdPatchBodyType
    ) -> "Response[TeamFull]":
        ...

    @overload
    def update_legacy(
        self,
        team_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = "pull",
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> "Response[TeamFull]":
        ...

    def update_legacy(
        self, team_id: int, *, data: Missing[TeamsTeamIdPatchBodyType] = UNSET, **kwargs
    ) -> "Response[TeamFull]":
        url = f"/teams/{team_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_legacy(
        self, team_id: int, *, data: TeamsTeamIdPatchBodyType
    ) -> "Response[TeamFull]":
        ...

    @overload
    async def async_update_legacy(
        self,
        team_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = "pull",
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> "Response[TeamFull]":
        ...

    async def async_update_legacy(
        self, team_id: int, *, data: Missing[TeamsTeamIdPatchBodyType] = UNSET, **kwargs
    ) -> "Response[TeamFull]":
        url = f"/teams/{team_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_discussions_legacy(
        self,
        team_id: int,
        direction: Missing[Literal["asc", "desc"]] = "desc",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamDiscussion]]":
        url = f"/teams/{team_id}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussion],
        )

    async def async_list_discussions_legacy(
        self,
        team_id: int,
        direction: Missing[Literal["asc", "desc"]] = "desc",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamDiscussion]]":
        url = f"/teams/{team_id}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussion],
        )

    @overload
    def create_discussion_legacy(
        self, team_id: int, *, data: TeamsTeamIdDiscussionsPostBodyType
    ) -> "Response[TeamDiscussion]":
        ...

    @overload
    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        title: str,
        body: str,
        private: Missing[bool] = False,
    ) -> "Response[TeamDiscussion]":
        ...

    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        data: Missing[TeamsTeamIdDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdDiscussionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_create_discussion_legacy(
        self, team_id: int, *, data: TeamsTeamIdDiscussionsPostBodyType
    ) -> "Response[TeamDiscussion]":
        ...

    @overload
    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        title: str,
        body: str,
        private: Missing[bool] = False,
    ) -> "Response[TeamDiscussion]":
        ...

    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        data: Missing[TeamsTeamIdDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdDiscussionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def get_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    async def async_get_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def delete_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
    ) -> "Response":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
    ) -> "Response":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
    ) -> "Response[TeamDiscussion]":
        ...

    @overload
    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> "Response[TeamDiscussion]":
        ...

    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdDiscussionsDiscussionNumberPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
    ) -> "Response[TeamDiscussion]":
        ...

    @overload
    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> "Response[TeamDiscussion]":
        ...

    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdDiscussionsDiscussionNumberPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def list_discussion_comments_legacy(
        self,
        team_id: int,
        discussion_number: int,
        direction: Missing[Literal["asc", "desc"]] = "desc",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamDiscussionComment]]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussionComment],
        )

    async def async_list_discussion_comments_legacy(
        self,
        team_id: int,
        discussion_number: int,
        direction: Missing[Literal["asc", "desc"]] = "desc",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamDiscussionComment]]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussionComment],
        )

    @overload
    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> "Response[TeamDiscussionComment]":
        ...

    @overload
    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        ...

    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> "Response[TeamDiscussionComment]":
        ...

    @overload
    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        ...

    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def get_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    async def async_get_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def delete_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
    ) -> "Response":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
    ) -> "Response":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> "Response[TeamDiscussionComment]":
        ...

    @overload
    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        ...

    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> "Response[TeamDiscussionComment]":
        ...

    @overload
    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        ...

    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def list_pending_invitations_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/teams/{team_id}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
        )

    async def async_list_pending_invitations_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/teams/{team_id}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
        )

    def list_members_legacy(
        self,
        team_id: int,
        role: Missing[Literal["member", "maintainer", "all"]] = "all",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/teams/{team_id}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_members_legacy(
        self,
        team_id: int,
        role: Missing[Literal["member", "maintainer", "all"]] = "all",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/teams/{team_id}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    def get_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_get_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def add_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_add_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def remove_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def get_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response[TeamMembership]":
        url = f"/teams/{team_id}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response[TeamMembership]":
        url = f"/teams/{team_id}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
    ) -> "Response[TeamMembership]":
        ...

    @overload
    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        role: Missing[Literal["member", "maintainer"]] = "member",
    ) -> "Response[TeamMembership]":
        ...

    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamMembership]":
        url = f"/teams/{team_id}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdMembershipsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
    ) -> "Response[TeamMembership]":
        ...

    @overload
    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        role: Missing[Literal["member", "maintainer"]] = "member",
    ) -> "Response[TeamMembership]":
        ...

    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TeamMembership]":
        url = f"/teams/{team_id}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdMembershipsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    def remove_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/memberships/{username}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_projects_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamProject]]":
        url = f"/teams/{team_id}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamProject],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_projects_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamProject]]":
        url = f"/teams/{team_id}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamProject],
            error_models={
                "404": BasicError,
            },
        )

    def check_permissions_for_project_legacy(
        self,
        team_id: int,
        project_id: int,
    ) -> "Response[TeamProject]":
        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    async def async_check_permissions_for_project_legacy(
        self,
        team_id: int,
        project_id: int,
    ) -> "Response[TeamProject]":
        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    @overload
    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
    ) -> "Response":
        ...

    @overload
    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> "Response":
        ...

    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdProjectsProjectIdPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": TeamsTeamIdProjectsProjectIdPutResponse403,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> "Response":
        ...

    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdProjectsProjectIdPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": TeamsTeamIdProjectsProjectIdPutResponse403,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def remove_project_legacy(
        self,
        team_id: int,
        project_id: int,
    ) -> "Response":
        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_remove_project_legacy(
        self,
        team_id: int,
        project_id: int,
    ) -> "Response":
        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_repos_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/teams/{team_id}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/teams/{team_id}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    def check_permissions_for_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
    ) -> "Response[TeamRepository]":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    async def async_check_permissions_for_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
    ) -> "Response[TeamRepository]":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    @overload
    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
    ) -> "Response":
        ...

    @overload
    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
    ) -> "Response":
        ...

    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdReposOwnerRepoPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
    ) -> "Response":
        ...

    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(TeamsTeamIdReposOwnerRepoPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def remove_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_child_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/teams/{team_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_child_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/teams/{team_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamFull]]":
        url = "/user/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamFull],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
    ) -> "Response[List[TeamFull]]":
        url = "/user/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {
            "X-GitHub-Api-Version": self._REST_API_VERSION,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamFull],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )
