"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Dict, List, Literal, Optional, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Missing, exclude_unset

from .types import (
    OrgsOrgDependabotSecretsSecretNamePutBodyType,
    ReposOwnerRepoDependabotSecretsSecretNamePutBodyType,
    ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType,
    OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType,
)
from .models import (
    BasicError,
    EmptyObject,
    DependabotAlert,
    DependabotSecret,
    DependabotPublicKey,
    ValidationErrorSimple,
    OrganizationDependabotSecret,
    DependabotAlertWithRepository,
    OrgsOrgDependabotSecretsGetResponse200,
    OrgsOrgDependabotSecretsSecretNamePutBody,
    ReposOwnerRepoDependabotSecretsGetResponse200,
    ReposOwnerRepoDependabotSecretsSecretNamePutBody,
    ReposOwnerRepoDependabotAlertsAlertNumberPatchBody,
    OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody,
    OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class DependabotClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_alerts_for_enterprise(
        self,
        enterprise: str,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = 30,
        last: Missing[int] = UNSET,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DependabotAlertWithRepository]]":
        url = f"/enterprises/{enterprise}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DependabotAlertWithRepository],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_alerts_for_enterprise(
        self,
        enterprise: str,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = 30,
        last: Missing[int] = UNSET,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DependabotAlertWithRepository]]":
        url = f"/enterprises/{enterprise}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DependabotAlertWithRepository],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_alerts_for_org(
        self,
        org: str,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = 30,
        last: Missing[int] = UNSET,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DependabotAlertWithRepository]]":
        url = f"/orgs/{org}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DependabotAlertWithRepository],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_alerts_for_org(
        self,
        org: str,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = 30,
        last: Missing[int] = UNSET,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DependabotAlertWithRepository]]":
        url = f"/orgs/{org}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DependabotAlertWithRepository],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgDependabotSecretsGetResponse200]":
        url = f"/orgs/{org}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgDependabotSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgDependabotSecretsGetResponse200]":
        url = f"/orgs/{org}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgDependabotSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DependabotPublicKey]":
        url = f"/orgs/{org}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DependabotPublicKey]":
        url = f"/orgs/{org}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrganizationDependabotSecret]":
        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationDependabotSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrganizationDependabotSecret]":
        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationDependabotSecret,
        )

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgDependabotSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[str]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgDependabotSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgDependabotSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[str]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgDependabotSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        manifest: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = 30,
        last: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DependabotAlert]]":
        url = f"/repos/{owner}/{repo}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "manifest": manifest,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DependabotAlert],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        manifest: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = 30,
        last: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DependabotAlert]]":
        url = f"/repos/{owner}/{repo}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "manifest": manifest,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DependabotAlert],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DependabotAlert]":
        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotAlert,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DependabotAlert]":
        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotAlert,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType,
    ) -> "Response[DependabotAlert]":
        ...

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal["dismissed", "open"],
        dismissed_reason: Missing[
            Literal[
                "fix_started",
                "inaccurate",
                "no_bandwidth",
                "not_used",
                "tolerable_risk",
            ]
        ] = UNSET,
        dismissed_comment: Missing[str] = UNSET,
    ) -> "Response[DependabotAlert]":
        ...

    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[DependabotAlert]":
        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDependabotAlertsAlertNumberPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DependabotAlert,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType,
    ) -> "Response[DependabotAlert]":
        ...

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal["dismissed", "open"],
        dismissed_reason: Missing[
            Literal[
                "fix_started",
                "inaccurate",
                "no_bandwidth",
                "not_used",
                "tolerable_risk",
            ]
        ] = UNSET,
        dismissed_comment: Missing[str] = UNSET,
    ) -> "Response[DependabotAlert]":
        ...

    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[DependabotAlert]":
        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDependabotAlertsAlertNumberPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DependabotAlert,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoDependabotSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoDependabotSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoDependabotSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoDependabotSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DependabotPublicKey]":
        url = f"/repos/{owner}/{repo}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DependabotPublicKey]":
        url = f"/repos/{owner}/{repo}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DependabotSecret]":
        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DependabotSecret]":
        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotSecret,
        )

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDependabotSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDependabotSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDependabotSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDependabotSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )
