"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Dict, List, Union, Literal, Optional, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Missing, exclude_unset

from .types import (
    UserCodespacesPostBodyOneof0Type,
    UserCodespacesPostBodyOneof1Type,
    OrgsOrgCodespacesBillingPutBodyType,
    ReposOwnerRepoCodespacesPostBodyType,
    UserCodespacesCodespaceNamePatchBodyType,
    UserCodespacesSecretsSecretNamePutBodyType,
    OrgsOrgCodespacesSecretsSecretNamePutBodyType,
    UserCodespacesCodespaceNamePublishPostBodyType,
    UserCodespacesPostBodyOneof1PropPullRequestType,
    OrgsOrgCodespacesBillingSelectedUsersPostBodyType,
    OrgsOrgCodespacesBillingSelectedUsersDeleteBodyType,
    ReposOwnerRepoPullsPullNumberCodespacesPostBodyType,
    ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType,
    UserCodespacesSecretsSecretNameRepositoriesPutBodyType,
    OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType,
)
from .models import (
    Codespace,
    BasicError,
    EmptyObject,
    ValidationError,
    CodespacesSecret,
    CodespacesOrgSecret,
    CodespacesPublicKey,
    RepoCodespacesSecret,
    CodespaceExportDetails,
    CodespacesUserPublicKey,
    CodespaceWithFullRepository,
    UserCodespacesGetResponse200,
    UserCodespacesPostBodyOneof0,
    UserCodespacesPostBodyOneof1,
    OrgsOrgCodespacesBillingPutBody,
    OrgsOrgCodespacesGetResponse200,
    ReposOwnerRepoCodespacesPostBody,
    UserCodespacesSecretsGetResponse200,
    UserCodespacesCodespaceNamePatchBody,
    OrgsOrgCodespacesSecretsGetResponse200,
    ReposOwnerRepoCodespacesGetResponse200,
    UserCodespacesSecretsSecretNamePutBody,
    OrgsOrgCodespacesSecretsSecretNamePutBody,
    ReposOwnerRepoCodespacesNewGetResponse200,
    UserCodespacesCodespaceNamePublishPostBody,
    OrgsOrgCodespacesBillingSelectedUsersPostBody,
    ReposOwnerRepoCodespacesSecretsGetResponse200,
    OrgsOrgMembersUsernameCodespacesGetResponse200,
    ReposOwnerRepoCodespacesMachinesGetResponse200,
    OrgsOrgCodespacesBillingSelectedUsersDeleteBody,
    ReposOwnerRepoPullsPullNumberCodespacesPostBody,
    ReposOwnerRepoCodespacesSecretsSecretNamePutBody,
    UserCodespacesCodespaceNameMachinesGetResponse200,
    AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    UserCodespacesSecretsSecretNameRepositoriesPutBody,
    ReposOwnerRepoCodespacesDevcontainersGetResponse200,
    OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody,
    EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
    UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
    OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class CodespacesClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_in_organization(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgCodespacesGetResponse200]":
        url = f"/orgs/{org}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_in_organization(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgCodespacesGetResponse200]":
        url = f"/orgs/{org}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_codespaces_billing(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgCodespacesBillingPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_codespaces_billing(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        visibility: Literal[
            "disabled",
            "selected_members",
            "all_members",
            "all_members_and_outside_collaborators",
        ],
        selected_usernames: Missing[List[str]] = UNSET,
    ) -> "Response":
        ...

    def set_codespaces_billing(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgCodespacesBillingPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/billing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesBillingPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    async def async_set_codespaces_billing(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgCodespacesBillingPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_codespaces_billing(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        visibility: Literal[
            "disabled",
            "selected_members",
            "all_members",
            "all_members_and_outside_collaborators",
        ],
        selected_usernames: Missing[List[str]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_codespaces_billing(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgCodespacesBillingPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/billing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesBillingPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    def set_codespaces_billing_users(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgCodespacesBillingSelectedUsersPostBodyType,
    ) -> "Response":
        ...

    @overload
    def set_codespaces_billing_users(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_usernames: List[str],
    ) -> "Response":
        ...

    def set_codespaces_billing_users(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgCodespacesBillingSelectedUsersPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/billing/selected_users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesBillingSelectedUsersPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    async def async_set_codespaces_billing_users(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgCodespacesBillingSelectedUsersPostBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_codespaces_billing_users(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_usernames: List[str],
    ) -> "Response":
        ...

    async def async_set_codespaces_billing_users(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgCodespacesBillingSelectedUsersPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/billing/selected_users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesBillingSelectedUsersPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    def delete_codespaces_billing_users(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgCodespacesBillingSelectedUsersDeleteBodyType,
    ) -> "Response":
        ...

    @overload
    def delete_codespaces_billing_users(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_usernames: List[str],
    ) -> "Response":
        ...

    def delete_codespaces_billing_users(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgCodespacesBillingSelectedUsersDeleteBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/billing/selected_users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesBillingSelectedUsersDeleteBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    async def async_delete_codespaces_billing_users(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgCodespacesBillingSelectedUsersDeleteBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_delete_codespaces_billing_users(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_usernames: List[str],
    ) -> "Response":
        ...

    async def async_delete_codespaces_billing_users(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgCodespacesBillingSelectedUsersDeleteBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/billing/selected_users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesBillingSelectedUsersDeleteBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgCodespacesSecretsGetResponse200]":
        url = f"/orgs/{org}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgCodespacesSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgCodespacesSecretsGetResponse200]":
        url = f"/orgs/{org}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgCodespacesSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespacesPublicKey]":
        url = f"/orgs/{org}/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespacesPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespacesPublicKey]":
        url = f"/orgs/{org}/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespacesPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespacesOrgSecret]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespacesOrgSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespacesOrgSecret]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespacesOrgSecret,
        )

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgCodespacesSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgCodespacesSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_codespaces_for_user_in_org(
        self,
        org: str,
        username: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgMembersUsernameCodespacesGetResponse200]":
        url = f"/orgs/{org}/members/{username}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgMembersUsernameCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_codespaces_for_user_in_org(
        self,
        org: str,
        username: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgMembersUsernameCodespacesGetResponse200]":
        url = f"/orgs/{org}/members/{username}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgMembersUsernameCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_from_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_from_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def stop_in_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Codespace]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_stop_in_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Codespace]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoCodespacesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoCodespacesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[ReposOwnerRepoCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        ...

    @overload
    def create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ref: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    def create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoCodespacesPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/codespaces"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoCodespacesPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[ReposOwnerRepoCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        ...

    @overload
    async def async_create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ref: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    async def async_create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoCodespacesPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/codespaces"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoCodespacesPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def list_devcontainers_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoCodespacesDevcontainersGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/devcontainers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoCodespacesDevcontainersGetResponse200,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_devcontainers_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoCodespacesDevcontainersGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/devcontainers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoCodespacesDevcontainersGetResponse200,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def repo_machines_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        location: Missing[str] = UNSET,
        client_ip: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoCodespacesMachinesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/machines"

        params = {
            "location": location,
            "client_ip": client_ip,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoCodespacesMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_repo_machines_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        location: Missing[str] = UNSET,
        client_ip: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoCodespacesMachinesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/machines"

        params = {
            "location": location,
            "client_ip": client_ip,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoCodespacesMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def pre_flight_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        client_ip: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoCodespacesNewGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/new"

        params = {
            "ref": ref,
            "client_ip": client_ip,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoCodespacesNewGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_pre_flight_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        client_ip: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoCodespacesNewGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/new"

        params = {
            "ref": ref,
            "client_ip": client_ip,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoCodespacesNewGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoCodespacesSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoCodespacesSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespacesPublicKey]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespacesPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespacesPublicKey]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespacesPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepoCodespacesSecret]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepoCodespacesSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepoCodespacesSecret]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepoCodespacesSecret,
        )

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        ...

    @overload
    def create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    def create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/codespaces"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoPullsPullNumberCodespacesPostBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        ...

    @overload
    async def async_create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    async def async_create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/codespaces"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoPullsPullNumberCodespacesPostBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        repository_id: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserCodespacesGetResponse200]":
        url = "/user/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_id": repository_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        repository_id: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserCodespacesGetResponse200]":
        url = "/user/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_id": repository_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type],
    ) -> "Response[Codespace]":
        ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        repository_id: int,
        ref: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        pull_request: UserCodespacesPostBodyOneof1PropPullRequestType,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = "/user/codespaces"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[UserCodespacesPostBodyOneof0, UserCodespacesPostBodyOneof1], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type],
    ) -> "Response[Codespace]":
        ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        repository_id: int,
        ref: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        pull_request: UserCodespacesPostBodyOneof1PropPullRequestType,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = "/user/codespaces"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[UserCodespacesPostBodyOneof0, UserCodespacesPostBodyOneof1], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def list_secrets_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserCodespacesSecretsGetResponse200]":
        url = "/user/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserCodespacesSecretsGetResponse200,
        )

    async def async_list_secrets_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserCodespacesSecretsGetResponse200]":
        url = "/user/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserCodespacesSecretsGetResponse200,
        )

    def get_public_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespacesUserPublicKey]":
        url = "/user/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespacesUserPublicKey,
        )

    async def async_get_public_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespacesUserPublicKey]":
        url = "/user/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespacesUserPublicKey,
        )

    def get_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespacesSecret]":
        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespacesSecret,
        )

    async def async_get_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespacesSecret]":
        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespacesSecret,
        )

    @overload
    def create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserCodespacesSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: str,
        selected_repository_ids: Missing[List[Union[int, str]]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserCodespacesSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: str,
        selected_repository_ids: Missing[List[Union[int, str]]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def delete_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserCodespacesSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserCodespacesSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserCodespacesSecretsSecretNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserCodespacesSecretsSecretNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def add_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_add_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def remove_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_remove_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/user/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/user/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserCodespacesCodespaceNamePatchBodyType] = UNSET,
    ) -> "Response[Codespace]":
        ...

    @overload
    def update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        machine: Missing[str] = UNSET,
        display_name: Missing[str] = UNSET,
        recent_folders: Missing[List[str]] = UNSET,
    ) -> "Response[Codespace]":
        ...

    def update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserCodespacesCodespaceNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesCodespaceNamePatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserCodespacesCodespaceNamePatchBodyType] = UNSET,
    ) -> "Response[Codespace]":
        ...

    @overload
    async def async_update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        machine: Missing[str] = UNSET,
        display_name: Missing[str] = UNSET,
        recent_folders: Missing[List[str]] = UNSET,
    ) -> "Response[Codespace]":
        ...

    async def async_update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserCodespacesCodespaceNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesCodespaceNamePatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def export_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=CodespaceExportDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_export_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=CodespaceExportDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_export_details_for_authenticated_user(
        self,
        codespace_name: str,
        export_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports/{export_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespaceExportDetails,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_export_details_for_authenticated_user(
        self,
        codespace_name: str,
        export_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports/{export_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodespaceExportDetails,
            error_models={
                "404": BasicError,
            },
        )

    def codespace_machines_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserCodespacesCodespaceNameMachinesGetResponse200]":
        url = f"/user/codespaces/{codespace_name}/machines"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=UserCodespacesCodespaceNameMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_codespace_machines_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserCodespacesCodespaceNameMachinesGetResponse200]":
        url = f"/user/codespaces/{codespace_name}/machines"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=UserCodespacesCodespaceNameMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserCodespacesCodespaceNamePublishPostBodyType,
    ) -> "Response[CodespaceWithFullRepository]":
        ...

    @overload
    def publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        private: Missing[bool] = False,
    ) -> "Response[CodespaceWithFullRepository]":
        ...

    def publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserCodespacesCodespaceNamePublishPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[CodespaceWithFullRepository]":
        url = f"/user/codespaces/{codespace_name}/publish"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesCodespaceNamePublishPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodespaceWithFullRepository,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserCodespacesCodespaceNamePublishPostBodyType,
    ) -> "Response[CodespaceWithFullRepository]":
        ...

    @overload
    async def async_publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        private: Missing[bool] = False,
    ) -> "Response[CodespaceWithFullRepository]":
        ...

    async def async_publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserCodespacesCodespaceNamePublishPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[CodespaceWithFullRepository]":
        url = f"/user/codespaces/{codespace_name}/publish"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesCodespaceNamePublishPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodespaceWithFullRepository,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def start_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/start"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "402": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_start_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/start"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "402": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def stop_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/stop"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_stop_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/stop"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )
