"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Missing, exclude_unset

from .models import MarkdownPostBody
from .types import MarkdownPostBodyType

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class MarkdownClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    @overload
    def render(
        self, *, headers: Optional[Dict[str, str]] = None, data: MarkdownPostBodyType
    ) -> "Response[str]":
        ...

    @overload
    def render(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        text: str,
        mode: Missing[Literal["markdown", "gfm"]] = "markdown",
        context: Missing[str] = UNSET,
    ) -> "Response[str]":
        ...

    def render(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[MarkdownPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[str]":
        url = "/markdown"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(MarkdownPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=str,
        )

    @overload
    async def async_render(
        self, *, headers: Optional[Dict[str, str]] = None, data: MarkdownPostBodyType
    ) -> "Response[str]":
        ...

    @overload
    async def async_render(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        text: str,
        mode: Missing[Literal["markdown", "gfm"]] = "markdown",
        context: Missing[str] = UNSET,
    ) -> "Response[str]":
        ...

    async def async_render(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[MarkdownPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[str]":
        url = "/markdown"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(MarkdownPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=str,
        )

    def render_raw(
        self, *, headers: Optional[Dict[str, str]] = None, data: str, **kwargs
    ) -> "Response[str]":
        url = "/markdown/raw"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = parse_obj_as(str, content)
        content = (
            content.dict(by_alias=True) if isinstance(content, BaseModel) else content
        )

        return self._github.request(
            "POST",
            url,
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            response_model=str,
        )

    async def async_render_raw(
        self, *, headers: Optional[Dict[str, str]] = None, data: str, **kwargs
    ) -> "Response[str]":
        url = "/markdown/raw"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = parse_obj_as(str, content)
        content = (
            content.dict(by_alias=True) if isinstance(content, BaseModel) else content
        )

        return await self._github.arequest(
            "POST",
            url,
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            response_model=str,
        )
