"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, Dict, List, Union, Literal, Optional, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.typing import FileTypes
from githubkit.utils import UNSET, Missing, exclude_unset

from .types import (
    UserReposPostBodyType,
    OrgRulesetConditionsType,
    OrgsOrgReposPostBodyType,
    RepositoryRuleUpdateType,
    RepositoryRuleCreationType,
    RepositoryRuleDeletionType,
    OrgsOrgRulesetsPostBodyType,
    ReposOwnerRepoPatchBodyType,
    RepositoryRulePullRequestType,
    ReposOwnerRepoKeysPostBodyType,
    RepositoryRulesetConditionsType,
    ReposOwnerRepoForksPostBodyType,
    ReposOwnerRepoHooksPostBodyType,
    ReposOwnerRepoTopicsPutBodyType,
    RepositoryRuleNonFastForwardType,
    RepositoryRulesetBypassActorType,
    RepositoryRuleTagNamePatternType,
    ReposOwnerRepoMergesPostBodyType,
    DeploymentBranchPolicySettingsType,
    ReposOwnerRepoReleasesPostBodyType,
    ReposOwnerRepoRulesetsPostBodyType,
    ReposOwnerRepoTransferPostBodyType,
    OrgsOrgRulesetsRulesetIdPutBodyType,
    RepositoryRuleBranchNamePatternType,
    ReposOwnerRepoAutolinksPostBodyType,
    RepositoryRuleRequiredSignaturesType,
    ReposOwnerRepoDispatchesPostBodyType,
    ReposOwnerRepoPagesPutBodyAnyof0Type,
    ReposOwnerRepoPagesPutBodyAnyof1Type,
    ReposOwnerRepoPagesPutBodyAnyof2Type,
    ReposOwnerRepoPagesPutBodyAnyof3Type,
    ReposOwnerRepoPagesPutBodyAnyof4Type,
    DeploymentBranchPolicyNamePatternType,
    RepositoryRuleRequiredDeploymentsType,
    ReposOwnerRepoContentsPathPutBodyType,
    ReposOwnerRepoDeploymentsPostBodyType,
    ReposOwnerRepoPagesPostBodyAnyof0Type,
    ReposOwnerRepoPagesPostBodyAnyof1Type,
    ReposOwnerRepoStatusesShaPostBodyType,
    RepositoryRuleCommitMessagePatternType,
    RepositoryRuleRequiredStatusChecksType,
    ReposOwnerRepoHooksHookIdPatchBodyType,
    RepositoryRuleCommitterEmailPatternType,
    RepositoryRuleRequiredLinearHistoryType,
    ReposOwnerRepoMergeUpstreamPostBodyType,
    ReposOwnerRepoContentsPathDeleteBodyType,
    ReposOwnerRepoTagsProtectionPostBodyType,
    ReposOwnerRepoHooksPostBodyPropConfigType,
    ReposOwnerRepoPagesDeploymentPostBodyType,
    ReposOwnerRepoPagesPostBodyPropSourceType,
    RepositoryRuleCommitAuthorEmailPatternType,
    ReposOwnerRepoRulesetsRulesetIdPutBodyType,
    ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ReposOwnerRepoHooksHookIdConfigPatchBodyType,
    ReposOwnerRepoReleasesReleaseIdPatchBodyType,
    ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ReposOwnerRepoCollaboratorsUsernamePutBodyType,
    ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
    ReposOwnerRepoContentsPathPutBodyPropAuthorType,
    ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ReposOwnerRepoHooksHookIdPatchBodyPropConfigType,
    ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType,
    ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ReposOwnerRepoContentsPathDeleteBodyPropAuthorType,
    ReposOwnerRepoContentsPathPutBodyPropCommitterType,
    ReposOwnerRepoInvitationsInvitationIdPatchBodyType,
    ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType,
    ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType,
    ReposOwnerRepoContentsPathDeleteBodyPropCommitterType,
    ReposOwnerRepoDispatchesPostBodyPropClientPayloadType,
    ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type,
    ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType,
    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType,
    ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
    ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
)
from .models import (
    Tag,
    Hook,
    Page,
    Team,
    Topic,
    Commit,
    Status,
    Release,
    Autolink,
    Language,
    DeployKey,
    PageBuild,
    BasicError,
    Deployment,
    FileCommit,
    Repository,
    SimpleUser,
    BranchShort,
    ContentFile,
    Contributor,
    Environment,
    Integration,
    ShortBranch,
    ViewTraffic,
    CloneTraffic,
    Collaborator,
    HookDelivery,
    ReleaseAsset,
    CommitComment,
    TagProtection,
    WebhookConfig,
    CommitActivity,
    ContentSymlink,
    ContentTraffic,
    FullRepository,
    MergedUpstream,
    PageDeployment,
    PageBuildStatus,
    ProtectedBranch,
    ReferrerTraffic,
    ValidationError,
    BranchProtection,
    CodeownersErrors,
    CommitComparison,
    CommunityProfile,
    ContentSubmodule,
    DeploymentStatus,
    HookDeliveryItem,
    PagesHealthCheck,
    MinimalRepository,
    PullRequestSimple,
    RepositoryRuleset,
    StatusCheckPolicy,
    UserReposPostBody,
    ParticipationStats,
    ContributorActivity,
    ReleaseNotesContent,
    BranchWithProtection,
    CombinedCommitStatus,
    OrgsOrgReposPostBody,
    RepositoryInvitation,
    RepositoryRuleUpdate,
    ContentDirectoryItems,
    ValidationErrorSimple,
    DeploymentBranchPolicy,
    RepositoryRuleCreation,
    RepositoryRuleDeletion,
    BranchRestrictionPolicy,
    OrgsOrgRulesetsPostBody,
    ReposOwnerRepoPatchBody,
    DeploymentProtectionRule,
    RepositoryRulePullRequest,
    ReposOwnerRepoKeysPostBody,
    ReposOwnerRepoForksPostBody,
    ReposOwnerRepoHooksPostBody,
    ReposOwnerRepoTopicsPutBody,
    ProtectedBranchAdminEnforced,
    RepositoryRuleNonFastForward,
    RepositoryRuleTagNamePattern,
    ReposOwnerRepoMergesPostBody,
    ReposOwnerRepoReleasesPostBody,
    ReposOwnerRepoRulesetsPostBody,
    ReposOwnerRepoTransferPostBody,
    OrgsOrgRulesetsRulesetIdPutBody,
    RepositoryRuleBranchNamePattern,
    ReposOwnerRepoAutolinksPostBody,
    ReposOwnerRepoDeleteResponse403,
    ProtectedBranchPullRequestReview,
    RepositoryCollaboratorPermission,
    RepositoryRuleRequiredSignatures,
    ReposOwnerRepoDispatchesPostBody,
    ReposOwnerRepoPagesPutBodyAnyof0,
    ReposOwnerRepoPagesPutBodyAnyof1,
    ReposOwnerRepoPagesPutBodyAnyof2,
    ReposOwnerRepoPagesPutBodyAnyof3,
    ReposOwnerRepoPagesPutBodyAnyof4,
    DeploymentBranchPolicyNamePattern,
    RepositoryRuleRequiredDeployments,
    ReposOwnerRepoContentsPathPutBody,
    ReposOwnerRepoDeploymentsPostBody,
    ReposOwnerRepoPagesPostBodyAnyof0,
    ReposOwnerRepoPagesPostBodyAnyof1,
    ReposOwnerRepoStatusesShaPostBody,
    RepositoryRuleCommitMessagePattern,
    RepositoryRuleRequiredStatusChecks,
    ReposOwnerRepoHooksHookIdPatchBody,
    RepositoryRuleCommitterEmailPattern,
    RepositoryRuleRequiredLinearHistory,
    ReposOwnerRepoMergeUpstreamPostBody,
    ReposOwnerRepoContentsPathDeleteBody,
    ReposOwnerRepoTagsProtectionPostBody,
    ReposOwnerRepoPagesDeploymentPostBody,
    RepositoryRuleCommitAuthorEmailPattern,
    ReposOwnerRepoRulesetsRulesetIdPutBody,
    ReposOwnerRepoCommentsCommentIdPatchBody,
    ReposOwnerRepoEnvironmentsGetResponse200,
    ReposOwnerRepoHooksHookIdConfigPatchBody,
    ReposOwnerRepoReleasesReleaseIdPatchBody,
    ReposOwnerRepoBranchesBranchRenamePostBody,
    ReposOwnerRepoCollaboratorsUsernamePutBody,
    ReposOwnerRepoReleasesGenerateNotesPostBody,
    ReposOwnerRepoReleasesAssetsAssetIdPatchBody,
    ReposOwnerRepoBranchesBranchProtectionPutBody,
    ReposOwnerRepoCommitsCommitShaCommentsPostBody,
    ReposOwnerRepoInvitationsInvitationIdPatchBody,
    ReposTemplateOwnerTemplateRepoGeneratePostBody,
    ReposOwnerRepoEnvironmentsEnvironmentNamePutBody,
    AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody,
    EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
    ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
    ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
    ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
    ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class ReposClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_for_org(
        self,
        org: str,
        type: Missing[
            Literal["all", "public", "private", "forks", "sources", "member"]
        ] = "all",
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    async def async_list_for_org(
        self,
        org: str,
        type: Missing[
            Literal["all", "public", "private", "forks", "sources", "member"]
        ] = "all",
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    @overload
    def create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgReposPostBodyType,
    ) -> "Response[Repository]":
        ...

    @overload
    def create_in_org(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = False,
        visibility: Missing[Literal["public", "private"]] = UNSET,
        has_issues: Missing[bool] = True,
        has_projects: Missing[bool] = True,
        has_wiki: Missing[bool] = True,
        has_downloads: Missing[bool] = True,
        is_template: Missing[bool] = False,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = False,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = True,
        allow_merge_commit: Missing[bool] = True,
        allow_rebase_merge: Missing[bool] = True,
        allow_auto_merge: Missing[bool] = False,
        delete_branch_on_merge: Missing[bool] = False,
        use_squash_pr_title_as_default: Missing[bool] = False,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
    ) -> "Response[Repository]":
        ...

    def create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgReposPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Repository]":
        url = f"/orgs/{org}/repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgReposPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Repository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgReposPostBodyType,
    ) -> "Response[Repository]":
        ...

    @overload
    async def async_create_in_org(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = False,
        visibility: Missing[Literal["public", "private"]] = UNSET,
        has_issues: Missing[bool] = True,
        has_projects: Missing[bool] = True,
        has_wiki: Missing[bool] = True,
        has_downloads: Missing[bool] = True,
        is_template: Missing[bool] = False,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = False,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = True,
        allow_merge_commit: Missing[bool] = True,
        allow_rebase_merge: Missing[bool] = True,
        allow_auto_merge: Missing[bool] = False,
        delete_branch_on_merge: Missing[bool] = False,
        use_squash_pr_title_as_default: Missing[bool] = False,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
    ) -> "Response[Repository]":
        ...

    async def async_create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgReposPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Repository]":
        url = f"/orgs/{org}/repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgReposPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Repository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get_org_rulesets(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RepositoryRuleset]]":
        url = f"/orgs/{org}/rulesets"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_rulesets(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RepositoryRuleset]]":
        url = f"/orgs/{org}/rulesets"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgRulesetsPostBodyType,
    ) -> "Response[RepositoryRuleset]":
        ...

    @overload
    def create_org_ruleset(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[OrgRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                ]
            ]
        ] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    def create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryRuleset]":
        url = f"/orgs/{org}/rulesets"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgRulesetsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgRulesetsPostBodyType,
    ) -> "Response[RepositoryRuleset]":
        ...

    @overload
    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[OrgRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                ]
            ]
        ] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryRuleset]":
        url = f"/orgs/{org}/rulesets"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgRulesetsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepositoryRuleset]":
        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepositoryRuleset]":
        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    @overload
    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[OrgRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                ]
            ]
        ] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryRuleset]":
        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgRulesetsRulesetIdPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    @overload
    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[OrgRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                ]
            ]
        ] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryRuleset]":
        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgRulesetsRulesetIdPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def delete_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
            },
        )

    async def async_delete(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = False,
        visibility: Missing[Literal["public", "private"]] = UNSET,
        security_and_analysis: Missing[
            Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Missing[bool] = True,
        has_projects: Missing[bool] = True,
        has_wiki: Missing[bool] = True,
        is_template: Missing[bool] = False,
        default_branch: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = True,
        allow_merge_commit: Missing[bool] = True,
        allow_rebase_merge: Missing[bool] = True,
        allow_auto_merge: Missing[bool] = False,
        delete_branch_on_merge: Missing[bool] = False,
        allow_update_branch: Missing[bool] = False,
        use_squash_pr_title_as_default: Missing[bool] = False,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        archived: Missing[bool] = False,
        allow_forking: Missing[bool] = False,
        web_commit_signoff_required: Missing[bool] = False,
    ) -> "Response[FullRepository]":
        ...

    def update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = False,
        visibility: Missing[Literal["public", "private"]] = UNSET,
        security_and_analysis: Missing[
            Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Missing[bool] = True,
        has_projects: Missing[bool] = True,
        has_wiki: Missing[bool] = True,
        is_template: Missing[bool] = False,
        default_branch: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = True,
        allow_merge_commit: Missing[bool] = True,
        allow_rebase_merge: Missing[bool] = True,
        allow_auto_merge: Missing[bool] = False,
        delete_branch_on_merge: Missing[bool] = False,
        allow_update_branch: Missing[bool] = False,
        use_squash_pr_title_as_default: Missing[bool] = False,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        archived: Missing[bool] = False,
        allow_forking: Missing[bool] = False,
        web_commit_signoff_required: Missing[bool] = False,
    ) -> "Response[FullRepository]":
        ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_autolinks(
        self,
        owner: str,
        repo: str,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Autolink]]":
        url = f"/repos/{owner}/{repo}/autolinks"

        params = {
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Autolink],
        )

    async def async_list_autolinks(
        self,
        owner: str,
        repo: str,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Autolink]]":
        url = f"/repos/{owner}/{repo}/autolinks"

        params = {
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Autolink],
        )

    @overload
    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoAutolinksPostBodyType,
    ) -> "Response[Autolink]":
        ...

    @overload
    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        key_prefix: str,
        url_template: str,
        is_alphanumeric: Missing[bool] = True,
    ) -> "Response[Autolink]":
        ...

    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoAutolinksPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoAutolinksPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoAutolinksPostBodyType,
    ) -> "Response[Autolink]":
        ...

    @overload
    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        key_prefix: str,
        url_template: str,
        is_alphanumeric: Missing[bool] = True,
    ) -> "Response[Autolink]":
        ...

    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoAutolinksPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoAutolinksPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    def get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    def delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_branches(
        self,
        owner: str,
        repo: str,
        protected: Missing[bool] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ShortBranch]]":
        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_branches(
        self,
        owner: str,
        repo: str,
        protected: Missing[bool] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ShortBranch]]":
        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    def get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    def get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[BranchProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[BranchProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ) -> "Response[ProtectedBranch]":
        ...

    @overload
    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Missing[bool] = UNSET,
        allow_force_pushes: Missing[Union[bool, None]] = UNSET,
        allow_deletions: Missing[bool] = UNSET,
        block_creations: Missing[bool] = UNSET,
        required_conversation_resolution: Missing[bool] = UNSET,
        lock_branch: Missing[bool] = False,
        allow_fork_syncing: Missing[bool] = False,
    ) -> "Response[ProtectedBranch]":
        ...

    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchProtectionPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProtectedBranch]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoBranchesBranchProtectionPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ) -> "Response[ProtectedBranch]":
        ...

    @overload
    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Missing[bool] = UNSET,
        allow_force_pushes: Missing[Union[bool, None]] = UNSET,
        allow_deletions: Missing[bool] = UNSET,
        block_creations: Missing[bool] = UNSET,
        required_conversation_resolution: Missing[bool] = UNSET,
        lock_branch: Missing[bool] = False,
        allow_fork_syncing: Missing[bool] = False,
    ) -> "Response[ProtectedBranch]":
        ...

    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchProtectionPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProtectedBranch]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoBranchesBranchProtectionPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    def set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    def delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
        )

    async def async_get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
        )

    def delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        ...

    @overload
    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        dismissal_restrictions: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType
        ] = UNSET,
        dismiss_stale_reviews: Missing[bool] = UNSET,
        require_code_owner_reviews: Missing[bool] = UNSET,
        required_approving_review_count: Missing[int] = UNSET,
        require_last_push_approval: Missing[bool] = False,
        bypass_pull_request_allowances: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType
        ] = UNSET,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        ...

    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        ...

    @overload
    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        dismissal_restrictions: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType
        ] = UNSET,
        dismiss_stale_reviews: Missing[bool] = UNSET,
        require_code_owner_reviews: Missing[bool] = UNSET,
        required_approving_review_count: Missing[int] = UNSET,
        require_last_push_approval: Missing[bool] = False,
        bypass_pull_request_allowances: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType
        ] = UNSET,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        ...

    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    def get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
    ) -> "Response[StatusCheckPolicy]":
        ...

    @overload
    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        strict: Missing[bool] = UNSET,
        contexts: Missing[List[str]] = UNSET,
        checks: Missing[
            List[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ]
        ] = UNSET,
    ) -> "Response[StatusCheckPolicy]":
        ...

    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
    ) -> "Response[StatusCheckPolicy]":
        ...

    @overload
    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        strict: Missing[bool] = UNSET,
        contexts: Missing[List[str]] = UNSET,
        checks: Missing[
            List[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ]
        ] = UNSET,
    ) -> "Response[StatusCheckPolicy]":
        ...

    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[BranchRestrictionPolicy]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[BranchRestrictionPolicy]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Integration],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Integration],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    def get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    def get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ) -> "Response[BranchWithProtection]":
        ...

    @overload
    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        new_name: str,
    ) -> "Response[BranchWithProtection]":
        ...

    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchRenamePostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoBranchesBranchRenamePostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ) -> "Response[BranchWithProtection]":
        ...

    @overload
    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        new_name: str,
    ) -> "Response[BranchWithProtection]":
        ...

    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchRenamePostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoBranchesBranchRenamePostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def codeowners_errors(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodeownersErrors]":
        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CodeownersErrors,
            error_models={},
        )

    async def async_codeowners_errors(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CodeownersErrors]":
        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CodeownersErrors,
            error_models={},
        )

    def list_collaborators(
        self,
        owner: str,
        repo: str,
        affiliation: Missing[Literal["outside", "direct", "all"]] = "all",
        permission: Missing[
            Literal["pull", "triage", "push", "maintain", "admin"]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Collaborator]]":
        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "permission": permission,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_collaborators(
        self,
        owner: str,
        repo: str,
        affiliation: Missing[Literal["outside", "direct", "all"]] = "all",
        permission: Missing[
            Literal["pull", "triage", "push", "maintain", "admin"]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Collaborator]]":
        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "permission": permission,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    def check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    @overload
    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[str] = "push",
    ) -> "Response[RepositoryInvitation]":
        ...

    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCollaboratorsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    @overload
    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[str] = "push",
    ) -> "Response[RepositoryInvitation]":
        ...

    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCollaboratorsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepositoryCollaboratorPermission]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepositoryCollaboratorPermission]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[CommitComment],
        )

    async def async_list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[CommitComment],
        )

    def get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ) -> "Response[CommitComment]":
        ...

    @overload
    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> "Response[CommitComment]":
        ...

    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCommentsCommentIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ) -> "Response[CommitComment]":
        ...

    @overload
    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> "Response[CommitComment]":
        ...

    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCommentsCommentIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        sha: Missing[str] = UNSET,
        path: Missing[str] = UNSET,
        author: Missing[str] = UNSET,
        committer: Missing[str] = UNSET,
        since: Missing[datetime] = UNSET,
        until: Missing[datetime] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Commit]]":
        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "committer": committer,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        sha: Missing[str] = UNSET,
        path: Missing[str] = UNSET,
        author: Missing[str] = UNSET,
        committer: Missing[str] = UNSET,
        since: Missing[datetime] = UNSET,
        until: Missing[datetime] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Commit]]":
        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "committer": committer,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[BranchShort]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[BranchShort],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[BranchShort]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[BranchShort],
            error_models={
                "422": ValidationError,
            },
        )

    def list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[CommitComment],
        )

    async def async_list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[CommitComment],
        )

    @overload
    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ) -> "Response[CommitComment]":
        ...

    @overload
    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
        path: Missing[str] = UNSET,
        position: Missing[int] = UNSET,
        line: Missing[int] = UNSET,
    ) -> "Response[CommitComment]":
        ...

    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommitsCommitShaCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCommitsCommitShaCommentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ) -> "Response[CommitComment]":
        ...

    @overload
    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
        path: Missing[str] = UNSET,
        position: Missing[int] = UNSET,
        line: Missing[int] = UNSET,
    ) -> "Response[CommitComment]":
        ...

    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommitsCommitShaCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCommitsCommitShaCommentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PullRequestSimple]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestSimple],
        )

    async def async_list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PullRequestSimple]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestSimple],
        )

    def get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    async def async_get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CombinedCommitStatus]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CombinedCommitStatus]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Status]]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Status],
        )

    async def async_list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Status]]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Status],
        )

    def get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CommunityProfile]":
        url = f"/repos/{owner}/{repo}/community/profile"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommunityProfile,
        )

    async def async_get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CommunityProfile]":
        url = f"/repos/{owner}/{repo}/community/profile"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommunityProfile,
        )

    def compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CommitComparison]":
        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CommitComparison,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    async def async_compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CommitComparison]":
        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CommitComparison,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Union[List[ContentDirectoryItems], ContentFile, ContentSymlink, ContentSubmodule]]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Union[
                List[ContentDirectoryItems],
                ContentFile,
                ContentSymlink,
                ContentSubmodule,
            ],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Union[List[ContentDirectoryItems], ContentFile, ContentSymlink, ContentSubmodule]]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Union[
                List[ContentDirectoryItems],
                ContentFile,
                ContentSymlink,
                ContentSubmodule,
            ],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoContentsPathPutBodyType,
    ) -> "Response[FileCommit]":
        ...

    @overload
    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        content: str,
        sha: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        committer: Missing[ReposOwnerRepoContentsPathPutBodyPropCommitterType] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> "Response[FileCommit]":
        ...

    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoContentsPathPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoContentsPathPutBodyType,
    ) -> "Response[FileCommit]":
        ...

    @overload
    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        content: str,
        sha: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        committer: Missing[ReposOwnerRepoContentsPathPutBodyPropCommitterType] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> "Response[FileCommit]":
        ...

    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoContentsPathPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoContentsPathDeleteBodyType,
    ) -> "Response[FileCommit]":
        ...

    @overload
    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        sha: str,
        branch: Missing[str] = UNSET,
        committer: Missing[
            ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathDeleteBodyPropAuthorType] = UNSET,
    ) -> "Response[FileCommit]":
        ...

    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathDeleteBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoContentsPathDeleteBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoContentsPathDeleteBodyType,
    ) -> "Response[FileCommit]":
        ...

    @overload
    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        sha: str,
        branch: Missing[str] = UNSET,
        committer: Missing[
            ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathDeleteBodyPropAuthorType] = UNSET,
    ) -> "Response[FileCommit]":
        ...

    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathDeleteBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoContentsPathDeleteBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def list_contributors(
        self,
        owner: str,
        repo: str,
        anon: Missing[str] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Contributor]]":
        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_contributors(
        self,
        owner: str,
        repo: str,
        anon: Missing[str] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Contributor]]":
        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_deployments(
        self,
        owner: str,
        repo: str,
        sha: Missing[str] = "none",
        ref: Missing[str] = "none",
        task: Missing[str] = "none",
        environment: Missing[Union[str, None]] = "none",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Deployment],
        )

    async def async_list_deployments(
        self,
        owner: str,
        repo: str,
        sha: Missing[str] = "none",
        ref: Missing[str] = "none",
        task: Missing[str] = "none",
        environment: Missing[Union[str, None]] = "none",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Deployment],
        )

    @overload
    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDeploymentsPostBodyType,
    ) -> "Response[Deployment]":
        ...

    @overload
    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ref: str,
        task: Missing[str] = "deploy",
        auto_merge: Missing[bool] = True,
        required_contexts: Missing[List[str]] = UNSET,
        payload: Missing[
            Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Missing[str] = "production",
        description: Missing[Union[str, None]] = "",
        transient_environment: Missing[bool] = False,
        production_environment: Missing[bool] = UNSET,
    ) -> "Response[Deployment]":
        ...

    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDeploymentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDeploymentsPostBodyType,
    ) -> "Response[Deployment]":
        ...

    @overload
    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ref: str,
        task: Missing[str] = "deploy",
        auto_merge: Missing[bool] = True,
        required_contexts: Missing[List[str]] = UNSET,
        payload: Missing[
            Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Missing[str] = "production",
        description: Missing[Union[str, None]] = "",
        transient_environment: Missing[bool] = False,
        production_environment: Missing[bool] = UNSET,
    ) -> "Response[Deployment]":
        ...

    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDeploymentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DeploymentStatus]]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DeploymentStatus]]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ) -> "Response[DeploymentStatus]":
        ...

    @overload
    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Missing[str] = "",
        log_url: Missing[str] = "",
        description: Missing[str] = "",
        environment: Missing[Literal["production", "staging", "qa"]] = UNSET,
        environment_url: Missing[str] = "",
        auto_inactive: Missing[bool] = UNSET,
    ) -> "Response[DeploymentStatus]":
        ...

    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ) -> "Response[DeploymentStatus]":
        ...

    @overload
    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Missing[str] = "",
        log_url: Missing[str] = "",
        description: Missing[str] = "",
        environment: Missing[Literal["production", "staging", "qa"]] = UNSET,
        environment_url: Missing[str] = "",
        auto_inactive: Missing[bool] = UNSET,
    ) -> "Response[DeploymentStatus]":
        ...

    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDispatchesPostBodyType,
    ) -> "Response":
        ...

    @overload
    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        event_type: str,
        client_payload: Missing[
            ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> "Response":
        ...

    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDispatchesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/dispatches"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDispatchesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDispatchesPostBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        event_type: str,
        client_payload: Missing[
            ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> "Response":
        ...

    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDispatchesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/dispatches"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDispatchesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    def get_all_environments(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoEnvironmentsGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    async def async_get_all_environments(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoEnvironmentsGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    def get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Environment,
        )

    async def async_get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Environment,
        )

    @overload
    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> "Response[Environment]":
        ...

    @overload
    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        wait_timer: Missing[int] = UNSET,
        reviewers: Missing[
            Union[
                List[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ]
        ] = UNSET,
        deployment_branch_policy: Missing[
            Union[DeploymentBranchPolicySettingsType, None]
        ] = UNSET,
    ) -> "Response[Environment]":
        ...

    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    @overload
    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> "Response[Environment]":
        ...

    @overload
    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        wait_timer: Missing[int] = UNSET,
        reviewers: Missing[
            Union[
                List[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ]
        ] = UNSET,
        deployment_branch_policy: Missing[
            Union[DeploymentBranchPolicySettingsType, None]
        ] = UNSET,
    ) -> "Response[Environment]":
        ...

    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    def delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_deployment_branch_policies(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

    async def async_list_deployment_branch_policies(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

    @overload
    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    @overload
    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(DeploymentBranchPolicyNamePattern, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
            error_models={},
        )

    @overload
    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    @overload
    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(DeploymentBranchPolicyNamePattern, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
            error_models={},
        )

    def get_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    async def async_get_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    @overload
    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    @overload
    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(DeploymentBranchPolicyNamePattern, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    @overload
    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    @overload
    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(DeploymentBranchPolicyNamePattern, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    def delete_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_all_deployment_protection_rules(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

    async def async_get_all_deployment_protection_rules(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

    @overload
    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
    ) -> "Response[DeploymentProtectionRule]":
        ...

    @overload
    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        integration_id: Missing[int] = UNSET,
    ) -> "Response[DeploymentProtectionRule]":
        ...

    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentProtectionRule]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    @overload
    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
    ) -> "Response[DeploymentProtectionRule]":
        ...

    @overload
    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        integration_id: Missing[int] = UNSET,
    ) -> "Response[DeploymentProtectionRule]":
        ...

    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentProtectionRule]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    def list_custom_deployment_rule_integrations(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

    async def async_list_custom_deployment_rule_integrations(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

    def get_custom_deployment_protection_rule(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        protection_rule_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DeploymentProtectionRule]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    async def async_get_custom_deployment_protection_rule(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        protection_rule_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DeploymentProtectionRule]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    def disable_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        protection_rule_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        protection_rule_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_forks(
        self,
        owner: str,
        repo: str,
        sort: Missing[Literal["newest", "oldest", "stargazers", "watchers"]] = "newest",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    async def async_list_forks(
        self,
        owner: str,
        repo: str,
        sort: Missing[Literal["newest", "oldest", "stargazers", "watchers"]] = "newest",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    @overload
    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    @overload
    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        organization: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        default_branch_only: Missing[bool] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}/forks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoForksPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    @overload
    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        organization: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        default_branch_only: Missing[bool] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}/forks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoForksPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_webhooks(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Hook]]":
        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Hook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Hook]]":
        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Hook],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> "Response[Hook]":
        ...

    @overload
    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        config: Missing[ReposOwnerRepoHooksPostBodyPropConfigType] = UNSET,
        events: Missing[List[str]] = ["push"],
        active: Missing[bool] = True,
    ) -> "Response[Hook]":
        ...

    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoHooksPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> "Response[Hook]":
        ...

    @overload
    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        config: Missing[ReposOwnerRepoHooksPostBodyPropConfigType] = UNSET,
        events: Missing[List[str]] = ["push"],
        active: Missing[bool] = True,
    ) -> "Response[Hook]":
        ...

    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoHooksPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoHooksHookIdPatchBodyType,
    ) -> "Response[Hook]":
        ...

    @overload
    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        config: Missing[ReposOwnerRepoHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Missing[List[str]] = ["push"],
        add_events: Missing[List[str]] = UNSET,
        remove_events: Missing[List[str]] = UNSET,
        active: Missing[bool] = True,
    ) -> "Response[Hook]":
        ...

    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoHooksHookIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoHooksHookIdPatchBodyType,
    ) -> "Response[Hook]":
        ...

    @overload
    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        config: Missing[ReposOwnerRepoHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Missing[List[str]] = ["push"],
        add_events: Missing[List[str]] = UNSET,
        remove_events: Missing[List[str]] = UNSET,
        active: Missing[bool] = True,
    ) -> "Response[Hook]":
        ...

    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoHooksHookIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    @overload
    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoHooksHookIdConfigPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    @overload
    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoHooksHookIdConfigPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        per_page: Missing[int] = 30,
        cursor: Missing[str] = UNSET,
        redelivery: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[HookDeliveryItem]]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        per_page: Missing[int] = 30,
        cursor: Missing[str] = UNSET,
        redelivery: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[HookDeliveryItem]]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[HookDelivery]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[HookDelivery]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_invitations(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RepositoryInvitation]]":
        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryInvitation],
        )

    async def async_list_invitations(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RepositoryInvitation]]":
        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryInvitation],
        )

    def delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    @overload
    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permissions: Missing[
            Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoInvitationsInvitationIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
        )

    @overload
    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    @overload
    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permissions: Missing[
            Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoInvitationsInvitationIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
        )

    def list_deploy_keys(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DeployKey]]":
        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DeployKey],
        )

    async def async_list_deploy_keys(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DeployKey]]":
        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DeployKey],
        )

    @overload
    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoKeysPostBodyType,
    ) -> "Response[DeployKey]":
        ...

    @overload
    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
        read_only: Missing[bool] = UNSET,
    ) -> "Response[DeployKey]":
        ...

    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoKeysPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoKeysPostBodyType,
    ) -> "Response[DeployKey]":
        ...

    @overload
    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
        read_only: Missing[bool] = UNSET,
    ) -> "Response[DeployKey]":
        ...

    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoKeysPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_languages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Language]":
        url = f"/repos/{owner}/{repo}/languages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Language,
        )

    async def async_list_languages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Language]":
        url = f"/repos/{owner}/{repo}/languages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Language,
        )

    def enable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={},
        )

    async def async_enable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={},
        )

    def disable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoMergeUpstreamPostBodyType,
    ) -> "Response[MergedUpstream]":
        ...

    @overload
    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        branch: str,
    ) -> "Response[MergedUpstream]":
        ...

    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMergeUpstreamPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[MergedUpstream]":
        url = f"/repos/{owner}/{repo}/merge-upstream"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMergeUpstreamPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MergedUpstream,
            error_models={},
        )

    @overload
    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoMergeUpstreamPostBodyType,
    ) -> "Response[MergedUpstream]":
        ...

    @overload
    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        branch: str,
    ) -> "Response[MergedUpstream]":
        ...

    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMergeUpstreamPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[MergedUpstream]":
        url = f"/repos/{owner}/{repo}/merge-upstream"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMergeUpstreamPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MergedUpstream,
            error_models={},
        )

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoMergesPostBodyType,
    ) -> "Response[Commit]":
        ...

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        base: str,
        head: str,
        commit_message: Missing[str] = UNSET,
    ) -> "Response[Commit]":
        ...

    def merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMergesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/merges"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMergesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoMergesPostBodyType,
    ) -> "Response[Commit]":
        ...

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        base: str,
        head: str,
        commit_message: Missing[str] = UNSET,
    ) -> "Response[Commit]":
        ...

    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMergesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/merges"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMergesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get_pages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPutBodyAnyof0Type,
            ReposOwnerRepoPagesPutBodyAnyof1Type,
            ReposOwnerRepoPagesPutBodyAnyof2Type,
            ReposOwnerRepoPagesPutBodyAnyof3Type,
            ReposOwnerRepoPagesPutBodyAnyof4Type,
        ],
    ) -> "Response":
        ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ],
    ) -> "Response":
        ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Union[str, None],
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: bool,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> "Response":
        ...

    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0Type,
                ReposOwnerRepoPagesPutBodyAnyof1Type,
                ReposOwnerRepoPagesPutBodyAnyof2Type,
                ReposOwnerRepoPagesPutBodyAnyof3Type,
                ReposOwnerRepoPagesPutBodyAnyof4Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0,
                ReposOwnerRepoPagesPutBodyAnyof1,
                ReposOwnerRepoPagesPutBodyAnyof2,
                ReposOwnerRepoPagesPutBodyAnyof3,
                ReposOwnerRepoPagesPutBodyAnyof4,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "400": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPutBodyAnyof0Type,
            ReposOwnerRepoPagesPutBodyAnyof1Type,
            ReposOwnerRepoPagesPutBodyAnyof2Type,
            ReposOwnerRepoPagesPutBodyAnyof3Type,
            ReposOwnerRepoPagesPutBodyAnyof4Type,
        ],
    ) -> "Response":
        ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ],
    ) -> "Response":
        ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Union[str, None],
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: bool,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> "Response":
        ...

    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0Type,
                ReposOwnerRepoPagesPutBodyAnyof1Type,
                ReposOwnerRepoPagesPutBodyAnyof2Type,
                ReposOwnerRepoPagesPutBodyAnyof3Type,
                ReposOwnerRepoPagesPutBodyAnyof4Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0,
                ReposOwnerRepoPagesPutBodyAnyof1,
                ReposOwnerRepoPagesPutBodyAnyof2,
                ReposOwnerRepoPagesPutBodyAnyof3,
                ReposOwnerRepoPagesPutBodyAnyof4,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "400": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPostBodyAnyof0Type,
            None,
            ReposOwnerRepoPagesPostBodyAnyof1Type,
            None,
        ],
    ) -> "Response[Page]":
        ...

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: ReposOwnerRepoPagesPostBodyPropSourceType,
    ) -> "Response[Page]":
        ...

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        build_type: Literal["legacy", "workflow"],
        source: Missing[ReposOwnerRepoPagesPostBodyPropSourceType] = UNSET,
    ) -> "Response[Page]":
        ...

    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0Type,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1Type,
                None,
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1,
                None,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPostBodyAnyof0Type,
            None,
            ReposOwnerRepoPagesPostBodyAnyof1Type,
            None,
        ],
    ) -> "Response[Page]":
        ...

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: ReposOwnerRepoPagesPostBodyPropSourceType,
    ) -> "Response[Page]":
        ...

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        build_type: Literal["legacy", "workflow"],
        source: Missing[ReposOwnerRepoPagesPostBodyPropSourceType] = UNSET,
    ) -> "Response[Page]":
        ...

    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0Type,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1Type,
                None,
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1,
                None,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def delete_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_delete_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_pages_builds(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PageBuild]]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PageBuild],
        )

    async def async_list_pages_builds(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PageBuild]]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PageBuild],
        )

    def request_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PageBuildStatus]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuildStatus,
        )

    async def async_request_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PageBuildStatus]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuildStatus,
        )

    def get_latest_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    async def async_get_latest_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    def get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    async def async_get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    @overload
    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPagesDeploymentPostBodyType,
    ) -> "Response[PageDeployment]":
        ...

    @overload
    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        artifact_url: str,
        environment: Missing[str] = "github-pages",
        pages_build_version: str = "GITHUB_SHA",
        oidc_token: str,
    ) -> "Response[PageDeployment]":
        ...

    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPagesDeploymentPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PageDeployment]":
        url = f"/repos/{owner}/{repo}/pages/deployment"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoPagesDeploymentPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PageDeployment,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPagesDeploymentPostBodyType,
    ) -> "Response[PageDeployment]":
        ...

    @overload
    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        artifact_url: str,
        environment: Missing[str] = "github-pages",
        pages_build_version: str = "GITHUB_SHA",
        oidc_token: str,
    ) -> "Response[PageDeployment]":
        ...

    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPagesDeploymentPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PageDeployment]":
        url = f"/repos/{owner}/{repo}/pages/deployment"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoPagesDeploymentPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PageDeployment,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_pages_health_check(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PagesHealthCheck]":
        url = f"/repos/{owner}/{repo}/pages/health"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages_health_check(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PagesHealthCheck]":
        url = f"/repos/{owner}/{repo}/pages/health"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    def get_readme(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_releases(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Release]]":
        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Release],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_releases(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Release]]":
        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Release],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesPostBodyType,
    ) -> "Response[Release]":
        ...

    @overload
    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = False,
        prerelease: Missing[bool] = False,
        discussion_category_name: Missing[str] = UNSET,
        generate_release_notes: Missing[bool] = False,
        make_latest: Missing[Literal["true", "false", "legacy"]] = "true",
    ) -> "Response[Release]":
        ...

    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesPostBodyType,
    ) -> "Response[Release]":
        ...

    @overload
    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = False,
        prerelease: Missing[bool] = False,
        discussion_category_name: Missing[str] = UNSET,
        generate_release_notes: Missing[bool] = False,
        make_latest: Missing[Literal["true", "false", "legacy"]] = "true",
    ) -> "Response[Release]":
        ...

    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    def delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
    ) -> "Response[ReleaseAsset]":
        ...

    @overload
    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        label: Missing[str] = UNSET,
        state: Missing[str] = UNSET,
    ) -> "Response[ReleaseAsset]":
        ...

    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesAssetsAssetIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
        )

    @overload
    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
    ) -> "Response[ReleaseAsset]":
        ...

    @overload
    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        label: Missing[str] = UNSET,
        state: Missing[str] = UNSET,
    ) -> "Response[ReleaseAsset]":
        ...

    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesAssetsAssetIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
        )

    @overload
    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ) -> "Response[ReleaseNotesContent]":
        ...

    @overload
    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        previous_tag_name: Missing[str] = UNSET,
        configuration_file_path: Missing[str] = UNSET,
    ) -> "Response[ReleaseNotesContent]":
        ...

    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesGenerateNotesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ReleaseNotesContent]":
        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesGenerateNotesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ) -> "Response[ReleaseNotesContent]":
        ...

    @overload
    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        previous_tag_name: Missing[str] = UNSET,
        configuration_file_path: Missing[str] = UNSET,
    ) -> "Response[ReleaseNotesContent]":
        ...

    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesGenerateNotesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ReleaseNotesContent]":
        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesGenerateNotesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    def get_latest_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
        )

    async def async_get_latest_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
        )

    def get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
    ) -> "Response[Release]":
        ...

    @overload
    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: Missing[str] = UNSET,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = "true",
        discussion_category_name: Missing[str] = UNSET,
    ) -> "Response[Release]":
        ...

    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesReleaseIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
    ) -> "Response[Release]":
        ...

    @overload
    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: Missing[str] = UNSET,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = "true",
        discussion_category_name: Missing[str] = UNSET,
    ) -> "Response[Release]":
        ...

    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesReleaseIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ReleaseAsset]]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ReleaseAsset],
        )

    async def async_list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ReleaseAsset]]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ReleaseAsset],
        )

    def upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        name: str,
        label: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: FileTypes,
        **kwargs,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = parse_obj_as(FileTypes, content)
        content = (
            content.dict(by_alias=True) if isinstance(content, BaseModel) else content
        )

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={},
        )

    async def async_upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        name: str,
        label: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: FileTypes,
        **kwargs,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = parse_obj_as(FileTypes, content)
        content = (
            content.dict(by_alias=True) if isinstance(content, BaseModel) else content
        )

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={},
        )

    def get_branch_rules(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Union[RepositoryRuleCreation, RepositoryRuleUpdate, RepositoryRuleDeletion, RepositoryRuleRequiredLinearHistory, RepositoryRuleRequiredDeployments, RepositoryRuleRequiredSignatures, RepositoryRulePullRequest, RepositoryRuleRequiredStatusChecks, RepositoryRuleNonFastForward, RepositoryRuleCommitMessagePattern, RepositoryRuleCommitAuthorEmailPattern, RepositoryRuleCommitterEmailPattern, RepositoryRuleBranchNamePattern, RepositoryRuleTagNamePattern]]]":
        url = f"/repos/{owner}/{repo}/rules/branches/{branch}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[
                Union[
                    RepositoryRuleCreation,
                    RepositoryRuleUpdate,
                    RepositoryRuleDeletion,
                    RepositoryRuleRequiredLinearHistory,
                    RepositoryRuleRequiredDeployments,
                    RepositoryRuleRequiredSignatures,
                    RepositoryRulePullRequest,
                    RepositoryRuleRequiredStatusChecks,
                    RepositoryRuleNonFastForward,
                    RepositoryRuleCommitMessagePattern,
                    RepositoryRuleCommitAuthorEmailPattern,
                    RepositoryRuleCommitterEmailPattern,
                    RepositoryRuleBranchNamePattern,
                    RepositoryRuleTagNamePattern,
                ]
            ],
        )

    async def async_get_branch_rules(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Union[RepositoryRuleCreation, RepositoryRuleUpdate, RepositoryRuleDeletion, RepositoryRuleRequiredLinearHistory, RepositoryRuleRequiredDeployments, RepositoryRuleRequiredSignatures, RepositoryRulePullRequest, RepositoryRuleRequiredStatusChecks, RepositoryRuleNonFastForward, RepositoryRuleCommitMessagePattern, RepositoryRuleCommitAuthorEmailPattern, RepositoryRuleCommitterEmailPattern, RepositoryRuleBranchNamePattern, RepositoryRuleTagNamePattern]]]":
        url = f"/repos/{owner}/{repo}/rules/branches/{branch}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[
                Union[
                    RepositoryRuleCreation,
                    RepositoryRuleUpdate,
                    RepositoryRuleDeletion,
                    RepositoryRuleRequiredLinearHistory,
                    RepositoryRuleRequiredDeployments,
                    RepositoryRuleRequiredSignatures,
                    RepositoryRulePullRequest,
                    RepositoryRuleRequiredStatusChecks,
                    RepositoryRuleNonFastForward,
                    RepositoryRuleCommitMessagePattern,
                    RepositoryRuleCommitAuthorEmailPattern,
                    RepositoryRuleCommitterEmailPattern,
                    RepositoryRuleBranchNamePattern,
                    RepositoryRuleTagNamePattern,
                ]
            ],
        )

    def get_repo_rulesets(
        self,
        owner: str,
        repo: str,
        includes_parents: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RepositoryRuleset]]":
        url = f"/repos/{owner}/{repo}/rulesets"

        params = {
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_rulesets(
        self,
        owner: str,
        repo: str,
        includes_parents: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RepositoryRuleset]]":
        url = f"/repos/{owner}/{repo}/rulesets"

        params = {
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoRulesetsPostBodyType,
    ) -> "Response[RepositoryRuleset]":
        ...

    @overload
    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_mode: Missing[Literal["none", "repository", "organization"]] = UNSET,
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                ]
            ]
        ] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryRuleset]":
        url = f"/repos/{owner}/{repo}/rulesets"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoRulesetsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoRulesetsPostBodyType,
    ) -> "Response[RepositoryRuleset]":
        ...

    @overload
    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_mode: Missing[Literal["none", "repository", "organization"]] = UNSET,
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                ]
            ]
        ] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryRuleset]":
        url = f"/repos/{owner}/{repo}/rulesets"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoRulesetsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        includes_parents: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepositoryRuleset]":
        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        params = {
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        includes_parents: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepositoryRuleset]":
        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        params = {
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    @overload
    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_mode: Missing[Literal["none", "repository", "organization"]] = UNSET,
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                ]
            ]
        ] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryRuleset]":
        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoRulesetsRulesetIdPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    @overload
    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_mode: Missing[Literal["none", "repository", "organization"]] = UNSET,
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                ]
            ]
        ] = UNSET,
    ) -> "Response[RepositoryRuleset]":
        ...

    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryRuleset]":
        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoRulesetsRulesetIdPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def delete_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[List[int]],
        )

    async def async_get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[List[int]],
        )

    def get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[CommitActivity]]":
        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[CommitActivity],
        )

    async def async_get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[CommitActivity]]":
        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[CommitActivity],
        )

    def get_contributors_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ContributorActivity]]":
        url = f"/repos/{owner}/{repo}/stats/contributors"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ContributorActivity],
        )

    async def async_get_contributors_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ContributorActivity]]":
        url = f"/repos/{owner}/{repo}/stats/contributors"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ContributorActivity],
        )

    def get_participation_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ParticipationStats]":
        url = f"/repos/{owner}/{repo}/stats/participation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_participation_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ParticipationStats]":
        url = f"/repos/{owner}/{repo}/stats/participation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    def get_punch_card_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/punch_card"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[List[int]],
        )

    async def async_get_punch_card_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/punch_card"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[List[int]],
        )

    @overload
    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoStatusesShaPostBodyType,
    ) -> "Response[Status]":
        ...

    @overload
    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Missing[Union[str, None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        context: Missing[str] = "default",
    ) -> "Response[Status]":
        ...

    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoStatusesShaPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Status]":
        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoStatusesShaPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Status,
        )

    @overload
    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoStatusesShaPostBodyType,
    ) -> "Response[Status]":
        ...

    @overload
    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Missing[Union[str, None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        context: Missing[str] = "default",
    ) -> "Response[Status]":
        ...

    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoStatusesShaPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Status]":
        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoStatusesShaPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Status,
        )

    def list_tags(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Tag]]":
        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Tag],
        )

    async def async_list_tags(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Tag]]":
        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Tag],
        )

    def list_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[TagProtection]]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[TagProtection]]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTagsProtectionPostBodyType,
    ) -> "Response[TagProtection]":
        ...

    @overload
    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        pattern: str,
    ) -> "Response[TagProtection]":
        ...

    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTagsProtectionPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TagProtection]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTagsProtectionPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTagsProtectionPostBodyType,
    ) -> "Response[TagProtection]":
        ...

    @overload
    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        pattern: str,
    ) -> "Response[TagProtection]":
        ...

    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTagsProtectionPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TagProtection]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTagsProtectionPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    def list_teams(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
        )

    async def async_list_teams(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
        )

    def get_all_topics(
        self,
        owner: str,
        repo: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_topics(
        self,
        owner: str,
        repo: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTopicsPutBodyType,
    ) -> "Response[Topic]":
        ...

    @overload
    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        names: List[str],
    ) -> "Response[Topic]":
        ...

    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTopicsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTopicsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTopicsPutBodyType,
    ) -> "Response[Topic]":
        ...

    @overload
    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        names: List[str],
    ) -> "Response[Topic]":
        ...

    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTopicsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTopicsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_clones(
        self,
        owner: str,
        repo: str,
        per: Missing[Literal["day", "week"]] = "day",
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CloneTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_clones(
        self,
        owner: str,
        repo: str,
        per: Missing[Literal["day", "week"]] = "day",
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[CloneTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    def get_top_paths(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ContentTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_paths(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ContentTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_top_referrers(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ReferrerTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_referrers(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ReferrerTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_views(
        self,
        owner: str,
        repo: str,
        per: Missing[Literal["day", "week"]] = "day",
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ViewTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_views(
        self,
        owner: str,
        repo: str,
        per: Missing[Literal["day", "week"]] = "day",
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ViewTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTransferPostBodyType,
    ) -> "Response[MinimalRepository]":
        ...

    @overload
    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        new_owner: str,
        new_name: Missing[str] = UNSET,
        team_ids: Missing[List[int]] = UNSET,
    ) -> "Response[MinimalRepository]":
        ...

    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTransferPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[MinimalRepository]":
        url = f"/repos/{owner}/{repo}/transfer"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTransferPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MinimalRepository,
        )

    @overload
    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTransferPostBodyType,
    ) -> "Response[MinimalRepository]":
        ...

    @overload
    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        new_owner: str,
        new_name: Missing[str] = UNSET,
        team_ids: Missing[List[int]] = UNSET,
    ) -> "Response[MinimalRepository]":
        ...

    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTransferPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[MinimalRepository]":
        url = f"/repos/{owner}/{repo}/transfer"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTransferPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MinimalRepository,
        )

    def check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ) -> "Response[Repository]":
        ...

    @overload
    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        owner: Missing[str] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        include_all_branches: Missing[bool] = False,
        private: Missing[bool] = False,
    ) -> "Response[Repository]":
        ...

    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposTemplateOwnerTemplateRepoGeneratePostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Repository]":
        url = f"/repos/{template_owner}/{template_repo}/generate"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposTemplateOwnerTemplateRepoGeneratePostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Repository,
        )

    @overload
    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ) -> "Response[Repository]":
        ...

    @overload
    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        owner: Missing[str] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        include_all_branches: Missing[bool] = False,
        private: Missing[bool] = False,
    ) -> "Response[Repository]":
        ...

    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposTemplateOwnerTemplateRepoGeneratePostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Repository]":
        url = f"/repos/{template_owner}/{template_repo}/generate"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposTemplateOwnerTemplateRepoGeneratePostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Repository,
        )

    def list_public(
        self,
        since: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MinimalRepository]]":
        url = "/repositories"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_public(
        self,
        since: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MinimalRepository]]":
        url = "/repositories"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        visibility: Missing[Literal["all", "public", "private"]] = "all",
        affiliation: Missing[str] = "owner,collaborator,organization_member",
        type: Missing[Literal["all", "owner", "public", "private", "member"]] = "all",
        sort: Missing[
            Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Repository]]":
        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        visibility: Missing[Literal["all", "public", "private"]] = "all",
        affiliation: Missing[str] = "owner,collaborator,organization_member",
        type: Missing[Literal["all", "owner", "public", "private", "member"]] = "all",
        sort: Missing[
            Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Repository]]":
        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_for_authenticated_user(
        self, *, headers: Optional[Dict[str, str]] = None, data: UserReposPostBodyType
    ) -> "Response[Repository]":
        ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = False,
        has_issues: Missing[bool] = True,
        has_projects: Missing[bool] = True,
        has_wiki: Missing[bool] = True,
        has_discussions: Missing[bool] = False,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = False,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = True,
        allow_merge_commit: Missing[bool] = True,
        allow_rebase_merge: Missing[bool] = True,
        allow_auto_merge: Missing[bool] = False,
        delete_branch_on_merge: Missing[bool] = False,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        has_downloads: Missing[bool] = True,
        is_template: Missing[bool] = False,
    ) -> "Response[Repository]":
        ...

    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserReposPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Repository]":
        url = "/user/repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserReposPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Repository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self, *, headers: Optional[Dict[str, str]] = None, data: UserReposPostBodyType
    ) -> "Response[Repository]":
        ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = False,
        has_issues: Missing[bool] = True,
        has_projects: Missing[bool] = True,
        has_wiki: Missing[bool] = True,
        has_discussions: Missing[bool] = False,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = False,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = True,
        allow_merge_commit: Missing[bool] = True,
        allow_rebase_merge: Missing[bool] = True,
        allow_auto_merge: Missing[bool] = False,
        delete_branch_on_merge: Missing[bool] = False,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        has_downloads: Missing[bool] = True,
        is_template: Missing[bool] = False,
    ) -> "Response[Repository]":
        ...

    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserReposPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Repository]":
        url = "/user/repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserReposPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Repository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    def list_invitations_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RepositoryInvitation]]":
        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_invitations_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RepositoryInvitation]]":
        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    async def async_accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        type: Missing[Literal["all", "owner", "member"]] = "owner",
        sort: Missing[
            Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    async def async_list_for_user(
        self,
        username: str,
        type: Missing[Literal["all", "owner", "member"]] = "owner",
        sort: Missing[
            Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )
