"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Dict, List, Literal, Optional, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Missing, exclude_unset

from .types import (
    ReposOwnerRepoCommentsCommentIdReactionsPostBodyType,
    ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType,
    ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType,
    ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType,
    ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType,
    TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType,
    TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
)
from .models import (
    Reaction,
    BasicError,
    ValidationError,
    ReposOwnerRepoCommentsCommentIdReactionsPostBody,
    ReposOwnerRepoIssuesIssueNumberReactionsPostBody,
    ReposOwnerRepoReleasesReleaseIdReactionsPostBody,
    ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody,
    ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody,
    TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody,
    TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class ReactionsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    async def async_list_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    @overload
    def create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    def create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    def create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    async def async_create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    async def async_create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    def delete_for_team_discussion_comment(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_team_discussion_comment(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    async def async_list_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    @overload
    def create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    def create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    def create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    async def async_create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    async def async_create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    def delete_for_team_discussion(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_team_discussion(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommentsCommentIdReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    def create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    def create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommentsCommentIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCommentsCommentIdReactionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommentsCommentIdReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    async def async_create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    async def async_create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommentsCommentIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCommentsCommentIdReactionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    def create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    def create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    async def async_create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    async def async_create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    def create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    def create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesIssueNumberReactionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    async def async_create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    async def async_create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoIssuesIssueNumberReactionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    def create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    def create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    async def async_create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    async def async_create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_pull_request_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_pull_request_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = (
            f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        content: Missing[
            Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        content: Missing[
            Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    def create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"],
    ) -> "Response[Reaction]":
        ...

    def create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesReleaseIdReactionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    async def async_create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"],
    ) -> "Response[Reaction]":
        ...

    async def async_create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesReleaseIdReactionsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    async def async_list_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    @overload
    def create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    def create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    def create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    async def async_create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    async def async_create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    def list_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    async def async_list_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Reaction]]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    @overload
    def create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    def create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    def create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> "Response[Reaction]":
        ...

    @overload
    async def async_create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> "Response[Reaction]":
        ...

    async def async_create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[Reaction]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )
